/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class ContextDataMap
implements Map<String, Object> {
    private final Set<Annotation> interceptorBindings;
    private HashMap<String, Object> delegate;

    ContextDataMap(Set<Annotation> interceptorBindings) {
        this.interceptorBindings = Objects.requireNonNull(interceptorBindings);
    }

    private Map<String, Object> getDelegateForRead() {
        if (this.delegate == null) {
            return Collections.emptyMap();
        }
        return this.delegate;
    }

    private Map<String, Object> getDelegateForWrite(int sizeHint) {
        if (this.delegate == null) {
            this.delegate = new HashMap(sizeHint, 1.0f);
        }
        return this.delegate;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not allowed to clear the context data map");
    }

    @Override
    public boolean containsKey(Object key) {
        if ("io.quarkus.arc.interceptorBindings".equals(key)) {
            return true;
        }
        return this.getDelegateForRead().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.interceptorBindings.equals(value)) {
            return true;
        }
        return this.getDelegateForRead().containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        AbstractMap.SimpleImmutableEntry<String, Set<Annotation>> firstEntry = new AbstractMap.SimpleImmutableEntry<String, Set<Annotation>>("io.quarkus.arc.interceptorBindings", this.interceptorBindings);
        if (this.delegate == null) {
            return Collections.singleton(firstEntry);
        }
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>(this.delegate.size() + 1);
        entries.addAll(this.delegate.entrySet());
        entries.add(firstEntry);
        return entries;
    }

    @Override
    public Object get(Object key) {
        if ("io.quarkus.arc.interceptorBindings".equals(key)) {
            return this.interceptorBindings;
        }
        return this.getDelegateForRead().get(key);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        if (this.delegate == null) {
            return Collections.singleton("io.quarkus.arc.interceptorBindings");
        }
        HashSet<String> set = new HashSet<String>(this.delegate.size() + 1);
        set.addAll(this.delegate.keySet());
        set.add("io.quarkus.arc.interceptorBindings");
        return set;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m.containsKey("io.quarkus.arc.interceptorBindings")) {
            throw new IllegalArgumentException("Not allowed to put key 'io.quarkus.arc.interceptorBindings' in the context data map");
        }
        this.getDelegateForWrite(m.size()).putAll(m);
    }

    @Override
    public Object remove(Object key) {
        if ("io.quarkus.arc.interceptorBindings".equals(key)) {
            throw new IllegalArgumentException("Not allowed to remove key 'io.quarkus.arc.interceptorBindings' from the context data map");
        }
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.getDelegateForRead().size() + 1;
    }

    @Override
    public Collection<Object> values() {
        if (this.delegate == null) {
            return Collections.singleton(this.interceptorBindings);
        }
        ArrayList<Object> list = new ArrayList<Object>(this.delegate.size() + 1);
        list.addAll(this.delegate.values());
        list.add(this.interceptorBindings);
        return list;
    }

    @Override
    public Object put(String key, Object value) {
        if ("io.quarkus.arc.interceptorBindings".equals(key)) {
            throw new IllegalArgumentException("Not allowed to put key 'io.quarkus.arc.interceptorBindings' in the context data map");
        }
        return this.getDelegateForWrite(1).put(key, value);
    }
}

