/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.spi;

import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.sql.ast.tree.from.RootTableGroupProducer;

public interface Loadable
extends ModelPart,
RootTableGroupProducer {
    public String getRootPathName();

    @Deprecated(forRemoval=true)
    default public boolean isAffectedByInfluencers(LoadQueryInfluencers influencers) {
        return this.isAffectedByInfluencers(influencers, false);
    }

    default public boolean isAffectedByInfluencers(LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKeyFilters) {
        return this.isAffectedByEntityGraph(influencers) || this.isAffectedByEnabledFetchProfiles(influencers) || this.isAffectedByEnabledFilters(influencers, onlyApplyForLoadByKeyFilters) || this.isAffectedByBatchSize(influencers);
    }

    default public boolean isNotAffectedByInfluencers(LoadQueryInfluencers influencers) {
        return !this.isAffectedByEntityGraph(influencers) && !this.isAffectedByEnabledFetchProfiles(influencers) && !this.isAffectedByEnabledFilters(influencers) && !this.isAffectedByBatchSize(influencers) && influencers.getEnabledCascadingFetchProfile() == null;
    }

    private boolean isAffectedByBatchSize(LoadQueryInfluencers influencers) {
        return influencers.getBatchSize() > 0 && influencers.getBatchSize() != this.getBatchSize();
    }

    public int getBatchSize();

    @Deprecated(forRemoval=true)
    default public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.isAffectedByEnabledFilters(influencers, false);
    }

    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers var1, boolean var2);

    public boolean isAffectedByEntityGraph(LoadQueryInfluencers var1);

    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers var1);
}

