/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.util.Comparator;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractTemporalJavaType<T>
extends AbstractClassJavaType<T>
implements TemporalJavaType<T> {
    protected AbstractTemporalJavaType(Class<? extends T> type) {
        super(type);
    }

    protected AbstractTemporalJavaType(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan) {
        super(type, mutabilityPlan);
    }

    public AbstractTemporalJavaType(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan, Comparator<? extends T> comparator) {
        super(type, mutabilityPlan, comparator);
    }

    @Override
    public final <X> TemporalJavaType<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration typeConfiguration) {
        if (precision == null) {
            return this.forMissingPrecision(typeConfiguration);
        }
        switch (precision) {
            case DATE: {
                return this.forDatePrecision(typeConfiguration);
            }
            case TIME: {
                return this.forTimePrecision(typeConfiguration);
            }
            case TIMESTAMP: {
                return this.forTimestampPrecision(typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + String.valueOf(precision) + "]");
    }

    private <X> TemporalJavaType<X> forMissingPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(String.valueOf(this) + " as `jakarta.persistence.TemporalType.TIMESTAMP` not supported");
    }

    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(String.valueOf(this) + " as `jakarta.persistence.TemporalType.DATE` not supported");
    }

    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(String.valueOf(this) + " as `jakarta.persistence.TemporalType.TIME` not supported");
    }

    public String toString() {
        return "TemporalJavaType(javaType=" + this.getTypeName() + ")";
    }
}

