/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtils {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    @NotNull
    public static Object sentinel(@NotNull @NonNls String name2) {
        if (name2 == null) {
            ObjectUtils.$$$reportNull$$$0(0);
        }
        return new Sentinel(name2);
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @Contract(value="null, _ -> param2; !null, _ -> param1", pure=true)
    @NotNull
    public static <T> T notNull(@Nullable T value2, @NotNull T defaultValue) {
        if (defaultValue == null) {
            ObjectUtils.$$$reportNull$$$0(7);
        }
        T t2 = value2 == null ? defaultValue : value2;
        if (t2 == null) {
            ObjectUtils.$$$reportNull$$$0(8);
        }
        return t2;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            ObjectUtils.$$$reportNull$$$0(11);
        }
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T> T nullizeIfDefaultValue(@Nullable T obj, @NotNull T defaultValue) {
        if (defaultValue == null) {
            ObjectUtils.$$$reportNull$$$0(19);
        }
        return obj == defaultValue ? null : (T)obj;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntUnaryOperator indexComparator) {
        if (indexComparator == null) {
            ObjectUtils.$$$reportNull$$$0(20);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.applyAsInt(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    public static String objectInfo(@Nullable Object o2) {
        return o2 != null ? o2 + " (" + o2.getClass().getName() + ")" : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ofInterface";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexComparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sentinel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sentinel";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertAllElementsNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "coalesce";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doIfCast";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doIfNotNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfNotNull";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfCast";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nullizeByCondition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "nullizeIfDefaultValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Sentinel {
        private final String myName;

        Sentinel(@NotNull String name2) {
            if (name2 == null) {
                Sentinel.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ObjectUtils$Sentinel", "<init>"));
        }
    }
}

