/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;

class CancelLock
implements Diagnosable {
    private static final String CLASS_NAME = CancelLock.class.getName();
    private CancelState state = null;
    private OracleStatement statement = null;

    CancelLock(OracleStatement stmt) {
        this.statement = stmt;
        this.state = new CancelState();
    }

    boolean isIdle() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isIdle();
            return bl;
        }
    }

    boolean isCanceled() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isCanceled();
            return bl;
        }
    }

    void enterExecuting() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * Unable to fully structure code
     */
    void exitExecuting() {
        while (true) lbl-1000:
        // 5 sources

        {
            block13: {
                block12: {
                    lock = this.state.acquireCloseableLock();
                    if (!this.state.isExecuting()) break block12;
                    this.state.setIdle();
                    if (lock == null) break;
                    lock.close();
                    break;
                }
                if (!this.state.isCanceling()) break block13;
                try {
                    this.state.monitorWait();
                }
                finally {
                    if (lock == null) ** GOTO lbl-1000
                    lock.close();
                }
            }
            try {
                if (!this.state.isCanceled()) continue;
                if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CancelLock.CLASS_NAME, "exitExecuting", "Cancel still in progress ...", null, null);
                }
                this.state.setIdle();
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            break;
        }
    }

    boolean enterCanceling() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    void exitCanceling() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.monitorNotify();
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.statement.getDiagnosable();
    }
}

