# - Config file for the rocdecode package
# It defines the following variables
#  use rocdecode_INCLUDE_DIR or ROCDECODE_INCLUDE_DIR  - include directory for rocdecode
#  use rocdecode_LIB_DIR     or ROCDECODE_LIB_DIR      - library directory for rocdecode
#  use rocdecode_LIBRARY     or ROCDECODE_LIBRARY      - library to link against
#  use rocdecode_LIBRARIES   or ROCDECODE_LIBRARIES    - library to link against

# compute paths
get_filename_component(rocdecode_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rocdecode-config-version.cmake)
set(rocdecode_VERSION ${PACKAGE_VERSION})

# targets
include(${CMAKE_CURRENT_LIST_DIR}/rocdecode-targets.cmake)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocdecode-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocdecode_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocdecode_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(rocdecode_LIBRARY "${PACKAGE_PREFIX_DIR}/lib/librocdecode.so")
set_and_check(rocdecode_LIBRARIES "${PACKAGE_PREFIX_DIR}/lib/librocdecode.so")

if(NOT TARGET rocdecode::rocdecode)
  add_library(rocdecode::rocdecode INTERFACE IMPORTED)
  set_target_properties(rocdecode::rocdecode PROPERTIES INTERFACE_LINK_LIBRARIES ${rocdecode_LIBRARY})
endif ()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocdecode
    FOUND_VAR rocdecode_FOUND
    REQUIRED_VARS rocdecode_INCLUDE_DIR rocdecode_LIB_DIR rocdecode_LIBRARY rocdecode_LIBRARIES
    VERSION_VAR rocdecode_VERSION
    HANDLE_COMPONENTS)
