﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sns/SNS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace SNS {
namespace Model {

/**
 * <p>A wrapper type for the attributes of an Amazon SNS
 * subscription.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscription">AWS
 * API Reference</a></p>
 */
class Subscription {
 public:
  AWS_SNS_API Subscription() = default;
  AWS_SNS_API Subscription(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_SNS_API Subscription& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_SNS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_SNS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The subscription's ARN.</p>
   */
  inline const Aws::String& GetSubscriptionArn() const { return m_subscriptionArn; }
  inline bool SubscriptionArnHasBeenSet() const { return m_subscriptionArnHasBeenSet; }
  template <typename SubscriptionArnT = Aws::String>
  void SetSubscriptionArn(SubscriptionArnT&& value) {
    m_subscriptionArnHasBeenSet = true;
    m_subscriptionArn = std::forward<SubscriptionArnT>(value);
  }
  template <typename SubscriptionArnT = Aws::String>
  Subscription& WithSubscriptionArn(SubscriptionArnT&& value) {
    SetSubscriptionArn(std::forward<SubscriptionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subscription's owner.</p>
   */
  inline const Aws::String& GetOwner() const { return m_owner; }
  inline bool OwnerHasBeenSet() const { return m_ownerHasBeenSet; }
  template <typename OwnerT = Aws::String>
  void SetOwner(OwnerT&& value) {
    m_ownerHasBeenSet = true;
    m_owner = std::forward<OwnerT>(value);
  }
  template <typename OwnerT = Aws::String>
  Subscription& WithOwner(OwnerT&& value) {
    SetOwner(std::forward<OwnerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subscription's protocol.</p>
   */
  inline const Aws::String& GetProtocol() const { return m_protocol; }
  inline bool ProtocolHasBeenSet() const { return m_protocolHasBeenSet; }
  template <typename ProtocolT = Aws::String>
  void SetProtocol(ProtocolT&& value) {
    m_protocolHasBeenSet = true;
    m_protocol = std::forward<ProtocolT>(value);
  }
  template <typename ProtocolT = Aws::String>
  Subscription& WithProtocol(ProtocolT&& value) {
    SetProtocol(std::forward<ProtocolT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subscription's endpoint (format depends on the protocol).</p>
   */
  inline const Aws::String& GetEndpoint() const { return m_endpoint; }
  inline bool EndpointHasBeenSet() const { return m_endpointHasBeenSet; }
  template <typename EndpointT = Aws::String>
  void SetEndpoint(EndpointT&& value) {
    m_endpointHasBeenSet = true;
    m_endpoint = std::forward<EndpointT>(value);
  }
  template <typename EndpointT = Aws::String>
  Subscription& WithEndpoint(EndpointT&& value) {
    SetEndpoint(std::forward<EndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the subscription's topic.</p>
   */
  inline const Aws::String& GetTopicArn() const { return m_topicArn; }
  inline bool TopicArnHasBeenSet() const { return m_topicArnHasBeenSet; }
  template <typename TopicArnT = Aws::String>
  void SetTopicArn(TopicArnT&& value) {
    m_topicArnHasBeenSet = true;
    m_topicArn = std::forward<TopicArnT>(value);
  }
  template <typename TopicArnT = Aws::String>
  Subscription& WithTopicArn(TopicArnT&& value) {
    SetTopicArn(std::forward<TopicArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_subscriptionArn;

  Aws::String m_owner;

  Aws::String m_protocol;

  Aws::String m_endpoint;

  Aws::String m_topicArn;
  bool m_subscriptionArnHasBeenSet = false;
  bool m_ownerHasBeenSet = false;
  bool m_protocolHasBeenSet = false;
  bool m_endpointHasBeenSet = false;
  bool m_topicArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SNS
}  // namespace Aws
