---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトの作成
description: 新しいプロジェクトとプロジェクトテンプレート。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プロジェクトを作成するには、いくつかのオプションがあります。空のプロジェクトを作成する、組み込みまたはカスタムテンプレートからプロジェクトを作成する、[`git push`でプロジェクトを作成する](../../topics/git/project.md)といったことができます。

## 空のプロジェクトを作成する {#create-a-blank-project}

空のプロジェクトを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します:
   1. **プロジェクト名**: プロジェクトの名前を入力します。詳細については、[命名規則](../reserved_names.md#rules-for-usernames-project-and-group-names-and-slugs)を参照してください。
   1. **プロジェクトslug**: プロジェクトのパスを入力します。GitLabは、URLパスとしてslugを使用します。
   1. **プロジェクトのデプロイ先(オプション)**: プロジェクトを特定の環境にデプロイする場合は、関連するデプロイ先を選択します。
   1. **表示レベル**: 適切な表示レベルを選択します。ユーザーの[表示およびアクセス権](../public_access.md)を参照してください。
   1. **リポジトリを初期化しREADMEファイルを生成する**: このオプションを選択すると、Gitリポジトリを初期化し、デフォルトブランチを作成して、このプロジェクトのリポジトリのクローンを作成できるようになります。
   1. **静的アプリケーションセキュリティテスト (SAST) を有効にする**: このオプションを選択すると、既知のセキュリティの脆弱性に関するソースコードが分析されます。
   1. **シークレット検出を有効にする**: このオプションを選択して、ソースコードのシークレットと認証情報を分析し、承認されていないアクセスを防ぎます。
1. **プロジェクトを作成**を選択します。

## 組み込みのテンプレートからプロジェクトを作成する {#create-a-project-from-a-built-in-template}

組み込みのテンプレートは、新しいプロジェクトにファイルを取り込み、作成開始を支援します。これらのテンプレートは、[`project-templates`](https://gitlab.com/gitlab-org/project-templates)グループと[`pages`](https://gitlab.com/pages)グループから提供されています。誰でも組み込みプロジェクトテンプレートにコントリビュートできます。

組み込みのテンプレートからプロジェクトを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **テンプレートから作成**を選択します。
1. **ビルトイン**タブを選択します。
1. テンプレートのリストで次のように選択します:
   - テンプレートをプレビューするには、**プレビュー**を選択します。
   - テンプレートを使用するには、**テンプレートを使用**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**: プロジェクトの名前を入力します。
   - **プロジェクトslug**: プロジェクトのパスを入力します。GitLabは、URLパスとしてslugを使用します。
   - **プロジェクトの説明 (オプション)**プロジェクトの説明を入力します。文字の上限は500字です。
   - **表示レベル**: 適切な表示レベルを選択します。ユーザーの[表示およびアクセス権](../public_access.md)を参照してください。
1. **プロジェクトを作成**を選択します。

{{< alert type="note" >}}

ユーザーがテンプレートからプロジェクトを作成するか、[プロジェクトをインポートする](settings/import_export.md#import-a-project-and-its-data)と、そのユーザーはインポートされたアイテムの作成者として表示されます。この際、テンプレートまたはインポートの元のタイムスタンプが保持されます。これが原因で、アイテムがユーザーのアカウントが存在するより前に作成されたかのように表示されることがあります。

{{< /alert >}}

インポートされたオブジェクトには、`By <username> on <timestamp>`というラベルが付きます。GitLab 17.1より前では、ラベルの末尾に`(imported from GitLab)`が付いていました。

### HIPAA監査プロトコルテンプレートからプロジェクトを作成する {#create-a-project-from-the-hipaa-audit-protocol-template}

HIPAA監査プロトコルテンプレートには、米国保健福祉省が発行したHIPAA監査プロトコルの監査照会に関するイシューが含まれています。

HIPAA監査プロトコルテンプレートからプロジェクトを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **テンプレートから作成**を選択します。
1. **ビルトイン**タブを選択します。
1. **HIPAA監査プロトコル**テンプレートを見つけて、次のように選択します:
   - テンプレートをプレビューするには、**プレビュー**を選択します。
   - テンプレートを使用するには、**テンプレートを使用**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**: プロジェクトの名前を入力します。
   - **プロジェクトslug**: プロジェクトのパスを入力します。GitLabは、URLパスとしてslugを使用します。
   - **プロジェクトの説明 (オプション)**プロジェクトの説明を入力します。文字の上限は500字です。
   - **表示レベル**: 適切な表示レベルを選択します。ユーザーの[表示およびアクセス権](../public_access.md)を参照してください。
1. **プロジェクトを作成**を選択します。

## カスタムテンプレートからプロジェクトを作成する {#create-a-project-from-a-custom-template}

カスタムプロジェクトテンプレートは、[インスタンス](../../administration/custom_project_templates.md)および[グループ](../group/custom_project_templates.md)で使用できます。

カスタムテンプレートからプロジェクトを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **テンプレートから作成**を選択します。
1. **インスタンス**または**グループ**タブを選択します。
1. テンプレートのリストで次のように選択します:
   - テンプレートをプレビューするには、**プレビュー**を選択します。
   - テンプレートを使用するには、**テンプレートを使用**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**: プロジェクトの名前を入力します。
   - **プロジェクトslug**: プロジェクトのパスを入力します。GitLabは、URLパスとしてslugを使用します。
   - **プロジェクトの説明 (オプション)**プロジェクトの説明を入力します。文字の上限は500字です。
   - **表示レベル**: 適切な表示レベルを選択します。ユーザーの[表示およびアクセス権](../public_access.md)を参照してください。
1. **プロジェクトを作成**を選択します。

## SHA-256ハッシュを使用するプロジェクトを作成する {#create-a-project-that-uses-sha-256-hashing}

{{< details >}}

- ステータス: 実験的機能

{{< /details >}}

{{< history >}}

- GitLab 16.7で`support_sha256_repositories`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/431864)されました。デフォルトでは無効になっています。これは[実験的機能](../../policy/development_stages_support.md#experiment)です。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

プロジェクトの作成時にのみ、プロジェクトのSHA-256ハッシュを選択できます。Gitでは、後でSHA-256に移行したり、元のSHA-1に移行したりといった操作をサポートしていません。

SHA-256ハッシュを使用するプロジェクトを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**: プロジェクトの名前を入力します。
   - **プロジェクトslug**: プロジェクトのパスを入力します。GitLabは、URLパスとしてslugを使用します。
   - **プロジェクトの説明 (オプション)**プロジェクトの説明を入力します。文字の上限は500字です。
   - **表示レベル**: 適切な表示レベルを選択します。ユーザーの[表示およびアクセス権](../public_access.md)を参照してください。
1. **プロジェクトの設定**エリアで、**試験版の設定**を展開します。
1. **Use SHA-256 as the repository hashing algorithm**（リポジトリのハッシュアルゴリズムとしてSHA-256を使用）を選択します。
1. **プロジェクトを作成**を選択します。

### SHA-256を選択する理由 {#why-sha-256}

デフォルトでは、GitはSHA-1ハッシュアルゴリズムを使用して、コミット、blob、ツリー、タグなどのオブジェクトに40文字のIDを生成します。[Googleがハッシュコリジョンを生成できる](https://security.googleblog.com/2017/02/announcing-first-sha1-collision.html)場合、SHA-1アルゴリズムは脆弱であることが証明されました。Gitプロジェクトは、Gitのオブジェクト保存方法のおかげで、これらの種類の攻撃による影響をまだ受けていません。

SHA-256リポジトリでは、アルゴリズムは40文字ではなく64文字のIDを生成します。Gitプロジェクトでは、[実験ラベルを削除した](https://github.com/git/git/blob/master/Documentation/RelNotes/2.42.0.txt#L41-L45)際、SHA-256機能を安全に使用できると判断しました。

[FedRAMP](https://www.fedramp.gov/)が実施するNISTやCISA[ガイドライン](https://csrc.nist.gov/projects/hash-functions/nist-policy-on-hash-functions)などの連邦規制では、2030年に設定した期限までに各機関がSHA-1の使用を停止し、可能であれば早期にSHA-1から移行することを推奨しています。

## 関連トピック {#related-topics}

- [`git push`を使用してプロジェクトを作成する](../../topics/git/project.md)
- [予約済みのプロジェクト名とグループ名](../reserved_names.md)
- [プロジェクトとグループの命名規則](../reserved_names.md#rules-for-usernames-project-and-group-names-and-slugs)
- [プロジェクトを管理する](working_with_projects.md)
