---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Cross Site Scripting
---

## Description

Cross Site Scripting (XSS) is an attack which exploits a web application or system to treat user input
as markup or script code. It is important to encode the data depending on the specific context it
is used in. There are at least six context types:

- Inside HTML tags `<div>context 1</div>`
- Inside attributes: ```<div class="context 2"></div>```
- Inside event attributes ```<button onclick="context 3">button</button>```
- Inside script blocks: ```<script>var x = "context 4"</script>```
- Unsafe element HTML assignment: ```element.innerHTML = "context 5"```
- Inside URLs: ```<iframe src="context 6"></iframe><a href="context 6">link</a>```

Script blocks alone can be encoded in multiple ways. Exercise caution if user
input must be written outside script tags.

## Remediation

User input displayed in the application must be encoded, sanitized, or validated
so it isn't treated as HTML or executed as JavaScript code. Be careful not to
mix server-side templating with client-side templating, because the server-side doesn't encode
text like `{{ 7*7 }}`, which might execute client-side features.

Do not encode user input before inserting it into a data store. The data must be
encoded based on its output context. It is much safer to force the displaying system to
handle the encoding.

Consider using built-in framework capabilities for automatically encoding user input. If you can't
automatically encode input, be careful to use the proper output encoding. The following recommendations
are a best effort, and might not work in all circumstances.

- Encode the following inside HTML tags, excluding `script`:
  - `<` to `&lt;`
  - `>` to `&gt;`
  - `'` to `&apos;`
  - `"` to `&quot;`
  - `=` to `&#61;`
- Encode the following inside attributes, excluding event attributes:
  - `<` to `&lt;`
  - `>` to `&gt;`
  - `'` to `&apos;`
  - `"` to `&quot;`
  - `=` to `&#61;`
- Encode the following inside event attributes, script blocks, and unsafe HTML assignment:
  - Literal tab (`\t`) to `\\t`
  - Literal new line (`\n`) to `\\n`
  - Literal vertical tab (`\v`) to `\u000b`
  - Literal form feed (`\f`) to `\\f`
  - Literal carriage return (`\r`) to `\\r`
  - Literal equal sign (`=`) to `\u0061`
  - Literal back tick (`\`) to `\u0060`
  - Literal double quote (`"`) to `\u0022`
  - Literal ampersand (`&`) to `\u0026`
  - Literal single quote (`'`) to `\u0027`
  - Literal plus symbol (`+`) to `\u002b`
  - Literal forward slash (`/`) to `\/`
  - Literal less than symbol (`<`) to `\u003c`
  - Literal greater than symbol (`>`) to `\u003e`
  - Literal open parenthesis (`(`) to `\u0028`
  - Literal close parenthesis (`)`) to `\u0029`
  - Literal open bracket (`[`) to `\u005b`
  - Literal close bracket (`]`) to `\u005d`
  - Literal open brace (`{`) to `\u007b`
  - Literal close brace (`}`) to `\u007d`
  - Literal back slash (`\`) to `\\`

  This list is not exhaustive. You might need to encode additional characters depending on context.
- Inside URLs:
  - Never allow user input to be printed in URLs. Attackers could inject `javascript:...` code or malicious links.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 79.1 | false | 79 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/attacks/xss/)
- [CWE](https://cwe.mitre.org/data/definitions/79.html)
