---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Discord client ID'
---

## Description

The response body contains content that matches the pattern of a Discord client ID was identified. Client IDs are used in OAuth applications and are used in combination with a client secret. This value alone does not grant any access and must be used alongside the client secret value.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). You cannot revoke a Discord client ID. Instead you must generate an entire new Discord application.

For more information, please see [Discord's documentation on OAuth](https://discord.com/developers/docs/topics/oauth2).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.27 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
