/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.execution.BuildTaskScheduler;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNameResolvingBuildTaskScheduler
implements BuildTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildTaskScheduler.class);
    private final CommandLineTaskParser commandLineTaskParser;
    private final BuildTaskSelector.BuildSpecificSelector taskSelector;
    private final List<BuiltInCommand> builtInCommands;
    private final InternalProblems problemsService;

    public TaskNameResolvingBuildTaskScheduler(CommandLineTaskParser commandLineTaskParser, BuildTaskSelector.BuildSpecificSelector taskSelector, List<BuiltInCommand> builtInCommands, InternalProblems problemsService) {
        this.commandLineTaskParser = commandLineTaskParser;
        this.taskSelector = taskSelector;
        this.builtInCommands = builtInCommands;
        this.problemsService = problemsService;
    }

    @Override
    public void scheduleRequestedTasks(GradleInternal gradle, @Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        if (selector != null) {
            selector.applyTasksTo(new EntryTaskSelectorContext(gradle), plan);
        }
        List taskParameters = gradle.getStartParameter().getTaskRequests();
        for (TaskExecutionRequest taskParameter : taskParameters) {
            List<TaskSelection> taskSelections = this.commandLineTaskParser.parseTasks(taskParameter);
            for (TaskSelection taskSelection : taskSelections) {
                LOGGER.info("Selected primary task '{}' from project {}", (Object)taskSelection.getTaskName(), (Object)taskSelection.getProjectPath());
                plan.addEntryTasks(taskSelection.getTasks());
            }
        }
        this.validateCompatibleTasksRequested(plan);
    }

    private void validateCompatibleTasksRequested(ExecutionPlan plan) {
        List requestedTaskNames;
        if (null != plan.getContents() && (requestedTaskNames = plan.getContents().getRequestedTasks().stream().map(Task::getName).collect(Collectors.toList())).size() > 1) {
            Optional<BuiltInCommand> exclusiveTaskInvoked = this.builtInCommands.stream().filter(BuiltInCommand::isExclusive).filter(c -> c.commandLineMatches(requestedTaskNames)).findFirst();
            exclusiveTaskInvoked.ifPresent(builtInCommand -> {
                InitExecutionException ex = new InitExecutionException("Executing other tasks along with the '" + builtInCommand.getDisplayName() + "' task is not allowed. The '" + builtInCommand.getDisplayName() + "' task must be run by itself.");
                ProblemId id = ProblemId.create((String)"init invocation problem", (String)"Init invocation problem", (ProblemGroup)GradleCoreProblemGroup.taskSelection());
                throw this.problemsService.getInternalReporter().throwing((Throwable)((Object)ex), id, spec -> {
                    spec.contextualLabel(ex.getMessage());
                    spec.severity(Severity.ERROR);
                });
            });
        }
    }

    @NullMarked
    private class EntryTaskSelectorContext
    implements EntryTaskSelector.Context {
        final GradleInternal gradle;

        public EntryTaskSelectorContext(GradleInternal gradle) {
            this.gradle = gradle;
        }

        @Override
        public TaskSelection getSelection(String taskPath) {
            return TaskNameResolvingBuildTaskScheduler.this.taskSelector.resolveTaskName(taskPath);
        }

        @Override
        public GradleInternal getGradle() {
            return this.gradle;
        }
    }

    @NullMarked
    public static final class InitExecutionException
    extends GradleException
    implements ResolutionProvider {
        public InitExecutionException(String message) {
            super(message);
        }

        public List<String> getResolutions() {
            return Collections.singletonList("Remove all other tasks from the command line when running init.");
        }
    }
}

