#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to collect MAP (memory-access pattern) data
# programatically with Advisor PythonAPI.
# ------------------------------------------------------------------------------

import os
import sys

try:

    import advisor

except ImportError:

    print(
        """Import Error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 3:
    print('Usage: "python {} path_to_project_dir path_to_binary"'.format(__file__))
    sys.exit(2)

# Create or open the Advisor Project, then collect survey data for the
# specified binary.
project_dir = sys.argv[1]
app = sys.argv[2]

if os.path.exists(project_dir):

    project = advisor.open_project(project_dir)

else:

    project = advisor.create_project(project_dir)

res = project.collect(advisor.SURVEY, app)

# To pass advanced options for collection, use the following:
# res = project.collect(advisor.SURVEY, app, collection_args = ['stackwalk-mode=online', 'no-stack-stitching', ...])

# Collection successful.
if res[0] == 0:

    # Load the survey results and print number of selected loops.
    survey = project.load(advisor.SURVEY)
    rows = list(survey.bottomup)
    project.mark_up_select(rows)
    print("Number of Selected Loops: {}".format(project.mark_up_len))

    # Collect MAP data for the specified binary, then load the result and print
    # MAP data.
    project.collect(advisor.MAP, app)

    data = project.load(advisor.MAP)
    project.mark_up_clear()

    for site in data.map:
        print(
            "Site Name: {} | Source: {} | Access Pattern: {}".format(
                site["site_name"], site["source"], site["access_pattern"]
            )
        )
        for problem in site.problems:
            print("  Problem: {}, {}".format(problem["id"], problem["source"]))

# Collection failed.
else:

    print("Error: Collection returned a non-zero return code.")
