#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain the memory loads and stores traffic in
# GBytes from integrated roofline data for all memory sub-system levels that
# were collected in the integrated roofline analysis.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

n = data.memory_levels
print("Number of memory levels: {}".format(n))

for level in range(n):
    print("level #{}:".format(level))

    if level == n - 1:
        memory_level_loads_column_name = "self_dram_loaded_gb"
        memory_level_stores_column_name = "self_dram_stored_gb"
    elif level == 0:
        memory_level_loads_column_name = "self_loaded_gb"
        memory_level_stores_column_name = "self_stored_gb"
    else:
        # So that level 1 gives L2 memory level name.
        memory_level_str = str(level + 1)
        memory_level_loads_column_name = "self_l" + memory_level_str + "_loaded_gb"
        memory_level_stores_column_name = "self_l" + memory_level_str + "_stored_gb"

    print(memory_level_loads_column_name, memory_level_stores_column_name)

    for row in data.bottomup:
        bytes_loaded = row[memory_level_loads_column_name]
        bytes_stored = row[memory_level_stores_column_name]

        if bytes_loaded and bytes_stored:
            print("{}, {}".format(bytes_loaded, bytes_stored))

    print("")
