<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
               <derivedQuery displayName="%Bottlenecks" id="BottleneckGroup">
                    <description>%BottlenecksDescriptionAll</description>
                    <valueEval>""</valueEval>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BottleneckExpanded">
                            <queryRef>/Mispredictions</queryRef>
                            <queryRef>/Big_Code</queryRef>
                            <queryRef>/Instruction_Fetch_BW</queryRef>
                            <queryRef>/Cache_Memory_Bandwidth</queryRef>
                            <queryRef>/Cache_Memory_Latency</queryRef>
                            <queryRef>/Memory_Data_TLBs</queryRef>
                            <queryRef>/Memory_Synchronization</queryRef>
                            <queryRef>/Compute_Bound_Est</queryRef>
                            <queryRef>/Irregular_Overhead</queryRef>
                            <queryRef>/Other_Bottlenecks</queryRef>
                            <queryRef>/Branching_Overhead</queryRef>
                            <queryRef>/Useful_Work</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery displayName="%TopDownMetrics" id="TopDownMetricGroup">
                    <description>%TopDownMetricsDescriptionAll</description>
                    <valueEval>""</valueEval>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="TopDownMetricGroupExpanded">
                            <derivedQuery id="RetiredPipelineSlotsGroup">
                                <queryInherit>/RetiredPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="Light_OperationsGroup">
                                            <queryInherit>/Light_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Light_OperationsGroupExpanded">
                                                    <derivedQuery id="FP_ArithGroup">
                                                        <queryInherit>/FP_Arith</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="FP_ArithGroupExpanded">
                                                                <queryRef>/FP_x87</queryRef>
                                                                <queryRef>/FP_Scalar</queryRef>
                                                                <derivedQuery id="FP_VectorGroup">
                                                                    <queryInherit>/FP_Vector</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="FP_VectorGroupExpanded">
                                                                            <queryRef>/FP_Vector_128b</queryRef>
                                                                            <queryRef>/FP_Vector_256b</queryRef>
                                                                            <queryRef>/FP_Vector_512b</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="Int_OperationsGroup">
                                                        <queryInherit>/Int_Operations</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Int_OperationsGroupExpanded">
                                                                <queryRef>/Int_Vector_128b</queryRef>
                                                                <queryRef>/Int_Vector_256b</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/Memory_Operations</queryRef>
                                                    <queryRef>/Fused_Instructions</queryRef>
                                                    <queryRef>/Non_Fused_Branches</queryRef>
                                                    <derivedQuery id="OTHERGroup">
                                                        <queryInherit>/OTHER</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="OTHERGroupExpanded">
                                                                <queryRef>/Nop_Instructions</queryRef>
                                                                <queryRef>/Shuffles_256b</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="Heavy_OperationsGroup">
                                            <queryInherit>/Heavy_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Heavy_OperationsGroupExpanded">
                                                    <queryRef>/Few_Uops_Instructions</queryRef>
                                                    <derivedQuery id="MicroSequencerGroup">
                                                        <queryInherit>/MicroSequencer</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="MicroSequencerGroupExpanded">
                                                                <derivedQuery id="AssistsGroup">
                                                                    <queryInherit>/Assists</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="AssistsGroupExpanded">
                                                                            <queryRef>/Page_Faults</queryRef>
                                                                            <queryRef>/FP_Assists</queryRef>
                                                                            <queryRef>/AVX_Assists</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/CISC</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                                <queryInherit>/FrontendBoundPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="FELatencyGroup">
                                            <queryInherit>/FELatency</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FELatencyGroupExpanded">
                                                    <queryRef>/ICacheMisses</queryRef>
                                                    <queryRef>/ITLBOverhead</queryRef>
                                                    <derivedQuery id="BranchResteersGroup">
                                                        <queryInherit>/BranchResteers</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="BranchResteersGroupExpanded">
                                                                <queryRef>/Mispredicts_Resteers</queryRef>
                                                                <queryRef>/Clears_Resteers</queryRef>
                                                                <queryRef>/Unknown_Branches</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/MSSwitches</queryRef>
                                                    <queryRef>/LCP</queryRef>
                                                    <queryRef>/DSBtoMITESwitchCost</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="FEBandwidthGroup">
                                            <queryInherit>/FEBandwidth</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FEBandwidthGroupExpanded">
                                                    <derivedQuery id="FEBandwidthMITEGroup">
                                                        <queryInherit>/FEBandwidthMITE</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="FEBandwidthMITEGroupExpanded">
                                                                <queryRef>/Decoder0_Alone</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/FEBandwidthDSB</queryRef>
                                                    <queryRef>/DSB_Coverage</queryRef>
                                                    <queryRef>/DSB_Misses</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CancelledPipelineSlotsGroup">
                                <queryInherit>/CancelledPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                                        <derivedQuery id="BranchMispredictGroup">
                                            <queryInherit>/BranchMispredict</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="BranchMispredictGroupExpanded">
                                                    <queryRef>/Other_Mispredicts</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="MachineClearsGroup">
                                            <queryInherit>/MachineClears</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MachineClearsGroupExpanded">
                                                    <queryRef>/Other_Nukes</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="BackendBoundGroup">
                                <queryInherit>/BackendBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BackendBoundGroupExpanded">
                                        <derivedQuery id="MemBoundGroup">
                                            <queryInherit>/MemBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MemBoundGroupExpanded">
                                                    <derivedQuery id="L1BoundGroup">
                                                        <queryInherit>/L1Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="L1BoundGroupExpanded">
                                                                <derivedQuery id="DTLBOverheadGroup">
                                                                    <queryInherit>/DTLBOverhead</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="DTLBOverheadGroupExpanded">
                                                                            <queryRef>/Load_STLB_Hit</queryRef>
                                                                            <queryRef>/Load_STLB_Miss</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/LoadsBlockedbyStoreForwarding</queryRef>
                                                                <queryRef>/L1_Hit_Latency</queryRef>
                                                                <queryRef>/LockLatency</queryRef>
                                                                <queryRef>/SplitLoads</queryRef>
                                                                <queryRef>/FBFull</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/L2Bound</queryRef>
                                                    <derivedQuery id="L3BoundGroup">
                                                        <queryInherit>/L3Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="L3BoundGroupExpanded">
                                                                <queryRef>/ContestedAccesses</queryRef>
                                                                <queryRef>/DataSharing</queryRef>
                                                                <queryRef>/L3Latency</queryRef>
                                                                <queryRef>/SQFull</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/HBMBound</queryRef>
                                                    <derivedQuery id="DRAMBoundGroup">
                                                        <queryInherit>/DRAMBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="DRAMBoundGroupExpanded">
                                                                <derivedQuery id="MEMBandwidthGroup">
                                                                    <queryInherit>/MEMBandwidth</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="MEMBandwidthGroupExpanded">
                                                                            <queryRef>/MBA_Stalls</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="MEMLatencyGroup">
                                                                    <queryInherit>/MEMLatency</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="MEMLatencyGroupExpanded">
                                                                            <queryRef>/LocalDRAM</queryRef>
                                                                            <queryRef>/RemoteDRAM</queryRef>
                                                                            <queryRef>/RemoteCache</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="StoresBoundGroup">
                                                        <queryInherit>/StoresBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="StoresBoundGroupExpanded">
                                                                <queryRef>/StoreLatency</queryRef>
                                                                <queryRef>/FalseSharing</queryRef>
                                                                <queryRef>/SplitStores</queryRef>
                                                                <queryRef>/Streaming_Stores</queryRef>
                                                                <derivedQuery id="DTLBStoreOverheadGroup">
                                                                    <queryInherit>/DTLBStoreOverhead</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="DTLBStoreOverheadGroupExpanded">
                                                                            <queryRef>/Store_STLB_Hit</queryRef>
                                                                            <queryRef>/Store_STLB_Miss</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="CoreBoundGroup">
                                            <queryInherit>/CoreBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="CoreBoundGroupExpanded">
                                                    <queryRef>/DIVActive</queryRef>
                                                    <derivedQuery id="Serializing_OperationGroup">
                                                        <queryInherit>/Serializing_Operation</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Serializing_OperationGroupExpanded">
                                                                <queryRef>/Slow_Pause</queryRef>
                                                                <queryRef>/C01_WAIT</queryRef>
                                                                <queryRef>/C02_WAIT</queryRef>
                                                                <queryRef>/Memory_Fence</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/AMX_Busy</queryRef>
                                                    <derivedQuery id="PortUtilGroup">
                                                        <queryInherit>/PortUtil</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="PortUtilGroupExpanded">
                                                                <derivedQuery id="Cycles0PortsUtilizedGroup">
                                                                    <queryInherit>/Cycles0PortsUtilized</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Cycles0PortsUtilizedGroupExpanded">
                                                                            <queryRef>/Mixing_Vectors</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/Cycles1PortUtilized</queryRef>
                                                                <queryRef>/Cycles2PortsUtilized</queryRef>
                                                                <derivedQuery id="Cycles3mPortsUtilizedGroup">
                                                                    <queryInherit>/Cycles3mPortsUtilized</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Cycles3mPortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="ALU_Op_UtilizationGroup">
                                                                                <queryInherit>/ALU_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="ALU_Op_UtilizationGroupExpanded">
                                                                                        <queryRef>/Port0</queryRef>
                                                                                        <queryRef>/Port1</queryRef>
                                                                                        <queryRef>/Port6</queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="Load_Op_UtilizationGroup">
                                                                                <queryInherit>/Load_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="Load_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="Store_Op_UtilizationGroup">
                                                                                <queryInherit>/Store_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="Store_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.RETIRING]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="Light_Operations">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) if ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Light_Operations") > 0.6 ) ) && ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_x87") + query("/FP_Scalar") + query("/FP_Vector") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="FP_x87">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.X87]") / query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]") ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_x87") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="FP_Scalar">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Scalar") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="FP_Vector">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_128b" id="FP_Vector_128b">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_128b_fp_vector_128bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED2.128B_PACKED_HALF]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%FP_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector_128b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/FP_Vector") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) && ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.128B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_256b" id="FP_Vector_256b">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_256b_fp_vector_256bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED2.256B_PACKED_HALF]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%FP_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector_256b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/FP_Vector") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) && ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.256B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_512b" id="FP_Vector_512b">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_Vector_512bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_512b_fp_vector_512bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED2.512B_PACKED_HALF]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%FP_Vector_512bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector_512b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/FP_Vector") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) && ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.512B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Operations" id="Int_Operations">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_OperationsDescriptionAll</description>
                    <helpKeyword>configs.int_operations_int_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Int_Vector_128b") + query("/Int_Vector_256b") ) ]]></valueEval>
                    <issueText>%Int_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Operations") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_128b" id="Int_Vector_128b">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_128b_int_vector_128bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") + query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Int_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Vector_128b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/Int_Operations") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_256b" id="Int_Vector_256b">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_256b_int_vector_256bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") + query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") + query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Int_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Vector_256b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/Int_Operations") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Operations" id="Memory_Operations">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Memory_OperationsDescriptionAll</description>
                    <helpKeyword>configs.memory_operations_memory_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations") * query("/PMUEventCount/PMUEventType[MEM_UOP_RETIRED.ANY]") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Memory_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Memory_Operations") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fused_Instructions" id="Fused_Instructions">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Fused_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.fused_instructions_fused_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations") * query("/PMUEventCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Fused_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Fused_Instructions") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Non_Fused_Branches" id="Non_Fused_Branches">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Non_Fused_BranchesDescriptionAll</description>
                    <helpKeyword>configs.non_fused_branches_non_fused_branchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations") * ( query("/PMUEventCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") - query("/PMUEventCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") ) / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Non_Fused_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Non_Fused_Branches") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Light_Operations") - query("/Light_Ops_Sum") ) if ( query("/Light_Operations") - query("/Light_Ops_Sum") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/OTHER") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) if ( ( ( query("/Light_Operations") - query("/Light_Ops_Sum") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Nop_Instructions" id="Nop_Instructions">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Nop_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.nop_instructions_nop_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations") * query("/PMUEventCount/PMUEventType[INST_RETIRED.NOP]") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Nop_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Nop_Instructions") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/OTHER") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Shuffles_256b" id="Shuffles_256b">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Shuffles_256bDescriptionAll</description>
                    <helpKeyword>configs.shuffles_256b_shuffles_256bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations") * query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.SHUFFLES]") / query("/Retired_Slots") ) ]]></valueEval>
                    <issueText>%Shuffles_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Shuffles_256b") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/OTHER") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.SHUFFLES]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="Heavy_Operations">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Heavy_Operations") > 0.1 ) ) && ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Instructions" id="Few_Uops_Instructions">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Few_Uops_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.few_uops_instructions_few_uops_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) if ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%Few_Uops_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Few_Uops_Instructions") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Decoder0_Alone") > 0.1) ) && ( ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) ) && ( ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="Assists">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Avg_Assist_Cost") * query("/PMUEventCount/PMUEventType[ASSISTS.ANY]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Assists") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) && ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Page_Faults" id="Page_Faults">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Page_FaultsDescriptionAll</description>
                    <helpKeyword>configs.page_faults_page_faultsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 99 * query("/PMUEventCount/PMUEventType[ASSISTS.PAGE_FAULT]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%Page_FaultsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Page_Faults") > 0.05 ) ) && ( ( ( query("/Assists") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) && ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.PAGE_FAULT]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Assists" id="FP_Assists">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_AssistsDescriptionAll</description>
                    <helpKeyword>configs.fp_assists_fp_assistsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 30 * query("/PMUEventCount/PMUEventType[ASSISTS.FP]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FP_AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FP_Assists") > 0.1 ) ) && ( ( ( query("/Assists") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) && ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.FP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%AVX_Assists" id="AVX_Assists">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%AVX_AssistsDescriptionAll</description>
                    <helpKeyword>configs.avx_assists_avx_assistsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 63 * query("/PMUEventCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%AVX_AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/AVX_Assists") > 0.1 ) ) && ( ( ( query("/Assists") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) && ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CISC" id="CISC">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CISCDescriptionAll</description>
                    <helpKeyword>configs.cisc_ciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MicroSequencer") - query("/Assists") ) if ( query("/MicroSequencer") - query("/Assists") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CISCIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CISC") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) && ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/MicroSequencer") - query("/Assists") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") - query("/PMUEventCount/PMUEventType[INT_MISC.UOP_DROPPING]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") - query("/PMUEventCount/PMUEventType[INT_MISC.UOP_DROPPING]") / query("/SLOTS") ) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_DATA.STALLS]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ICacheMisses") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_TAG.STALLS]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") / query("/DerivedClockticks") + query("/Unknown_Branches") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="Mispredicts_Resteers">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction") * query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Mispredicts_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mispredicts_Resteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/BranchMispredict") > 0.1) || ( queryOptional("/Mispredictions") > 0.2) ) && ( ( ( query("/BranchResteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="Clears_Resteers">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - query("/Mispred_Clears_Fraction") ) * query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Clears_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Clears_Resteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) ) && ( ( ( query("/BranchResteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="Unknown_Branches">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Unknown_Branches") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchResteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="MSSwitches">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MS_Switches_Cost") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") / query("/Retire_Fraction") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MSSwitches") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Irregular_Overhead") > 0.1) || ( queryOptional("/Serializing_Operation") > 0.1) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="LCP">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DECODE.LCP]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LCP") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) || ( queryOptional("/FEBandwidth") > 0.2) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="DSBtoMITESwitchCost">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DSBtoMITESwitchCost") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/FEBandwidth") > 0.2) ) && ( ( ( query("/FELatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) if ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) ) && ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="FEBandwidthMITE">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") - query("/PMUEventCount/PMUEventType[IDQ.MITE_CYCLES_OK]") ) / query("/CORE_CLKS") / 2 ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthMITE") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Decoder0_Alone" id="Decoder0_Alone">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Decoder0_AloneDescriptionAll</description>
                    <helpKeyword>configs.decoder0_alone_decoder0_alonedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[INST_DECODED.DECODERS:cmask=1]") - query("/PMUEventCount/PMUEventType[INST_DECODED.DECODERS:cmask=2]") ) / query("/CORE_CLKS") / 2 ) ]]></valueEval>
                    <issueText>%Decoder0_AloneIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Decoder0_Alone") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Few_Uops_Instructions") > 0.05) ) && ( ( ( query("/FEBandwidthMITE") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INST_DECODED.DECODERS:cmask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_DECODED.DECODERS:cmask=2]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="FEBandwidthDSB">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.DSB_CYCLES_ANY]") - query("/PMUEventCount/PMUEventType[IDQ.DSB_CYCLES_OK]") ) / query("/CORE_CLKS") / 2 ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthDSB") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="DSB_Coverage">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]") / query("/Fetched_Uops") ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DSB_Coverage") < 0.7 ) ) && ( ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.7 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Misses" id="DSB_Misses">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%DSB_MissesDescriptionAll</description>
                    <helpKeyword>configs.dsb_misses_dsb_missesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 100 * ( query("/FELatency") * query("/DSBtoMITESwitchCost") / ( query("/ICacheMisses") + query("/ITLBOverhead") + query("/BranchResteers") + query("/MSSwitches") + query("/LCP") + query("/DSBtoMITESwitchCost") ) + query("/FEBandwidth") * query("/FEBandwidthMITE") / ( query("/FEBandwidthMITE") + query("/FEBandwidthDSB") ) ) ) ]]></valueEval>
                    <issueText>%DSB_MissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DSB_Misses") > 10 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) || ( queryOptional("/FEBandwidth") > 0.2) ) && ( ( query("/FEBandwidth") > 0.2 ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") + query("/RetiredPipelineSlots") ) ) if ( 1 - ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") + query("/RetiredPipelineSlots") ) ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Mispredicts_Resteers") > 0.05) || ( queryOptional("/Mispredictions") > 0.2) ) && ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Mispredicts" id="Other_Mispredicts">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Other_MispredictsDescriptionAll</description>
                    <helpKeyword>configs.other_mispredicts_other_mispredictsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BranchMispredict") * ( 1 - query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") / ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEARS_COUNT]") - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) if ( query("/BranchMispredict") * ( 1 - query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") / ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEARS_COUNT]") - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) > 0.0001 else 0.0001 ) ]]></valueEval>
                    <issueText>%Other_MispredictsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Other_Mispredicts") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchMispredict") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Mispredicts_Resteers") > 0.05) || ( queryOptional("/Mispredictions") > 0.2) && ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) if ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/ContestedAccesses") > 0.05) || ( queryOptional("/DataSharing") > 0.05) || ( queryOptional("/RemoteCache") > 0.05) || ( queryOptional("/FalseSharing") > 0.05) ) && ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Nukes" id="Other_Nukes">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Other_NukesDescriptionAll</description>
                    <helpKeyword>configs.other_nukes_other_nukesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MachineClears") * ( 1 - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) if ( query("/MachineClears") * ( 1 - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) > 0.0001 else 0.0001 ) ]]></valueEval>
                    <issueText>%Other_NukesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Other_Nukes") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/L1Bound") > 0.1) || ( queryOptional("/ContestedAccesses") > 0.05) || ( queryOptional("/DataSharing") > 0.05) || ( queryOptional("/RemoteCache") > 0.05) || ( queryOptional("/FalseSharing") > 0.05) && ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) / query("/DerivedClockticks") ) if ( ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) / query("/DerivedClockticks") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="DTLBOverhead">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/Mem_STLB_Hit_Cost") * query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") + query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) / query("/DerivedClockticks") ) if ( ( query("/Mem_STLB_Hit_Cost") * query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") + query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) / query("/DerivedClockticks") ) < ( ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) if ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) > 0 else 0 ) else ( ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) if ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) > 0 else 0 ) ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DTLBOverhead") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBStoreOverhead") > 0.05) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DTLBOverhead") - query("/Load_STLB_Miss") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Load_STLB_Hit") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBOverhead") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBStoreOverhead") > 0.05) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) && ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Load_STLB_Miss") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBOverhead") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBStoreOverhead") > 0.05) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) && ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 13 * query("/PMUEventCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LoadsBlockedbyStoreForwarding") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1_Hit_Latency" id="L1_Hit_Latency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1_Hit_LatencyDescriptionAll</description>
                    <helpKeyword>configs.l1_hit_latency_l1_hit_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( 2 * ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") - query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") - query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) * query("/Dependent_Loads_Weight") / 100 ) / query("/DerivedClockticks") ) if ( ( 2 * ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") - query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") - query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) * query("/Dependent_Loads_Weight") / 100 ) / query("/DerivedClockticks") ) < ( ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) if ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) > 0 else 0 ) else ( ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) if ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) / query("/DerivedClockticks") ) > 0 else 0 ) ) ]]></valueEval>
                    <issueText>%L1_Hit_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L1_Hit_Latency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="LockLatency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 16 * ( ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") - query("/PMUEventCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) if ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") - query("/PMUEventCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) > 0 else 0 ) + query("/Mem_Lock_St_Fraction") * ( query("/Mem_L2_Store_Cost") * query("/PMUEventCount/PMUEventType[L2_RQSTS.RFO_HIT]") + query("/ORO_Demand_RFO_C1") ) ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LockLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LockLatency") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/StoreLatency") > 0.1) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="SplitLoads">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Load_Miss_Real_Latency") * query("/PMUEventCount/PMUEventType[LD_BLOCKS.NO_SR]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%SplitLoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SplitLoads") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="FBFull">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%FBFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FBFull") > 0.3 ) || ( queryOptional("/SQFull") > 0.3) || ( queryOptional("/MEMBandwidth") > 0.2) || ( queryOptional("/Cache_Memory_Bandwidth") > 0.2) || ( queryOptional("/StoreLatency") > 0.1) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Cycles1PortUtilized") > 0.2) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/Clears_Resteers") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") - query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="ContestedAccesses">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/Mem_XSNP_HitM_Cost") - query("/Mem_L2_Hit_Cost") ) * query("/LOAD_XSNP_HITM") + ( query("/Mem_XSNP_Hit_Cost") - query("/Mem_L2_Hit_Cost") ) * query("/LOAD_XSNP_MISS") ) * query("/FB_Factor") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%ContestedAccessesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ContestedAccesses") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/DataSharing") > 0.05) || ( queryOptional("/RemoteCache") > 0.05) || ( queryOptional("/FalseSharing") > 0.05) ) && ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="DataSharing">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_XSNP_Hit_Cost") - query("/Mem_L2_Hit_Cost") ) * query("/LOAD_XSNP_HIT") * query("/FB_Factor") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DataSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DataSharing") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/ContestedAccesses") > 0.05) || ( queryOptional("/RemoteCache") > 0.05) || ( queryOptional("/FalseSharing") > 0.05) ) && ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="L3Latency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_XSNP_None_Cost") - query("/Mem_L2_Hit_Cost") ) * query("/LOAD_L3_HIT") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%L3LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Latency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MEMLatency") > 0.1) || ( queryOptional("/Cache_Memory_Latency") > 0.2) ) && ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="SQFull">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[XQ.FULL_CYCLES]") + query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%SQFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SQFull") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull") > 0.3) || ( queryOptional("/MEMBandwidth") > 0.2) || ( queryOptional("/Cache_Memory_Bandwidth") > 0.2) ) && ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%HBMBound" id="HBMBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%HBMBoundDescriptionAll</description>
                    <helpKeyword>configs.hbmbound_hbmbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio") * query("/PMUEventCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") / query("/PMUEventCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") ) ]]></valueEval>
                    <issueText>%HBMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/HBMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio") - query("/HBMBound") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="MEMBandwidth">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_BW_Cycles") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMBandwidth") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull") > 0.3) || ( queryOptional("/SQFull") > 0.3) || ( queryOptional("/Cache_Memory_Bandwidth") > 0.2) ) && ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MBA_Stalls" id="MBA_Stalls">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MBA_StallsDescriptionAll</description>
                    <helpKeyword>configs.mba_stalls_mba_stallsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.MBA_STALLS]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%MBA_StallsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MBA_Stalls") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MEMBandwidth") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull") > 0.3) || ( queryOptional("/SQFull") > 0.3) || ( queryOptional("/Cache_Memory_Bandwidth") > 0.2) && ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.MBA_STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="MEMLatency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_Any_Cycles") / query("/DerivedClockticks") - query("/MEMBandwidth") ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L3Latency") > 0.1) || ( queryOptional("/Cache_Memory_Latency") > 0.2) ) && ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LocalDRAM" id="LocalDRAM">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LocalDRAMDescriptionAll</description>
                    <helpKeyword>configs.localdram_localdramdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_Local_DRAM_Cost") - query("/Mem_XSNP_None_Cost") ) * query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") * query("/FB_Factor") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LocalDRAMIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LocalDRAM") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MEMLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L3Latency") > 0.1) || ( queryOptional("/Cache_Memory_Latency") > 0.2) && ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteDRAM" id="RemoteDRAM">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%RemoteDRAMDescriptionAll</description>
                    <helpKeyword>configs.remotedram_remotedramdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_Remote_DRAM_Cost") - query("/Mem_XSNP_None_Cost") ) * query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") * query("/FB_Factor") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%RemoteDRAMIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/RemoteDRAM") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MEMLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L3Latency") > 0.1) || ( queryOptional("/Cache_Memory_Latency") > 0.2) && ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="RemoteCache">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%RemoteCacheDescriptionAll</description>
                    <helpKeyword>configs.remotecache_remotecachedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/Mem_Remote_HitM_Cost") - query("/Mem_XSNP_None_Cost") ) * query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") + ( query("/Mem_Remote_Fwd_Cost") - query("/Mem_XSNP_None_Cost") ) * query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") ) * query("/FB_Factor") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%RemoteCacheIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/RemoteCache") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/ContestedAccesses") > 0.05) || ( queryOptional("/DataSharing") > 0.05) || ( queryOptional("/FalseSharing") > 0.05) ) && ( ( ( query("/MEMLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L3Latency") > 0.1) || ( queryOptional("/Cache_Memory_Latency") > 0.2) && ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="StoreLatency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Store_L2_Hit_Cycles") + ( 1 - query("/Mem_Lock_St_Fraction") ) * query("/ORO_Demand_RFO_C1") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%StoreLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoreLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/LockLatency") > 0.2) || ( queryOptional("/FBFull") > 0.3) ) && ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="FalseSharing">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_XSNP_HitM_Cost") * query("/PMUEventCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%FalseSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FalseSharing") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears") > 0.1) || ( queryOptional("/ContestedAccesses") > 0.05) || ( queryOptional("/DataSharing") > 0.05) || ( queryOptional("/RemoteCache") > 0.05) ) && ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="SplitStores">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%SplitStoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SplitStores") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Streaming_Stores" id="Streaming_Stores">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Streaming_StoresDescriptionAll</description>
                    <helpKeyword>configs.streaming_stores_streaming_storesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 9 * query("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Streaming_StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Streaming_Stores") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull") > 0.3) ) && ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="DTLBStoreOverhead">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_STLB_Hit_Cost") * query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") + query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") ) / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%DTLBStoreOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DTLBStoreOverhead") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBOverhead") > 0.1) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) ) && ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="Store_STLB_Hit">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DTLBStoreOverhead") - query("/Store_STLB_Miss") ) ]]></valueEval>
                    <issueText>%Store_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Store_STLB_Hit") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBStoreOverhead") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBOverhead") > 0.1) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) && ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="Store_STLB_Miss">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%Store_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Store_STLB_Miss") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBStoreOverhead") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DTLBOverhead") > 0.1) || ( queryOptional("/Memory_Data_TLBs") > 0.2) || ( queryOptional("/Memory_Synchronization") > 0.1) && ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BackendBound") - query("/MemBound") ) if ( query("/BackendBound") - query("/MemBound") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="DIVActive">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ARITH.DIV_ACTIVE]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DIVActive") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") / query("/DerivedClockticks") + query("/C02_WAIT") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Serializing_Operation") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="Slow_Pause">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.PAUSE]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Slow_PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Slow_Pause") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.PAUSE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%C01_WAIT" id="C01_WAIT">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%C01_WAITDescriptionAll</description>
                    <helpKeyword>configs.c01_wait_c01_waitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.C01]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%C01_WAITIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/C01_WAIT") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C01]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%C02_WAIT" id="C02_WAIT">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%C02_WAITDescriptionAll</description>
                    <helpKeyword>configs.c02_wait_c02_waitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.C02]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%C02_WAITIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/C02_WAIT") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Fence" id="Memory_Fence">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Memory_FenceDescriptionAll</description>
                    <helpKeyword>configs.memory_fence_memory_fencedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 13 * query("/PMUEventCount/PMUEventType[MISC2_RETIRED.LFENCE]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Memory_FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Memory_Fence") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[MISC2_RETIRED.LFENCE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%AMX_Busy" id="AMX_Busy">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%AMX_BusyDescriptionAll</description>
                    <helpKeyword>configs.amx_busy_amx_busydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE.AMX_BUSY]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%AMX_BusyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/AMX_Busy") > 0.5 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.5 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="PortUtil">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Cycles") / query("/DerivedClockticks") if ( query("/PMUEventCount/PMUEventType[ARITH.DIV_ACTIVE]") < ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") - query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) else query("/Few_Uops_Executed_Threshold") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="Cycles0PortsUtilized">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") + ( ( query("/PMUEventCount/PMUEventType[RS.EMPTY:umask=1]") - query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) if ( query("/PMUEventCount/PMUEventType[RS.EMPTY:umask=1]") - query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) > 0 else 0 ) ) / query("/DerivedClockticks") * ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") - query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Cycles0PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles0PortsUtilized") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mixing_Vectors" id="Mixing_Vectors">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mixing_VectorsDescriptionAll</description>
                    <helpKeyword>configs.mixing_vectors_mixing_vectorsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 160 * query("/PMUEventCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Mixing_VectorsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Mixing_Vectors") > 0.05 ) || ( queryOptional("/MSSwitches") > 0.05) ) && ( ( ( query("/Cycles0PortsUtilized") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="Cycles1PortUtilized">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Cycles1PortUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles1PortUtilized") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L1Bound") > 0.1) ) && ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="Cycles2PortsUtilized">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Cycles2PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles2PortsUtilized") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="Cycles3mPortsUtilized">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%Cycles3mPortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.4 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="ALU_Op_Utilization">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_5_11]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") ) / ( 5 * query("/CORE_CLKS") ) ) ]]></valueEval>
                    <issueText>%ALU_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ALU_Op_Utilization") > 0.4 ) ) && ( ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.4 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5_11]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="Port0">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port0") > 0.6 ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port1") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( query("/ALU_Op_Utilization") > 0.4 ) && ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="Port1">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port1") > 0.6 ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port6") > 0.6) ) && ( ( query("/ALU_Op_Utilization") > 0.4 ) && ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="Port5">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="Port6">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%Port6IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port6") > 0.6 ) || ( queryOptional("/FP_Scalar") > 0.1) || ( queryOptional("/FP_Vector") > 0.1) || ( queryOptional("/Cycles2PortsUtilized") > 0.15) || ( queryOptional("/Port0") > 0.6) || ( queryOptional("/Port1") > 0.6) ) && ( ( query("/ALU_Op_Utilization") > 0.4 ) && ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="Load_Op_Utilization">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3_10]") / ( 3 * query("/CORE_CLKS") ) ) ]]></valueEval>
                    <issueText>%Load_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_Op_Utilization") > 0.6 ) ) && ( ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3_10]") >= 10 ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="Store_Op_Utilization">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_4_9]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]") ) / ( 4 * query("/CORE_CLKS") ) ) ]]></valueEval>
                    <issueText>%Store_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Store_Op_Utilization") > 0.6 ) ) && ( ( ( query("/Cycles3mPortsUtilized") > 0.4 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_4_9]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port4" id="Port4">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredictions" id="Mispredictions">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MispredictionsDescriptionAll</description>
                    <helpKeyword>configs.mispredictions_mispredictionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - query("/Umisp") ) * ( query("/BranchMispredict") + query("/FELatency") * query("/Mispredicts_Resteers") / ( query("/ICacheMisses") + query("/ITLBOverhead") + query("/BranchResteers") + query("/MSSwitches") + query("/LCP") + query("/DSBtoMITESwitchCost") ) ) ) ]]></valueEval>
                    <issueText>%MispredictionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Mispredictions") > 0.2 ) || ( queryOptional("/Mispredicts_Resteers") > 0.05) || ( queryOptional("/BranchMispredict") > 0.1) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Big_Code" id="Big_Code">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Big_CodeDescriptionAll</description>
                    <helpKeyword>configs.big_code_big_codedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FELatency") * ( query("/ITLBOverhead") + query("/ICacheMisses") + query("/Unknown_Branches") ) / ( query("/ICacheMisses") + query("/ITLBOverhead") + query("/BranchResteers") + query("/MSSwitches") + query("/LCP") + query("/DSBtoMITESwitchCost") ) ) ]]></valueEval>
                    <issueText>%Big_CodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Big_Code") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Instruction_Fetch_BW" id="Instruction_Fetch_BW">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Instruction_Fetch_BWDescriptionAll</description>
                    <helpKeyword>configs.instruction_fetch_bw_instruction_fetch_bwdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots") - ( 1 - query("/Umisp") ) * query("/FELatency") * query("/Mispredicts_Resteers") / ( query("/ICacheMisses") + query("/ITLBOverhead") + query("/BranchResteers") + query("/MSSwitches") + query("/LCP") + query("/DSBtoMITESwitchCost") ) - query("/Assist_Frontend") ) - query("/Big_Code") ) ]]></valueEval>
                    <issueText>%Instruction_Fetch_BWIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Instruction_Fetch_BW") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cache_Memory_Bandwidth" id="Cache_Memory_Bandwidth">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Cache_Memory_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.cache_memory_bandwidth_cache_memory_bandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 100 * ( ( query("/MemBound") * ( query("/DRAMBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/MEMBandwidth") / ( query("/MEMBandwidth") + query("/MEMLatency") ) ) ) + ( query("/MemBound") * query("/HBMBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * query("/MEMBandwidth") / ( query("/MEMBandwidth") + query("/MEMLatency") ) + ( query("/MemBound") * ( query("/L3Bound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/SQFull") / ( query("/ContestedAccesses") + query("/DataSharing") + query("/L3Latency") + query("/SQFull") ) ) ) + ( query("/MemBound") * ( query("/L1Bound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/FBFull") / ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") + query("/L1_Hit_Latency") + query("/LockLatency") + query("/SplitLoads") + query("/FBFull") ) ) ) ) ) ) ]]></valueEval>
                    <issueText>%Cache_Memory_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Cache_Memory_Bandwidth") > 0.2 ) || ( queryOptional("/FBFull") > 0.3) || ( queryOptional("/SQFull") > 0.3) || ( queryOptional("/MEMBandwidth") > 0.2) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cache_Memory_Latency" id="Cache_Memory_Latency">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Cache_Memory_LatencyDescriptionAll</description>
                    <helpKeyword>configs.cache_memory_latency_cache_memory_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/MemBound") * ( query("/DRAMBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/MEMLatency") / ( query("/MEMBandwidth") + query("/MEMLatency") ) ) ) + ( query("/MemBound") * query("/HBMBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * query("/MEMLatency") / ( query("/MEMBandwidth") + query("/MEMLatency") ) + ( query("/MemBound") * ( query("/L3Bound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/L3Latency") / ( query("/ContestedAccesses") + query("/DataSharing") + query("/L3Latency") + query("/SQFull") ) ) ) + ( query("/MemBound") * query("/L2Bound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) + ( query("/MemBound") * ( query("/StoresBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/StoreLatency") / ( query("/StoreLatency") + query("/FalseSharing") + query("/SplitStores") + query("/Streaming_Stores") + query("/DTLBStoreOverhead") ) ) ) ) ) ]]></valueEval>
                    <issueText>%Cache_Memory_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Cache_Memory_Latency") > 0.2 ) || ( queryOptional("/L3Latency") > 0.1) || ( queryOptional("/MEMLatency") > 0.1) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Data_TLBs" id="Memory_Data_TLBs">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Memory_Data_TLBsDescriptionAll</description>
                    <helpKeyword>configs.memory_data_tlbs_memory_data_tlbsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MemBound") * ( query("/L1Bound") / ( query("/MemBound") if query("/MemBound") > ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) else ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) ) * ( query("/DTLBOverhead") / ( query("/L1Bound") if query("/L1Bound") > ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") + query("/L1_Hit_Latency") + query("/LockLatency") + query("/SplitLoads") + query("/FBFull") ) else ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") + query("/L1_Hit_Latency") + query("/LockLatency") + query("/SplitLoads") + query("/FBFull") ) ) ) + ( query("/MemBound") * ( query("/StoresBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/DTLBStoreOverhead") / ( query("/StoreLatency") + query("/FalseSharing") + query("/SplitStores") + query("/Streaming_Stores") + query("/DTLBStoreOverhead") ) ) ) ) ) ]]></valueEval>
                    <issueText>%Memory_Data_TLBsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Memory_Data_TLBs") > 0.2 ) || ( queryOptional("/DTLBOverhead") > 0.1) || ( queryOptional("/DTLBStoreOverhead") > 0.05) || ( queryOptional("/Memory_Synchronization") > 0.1) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( query("/MemBound") > ( ( ( ( ( query("/L1Bound") + query("/L2Bound") ) + query("/L3Bound") ) + query("/HBMBound") ) + query("/DRAMBound") ) + query("/StoresBound") ) ) ) else ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) if ( ( query("/L1Bound") > ( ( ( ( ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") ) + query("/L1_Hit_Latency") ) + query("/LockLatency") ) + query("/SplitLoads") ) + query("/FBFull") ) ) ) else ( ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Synchronization" id="Memory_Synchronization">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Memory_SynchronizationDescriptionAll</description>
                    <helpKeyword>configs.memory_synchronization_memory_synchronizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MemBound") * ( ( query("/DRAMBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/MEMLatency") / ( query("/MEMBandwidth") + query("/MEMLatency") ) ) * query("/RemoteCache") / ( query("/LocalDRAM") + query("/RemoteDRAM") + query("/RemoteCache") ) + ( query("/L3Bound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * ( query("/ContestedAccesses") + query("/DataSharing") ) / ( query("/ContestedAccesses") + query("/DataSharing") + query("/L3Latency") + query("/SQFull") ) + ( query("/StoresBound") / ( query("/L1Bound") + query("/L2Bound") + query("/L3Bound") + query("/HBMBound") + query("/DRAMBound") + query("/StoresBound") ) ) * query("/FalseSharing") / ( ( query("/StoreLatency") + query("/FalseSharing") + query("/SplitStores") + query("/Streaming_Stores") + query("/DTLBStoreOverhead") ) - query("/StoreLatency") ) ) + query("/MachineClears") * ( 1 - query("/Other_Nukes") / ( query("/Other_Nukes") ) ) ) ) ]]></valueEval>
                    <issueText>%Memory_SynchronizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Memory_Synchronization") > 0.1 ) || ( queryOptional("/DTLBOverhead") > 0.1) || ( queryOptional("/DTLBStoreOverhead") > 0.05) || ( queryOptional("/Memory_Data_TLBs") > 0.2) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Compute_Bound_Est" id="Compute_Bound_Est">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Compute_Bound_EstDescriptionAll</description>
                    <helpKeyword>configs.compute_bound_est_compute_bound_estdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/CoreBound") * query("/DIVActive") / ( query("/DIVActive") + query("/Serializing_Operation") + query("/AMX_Busy") + query("/PortUtil") ) ) + ( query("/CoreBound") * query("/AMX_Busy") / ( query("/DIVActive") + query("/Serializing_Operation") + query("/AMX_Busy") + query("/PortUtil") ) ) + ( query("/CoreBound") * ( query("/PortUtil") / ( query("/DIVActive") + query("/Serializing_Operation") + query("/AMX_Busy") + query("/PortUtil") ) ) * ( query("/Cycles3mPortsUtilized") / ( query("/Cycles0PortsUtilized") + query("/Cycles1PortUtilized") + query("/Cycles2PortsUtilized") + query("/Cycles3mPortsUtilized") ) ) ) ) ) ]]></valueEval>
                    <issueText>%Compute_Bound_EstIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Compute_Bound_Est") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Irregular_Overhead" id="Irregular_Overhead">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Irregular_OverheadDescriptionAll</description>
                    <helpKeyword>configs.irregular_overhead_irregular_overheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Assist_Frontend") + query("/Umisp") * query("/BranchMispredict") + ( query("/MachineClears") * query("/Other_Nukes") / ( query("/Other_Nukes") ) ) + query("/Serialize_Core") + query("/Assist_Retired") ) ) ]]></valueEval>
                    <issueText>%Irregular_OverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Irregular_Overhead") > 0.1 ) || ( queryOptional("/MicroSequencer") > 0.05) || ( queryOptional("/MSSwitches") > 0.05) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Bottlenecks" id="Other_Bottlenecks">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Other_BottlenecksDescriptionAll</description>
                    <helpKeyword>configs.other_bottlenecks_other_bottlenecksdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1.0 - ( query("/Big_Code") + query("/Instruction_Fetch_BW") + query("/Mispredictions") + query("/Cache_Memory_Bandwidth") + query("/Cache_Memory_Latency") + query("/Memory_Data_TLBs") + query("/Memory_Synchronization") + query("/Compute_Bound_Est") + query("/Irregular_Overhead") + query("/Branching_Overhead") + query("/Useful_Work") ) ) ]]></valueEval>
                    <issueText>%Other_BottlenecksIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Other_Bottlenecks") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( query("/MemBound") > ( ( ( ( ( query("/L1Bound") + query("/L2Bound") ) + query("/L3Bound") ) + query("/HBMBound") ) + query("/DRAMBound") ) + query("/StoresBound") ) ) ) else ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) if ( ( query("/L1Bound") > ( ( ( ( ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") ) + query("/L1_Hit_Latency") ) + query("/LockLatency") ) + query("/SplitLoads") ) + query("/FBFull") ) ) ) else ( ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Branching_Overhead" id="Branching_Overhead">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Branching_OverheadDescriptionAll</description>
                    <helpKeyword>configs.branching_overhead_branching_overheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Branching_Retired") ) ]]></valueEval>
                    <issueText>%Branching_OverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Branching_Overhead") > 0.05 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Useful_Work" id="Useful_Work">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Useful_WorkDescriptionAll</description>
                    <helpKeyword>configs.useful_work_useful_workdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots") - query("/Branching_Retired") - query("/Assist_Retired") ) ) ]]></valueEval>
                    <issueText>%Useful_WorkIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/Useful_Work") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedIssueSlots") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.SLOTS:perf_metrics]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="CORE_CLKS">
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.DISTRIBUTED]") if query("/SMT_on") else query("/DerivedClockticks") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.DISTRIBUTED]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Miss_Real_Latency" id="Load_Miss_Real_Latency">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Load_Miss_Real_LatencyDescriptionAll</description>
                    <helpKeyword>configs.load_miss_real_latency_load_miss_real_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.PENDING]") / ( query("/PMUEventCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") + 1 ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Frequency" id="Core_Frequency">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Core_FrequencyDescriptionAll</description>
                    <helpKeyword>configs.core_frequency_core_frequencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/AverageFrequency") / 1000000000.0) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Turbo_Utilization" id="Turbo_Utilization">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Turbo_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.turbo_utilization_turbo_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedClockticks") / query("/DerivedRefClockticks") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TimeTMA" id="TimeTMA">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%TimeTMADescriptionAll</description>
                    <helpKeyword>configs.timetma_timetmadescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInSeconds") ) ]]></valueEval>
                    <issueText>%TimeTMAIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/TimeTMA") < 1 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Branching_Retired" id="Branching_Retired">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Branching_RetiredDescriptionAll</description>
                    <helpKeyword>configs.branching_retired_branching_retireddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") + 2 * query("/PMUEventCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") + query("/PMUEventCount/PMUEventType[INST_RETIRED.NOP]") ) / query("/SLOTS") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.NEAR_CALL]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serialize_Core" id="Serialize_Core">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Serialize_CoreDescriptionAll</description>
                    <helpKeyword>configs.serialize_core_serialize_coredescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound") * ( query("/Serializing_Operation") + query("/PMUEventCount/PMUEventType[RS.EMPTY:umask=1]") / query("/DerivedClockticks") * query("/Cycles0PortsUtilized") ) / ( query("/DIVActive") + query("/Serializing_Operation") + query("/AMX_Busy") + query("/PortUtil") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Umisp" id="Umisp">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%UmispDescriptionAll</description>
                    <helpKeyword>configs.umisp_umispdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 10 * query("/MicroSequencer") * query("/Other_Mispredicts") / query("/BranchMispredict") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Assist" id="Assist">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%AssistDescriptionAll</description>
                    <helpKeyword>configs.assist_assistdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MicroSequencer") / ( query("/Few_Uops_Instructions") + query("/MicroSequencer") ) ) * ( query("/Assists") / query("/MicroSequencer") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Assist_Frontend" id="Assist_Frontend">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Assist_FrontendDescriptionAll</description>
                    <helpKeyword>configs.assist_frontend_assist_frontenddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - query("/PMUEventCount/PMUEventType[INST_RETIRED.REP_ITERATION]") / query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") ) * ( query("/FELatency") * ( query("/MSSwitches") + query("/BranchResteers") * ( query("/Clears_Resteers") + query("/Mispredicts_Resteers") * query("/Other_Mispredicts") / query("/BranchMispredict") ) / ( query("/Mispredicts_Resteers") + query("/Clears_Resteers") + query("/Unknown_Branches") ) ) / ( query("/ICacheMisses") + query("/ITLBOverhead") + query("/BranchResteers") + query("/MSSwitches") + query("/LCP") + query("/DSBtoMITESwitchCost") ) ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Assist_Retired" id="Assist_Retired">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Assist_RetiredDescriptionAll</description>
                    <helpKeyword>configs.assist_retired_assist_retireddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Assist") * query("/Heavy_Operations") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="Core_Bound_Cycles">
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Cycles0PortsUtilized") * query("/DerivedClockticks") + query("/Few_Uops_Executed_Threshold") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInSeconds" id="DurationTimeInSeconds">
                    <description>%DurationTimeInSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinseconds_durationtimeinsecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInMilliSeconds") / 1000 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FB_Factor" id="FB_Factor">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%FB_FactorDescriptionAll</description>
                    <helpKeyword>configs.fb_factor_fb_factordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1 + query("/FBHit_per_L1Miss") / 2 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FBHit_per_L1Miss" id="FBHit_per_L1Miss">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%FBHit_per_L1MissDescriptionAll</description>
                    <helpKeyword>configs.fbhit_per_l1miss_fbhit_per_l1missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") / query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="Fetched_Uops">
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="Few_Uops_Executed_Threshold">
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") + query("/RetiredPipelineSlots") * query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="FP_Arith_Scalar">
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="FP_Arith_Vector">
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Ops_Sum" id="Light_Ops_Sum">
                    <description>%Light_Ops_SumDescriptionAll</description>
                    <helpKeyword>configs.light_ops_sum_light_ops_sumdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith") + query("/Int_Operations") + query("/Memory_Operations") + query("/Fused_Instructions") + query("/Non_Fused_Branches") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L3_HIT" id="LOAD_L3_HIT">
                    <description>%LOAD_L3_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l3_hit_load_l3_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") * query("/FB_Factor") + 1 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HIT" id="LOAD_XSNP_HIT">
                    <description>%LOAD_XSNP_HITDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hit_load_xsnp_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") + query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") * ( 1 - query("/True_XSNP_HitM_Fraction") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HITM" id="LOAD_XSNP_HITM">
                    <description>%LOAD_XSNP_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hitm_load_xsnp_hitmdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") * query("/True_XSNP_HitM_Fraction") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_MISS" id="LOAD_XSNP_MISS">
                    <description>%LOAD_XSNP_MISSDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_miss_load_xsnp_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="MEM_Bound_Ratio">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Store_Cost" id="Mem_L2_Store_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_L2_Store_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_store_cost_mem_l2_store_costdescriptionall</helpKeyword>
                    <valueEval>10</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Lock_St_Fraction" id="Mem_Lock_St_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Lock_St_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_lock_st_fraction_mem_lock_st_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") / query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="Mispred_Clears_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BranchMispredict") / query("/CancelledPipelineSlots") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_Demand_RFO_C1" id="ORO_Demand_RFO_C1">
                    <description>%ORO_Demand_RFO_C1DescriptionAll</description>
                    <helpKeyword>configs.oro_demand_rfo_c1_oro_demand_rfo_c1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="ORO_DRD_Any_Cycles">
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="ORO_DRD_BW_Cycles">
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_L2_Hit_Cycles" id="Store_L2_Hit_Cycles">
                    <description>%Store_L2_Hit_CyclesDescriptionAll</description>
                    <helpKeyword>configs.store_l2_hit_cycles_store_l2_hit_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") * query("/Mem_L2_Store_Cost") * ( 1 - query("/Mem_Lock_St_Fraction") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%True_XSNP_HitM_Fraction" id="True_XSNP_HitM_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%True_XSNP_HitM_FractionDescriptionAll</description>
                    <helpKeyword>configs.true_xsnp_hitm_fraction_true_xsnp_hitm_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") / ( query("/PMUEventCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") + query("/PMUEventCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_STLB_Hit_Cost" id="Mem_STLB_Hit_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_STLB_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_stlb_hit_cost_mem_stlb_hit_costdescriptionall</helpKeyword>
                    <valueEval>7</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_HitM_Cost" id="Mem_XSNP_HitM_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hitm_cost_mem_xsnp_hitm_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 81 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_Hit_Cost" id="Mem_XSNP_Hit_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hit_cost_mem_xsnp_hit_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 79 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_None_Cost" id="Mem_XSNP_None_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_None_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_none_cost_mem_xsnp_none_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 37 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Local_DRAM_Cost" id="Mem_Local_DRAM_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_Local_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_local_dram_cost_mem_local_dram_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 109 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_DRAM_Cost" id="Mem_Remote_DRAM_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_Remote_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_dram_cost_mem_remote_dram_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 190 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_HitM_Cost" id="Mem_Remote_HitM_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_Remote_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_hitm_cost_mem_remote_hitm_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 170 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_Fwd_Cost" id="Mem_Remote_Fwd_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_Remote_Fwd_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_fwd_cost_mem_remote_fwd_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 170 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Hit_Cost" id="Mem_L2_Hit_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_L2_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_hit_cost_mem_l2_hit_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 4.4 * query("/Core_Frequency") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="MS_Switches_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                    <valueEval>3</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Avg_Assist_Cost" id="Avg_Assist_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Avg_Assist_CostDescriptionAll</description>
                    <helpKeyword>configs.avg_assist_cost_avg_assist_costdescriptionall</helpKeyword>
                    <valueEval>( 99 * 3 + 63 + 30 ) / 5</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="Retire_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]") / query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="Retired_Slots">
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots") * query("/SLOTS") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OneBillion" id="OneBillion">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%OneBillionDescriptionAll</description>
                    <helpKeyword>configs.onebillion_onebilliondescriptionall</helpKeyword>
                    <valueEval>1000000000</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SMT_on" id="SMT_on">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%SMT_onDescriptionAll</description>
                    <helpKeyword>configs.smt_on_smt_ondescriptionall</helpKeyword>
                    <valueEval>$isHTEnabled</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInMilliSeconds" id="DurationTimeInMilliSeconds">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%DurationTimeInMilliSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinmilliseconds_durationtimeinmillisecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/GlobalElapsedTimeQueryAll") * 1000) ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Dependent_Loads_Weight" id="Dependent_Loads_Weight">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Dependent_Loads_WeightDescriptionAll</description>
                    <helpKeyword>configs.dependent_loads_weight_dependent_loads_weightdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 20 ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%TSC" id="TSC">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%TSCDescriptionAll</description>
                    <helpKeyword>configs.tsc_tscdescriptionall</helpKeyword>
                    <valueEval>$referenceFrequency</valueEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorLight_OperationsGroup">
                                            <queryInherit>/locatorLight_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorLight_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorFP_ArithGroup">
                                                        <queryInherit>/locatorFP_Arith</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFP_ArithGroupExpanded">
                                                                <queryRef>/locatorFP_x87</queryRef>
                                                                <queryRef>/locatorFP_Scalar</queryRef>
                                                                <derivedQuery id="locatorFP_VectorGroup">
                                                                    <queryInherit>/locatorFP_Vector</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorFP_VectorGroupExpanded">
                                                                            <queryRef>/locatorFP_Vector_128b</queryRef>
                                                                            <queryRef>/locatorFP_Vector_256b</queryRef>
                                                                            <queryRef>/locatorFP_Vector_512b</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorInt_OperationsGroup">
                                                        <queryInherit>/locatorInt_Operations</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorInt_OperationsGroupExpanded">
                                                                <queryRef>/locatorInt_Vector_128b</queryRef>
                                                                <queryRef>/locatorInt_Vector_256b</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorMemory_Operations</queryRef>
                                                    <queryRef>/locatorFused_Instructions</queryRef>
                                                    <queryRef>/locatorNon_Fused_Branches</queryRef>
                                                    <derivedQuery id="locatorOTHERGroup">
                                                        <queryInherit>/locatorOTHER</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorOTHERGroupExpanded">
                                                                <queryRef>/locatorNop_Instructions</queryRef>
                                                                <queryRef>/locatorShuffles_256b</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorHeavy_OperationsGroup">
                                            <queryInherit>/locatorHeavy_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorHeavy_OperationsGroupExpanded">
                                                    <queryRef>/locatorFew_Uops_Instructions</queryRef>
                                                    <derivedQuery id="locatorMicroSequencerGroup">
                                                        <queryInherit>/locatorMicroSequencer</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMicroSequencerGroupExpanded">
                                                                <derivedQuery id="locatorAssistsGroup">
                                                                    <queryInherit>/locatorAssists</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorAssistsGroupExpanded">
                                                                            <queryRef>/locatorPage_Faults</queryRef>
                                                                            <queryRef>/locatorFP_Assists</queryRef>
                                                                            <queryRef>/locatorAVX_Assists</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorCISC</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses</queryRef>
                                                    <queryRef>/locatorITLBOverhead</queryRef>
                                                    <derivedQuery id="locatorBranchResteersGroup">
                                                        <queryInherit>/locatorBranchResteers</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorBranchResteersGroupExpanded">
                                                                <queryRef>/locatorMispredicts_Resteers</queryRef>
                                                                <queryRef>/locatorClears_Resteers</queryRef>
                                                                <queryRef>/locatorUnknown_Branches</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorMSSwitches</queryRef>
                                                    <queryRef>/locatorLCP</queryRef>
                                                    <queryRef>/locatorDSBtoMITESwitchCost</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <derivedQuery id="locatorFEBandwidthMITEGroup">
                                                        <queryInherit>/locatorFEBandwidthMITE</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFEBandwidthMITEGroupExpanded">
                                                                <queryRef>/locatorDecoder0_Alone</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorFEBandwidthDSB</queryRef>
                                                    <queryRef>/locatorDSB_Coverage</queryRef>
                                                    <queryRef>/locatorDSB_Misses</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBranchMispredictGroup">
                                            <queryInherit>/locatorBranchMispredict</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBranchMispredictGroupExpanded">
                                                    <queryRef>/locatorOther_Mispredicts</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <queryRef>/locatorOther_Nukes</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>/locatorL1Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <derivedQuery id="locatorDTLBOverheadGroup">
                                                                    <queryInherit>/locatorDTLBOverhead</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBOverheadGroupExpanded">
                                                                            <queryRef>/locatorLoad_STLB_Hit</queryRef>
                                                                            <queryRef>/locatorLoad_STLB_Miss</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorLoadsBlockedbyStoreForwarding</queryRef>
                                                                <queryRef>/locatorL1_Hit_Latency</queryRef>
                                                                <queryRef>/locatorLockLatency</queryRef>
                                                                <queryRef>/locatorSplitLoads</queryRef>
                                                                <queryRef>/locatorFBFull</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL2Bound</queryRef>
                                                    <derivedQuery id="locatorL3BoundGroup">
                                                        <queryInherit>/locatorL3Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL3BoundGroupExpanded">
                                                                <queryRef>/locatorContestedAccesses</queryRef>
                                                                <queryRef>/locatorDataSharing</queryRef>
                                                                <queryRef>/locatorL3Latency</queryRef>
                                                                <queryRef>/locatorSQFull</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorHBMBound</queryRef>
                                                    <derivedQuery id="locatorDRAMBoundGroup">
                                                        <queryInherit>/locatorDRAMBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorDRAMBoundGroupExpanded">
                                                                <derivedQuery id="locatorMEMBandwidthGroup">
                                                                    <queryInherit>/locatorMEMBandwidth</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMBandwidthGroupExpanded">
                                                                            <queryRef>/locatorMBA_Stalls</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="locatorMEMLatencyGroup">
                                                                    <queryInherit>/locatorMEMLatency</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMLatencyGroupExpanded">
                                                                            <queryRef>/locatorLocalDRAM</queryRef>
                                                                            <queryRef>/locatorRemoteDRAM</queryRef>
                                                                            <queryRef>/locatorRemoteCache</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorStoresBoundGroup">
                                                        <queryInherit>/locatorStoresBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorStoresBoundGroupExpanded">
                                                                <queryRef>/locatorStoreLatency</queryRef>
                                                                <queryRef>/locatorFalseSharing</queryRef>
                                                                <queryRef>/locatorSplitStores</queryRef>
                                                                <queryRef>/locatorStreaming_Stores</queryRef>
                                                                <derivedQuery id="locatorDTLBStoreOverheadGroup">
                                                                    <queryInherit>/locatorDTLBStoreOverhead</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBStoreOverheadGroupExpanded">
                                                                            <queryRef>/locatorStore_STLB_Hit</queryRef>
                                                                            <queryRef>/locatorStore_STLB_Miss</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <queryRef>/locatorDIVActive</queryRef>
                                                    <derivedQuery id="locatorSerializing_OperationGroup">
                                                        <queryInherit>/locatorSerializing_Operation</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorSerializing_OperationGroupExpanded">
                                                                <queryRef>/locatorSlow_Pause</queryRef>
                                                                <queryRef>/locatorC01_WAIT</queryRef>
                                                                <queryRef>/locatorC02_WAIT</queryRef>
                                                                <queryRef>/locatorMemory_Fence</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorAMX_Busy</queryRef>
                                                    <derivedQuery id="locatorPortUtilGroup">
                                                        <queryInherit>/locatorPortUtil</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorPortUtilGroupExpanded">
                                                                <derivedQuery id="locatorCycles0PortsUtilizedGroup">
                                                                    <queryInherit>/locatorCycles0PortsUtilized</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles0PortsUtilizedGroupExpanded">
                                                                            <queryRef>/locatorMixing_Vectors</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorCycles1PortUtilized</queryRef>
                                                                <queryRef>/locatorCycles2PortsUtilized</queryRef>
                                                                <derivedQuery id="locatorCycles3mPortsUtilizedGroup">
                                                                    <queryInherit>/locatorCycles3mPortsUtilized</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles3mPortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="locatorALU_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorALU_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorALU_Op_UtilizationGroupExpanded">
                                                                                        <queryRef>/locatorPort0</queryRef>
                                                                                        <queryRef>/locatorPort1</queryRef>
                                                                                        <queryRef>/locatorPort6</queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorLoad_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorLoad_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorLoad_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorStore_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorStore_Op_Utilization</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorStore_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <queryRef>/locatorMispredictions</queryRef>
                            <queryRef>/locatorBig_Code</queryRef>
                            <queryRef>/locatorInstruction_Fetch_BW</queryRef>
                            <queryRef>/locatorCache_Memory_Bandwidth</queryRef>
                            <queryRef>/locatorCache_Memory_Latency</queryRef>
                            <queryRef>/locatorMemory_Data_TLBs</queryRef>
                            <queryRef>/locatorMemory_Synchronization</queryRef>
                            <queryRef>/locatorCompute_Bound_Est</queryRef>
                            <queryRef>/locatorIrregular_Overhead</queryRef>
                            <queryRef>/locatorOther_Bottlenecks</queryRef>
                            <queryRef>/locatorBranching_Overhead</queryRef>
                            <queryRef>/locatorUseful_Work</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true)) * queryAll("/RetiredPipelineSlots", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") > 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="locatorLight_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INST_RETIRED.ANY]") / queryAll("/PMUEventCount/PMUEventType[INST_RETIRED.ANY]", true)) * queryAll("/Light_Operations", true) ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLight_Operations") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="locatorFP_x87">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_x87") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_x87") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="locatorFP_Scalar">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Scalar") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Scalar") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="locatorFP_Vector">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_128b" id="locatorFP_Vector_128b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_128b_fp_vector_128bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.128B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector_128b") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector_128b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_256b" id="locatorFP_Vector_256b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_256b_fp_vector_256bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.256B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector_256b") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector_256b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector_512b" id="locatorFP_Vector_512b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Vector_512bDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_512b_fp_vector_512bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.512B_PACKED_HALF]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector_512b") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%FP_Vector_512bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector_512b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Operations" id="locatorInt_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_OperationsDescriptionAll</description>
                    <helpKeyword>configs.int_operations_int_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Operations") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%Int_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_128b" id="locatorInt_Vector_128b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_128b_int_vector_128bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Vector_128b") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%Int_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Vector_128b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_256b" id="locatorInt_Vector_256b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_256b_int_vector_256bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Vector_256b") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]", true) ) ]]></valueEval>
                    <issueText>%Int_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Vector_256b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Operations" id="locatorMemory_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_OperationsDescriptionAll</description>
                    <helpKeyword>configs.memory_operations_memory_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Memory_Operations") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Memory_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemory_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fused_Instructions" id="locatorFused_Instructions">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Fused_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.fused_instructions_fused_instructionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Fused_Instructions") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Fused_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFused_Instructions") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Non_Fused_Branches" id="locatorNon_Fused_Branches">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Non_Fused_BranchesDescriptionAll</description>
                    <helpKeyword>configs.non_fused_branches_non_fused_branchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Non_Fused_Branches") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Non_Fused_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNon_Fused_Branches") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.SCALAR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED2.VECTOR]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_128]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_128]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.ADD_256]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.MUL_256]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.VNNI_256]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) if ( ( ( query("/Light_Operations") - query("/Light_Ops_Sum") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Nop_Instructions" id="locatorNop_Instructions">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Nop_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.nop_instructions_nop_instructionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.NOP]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INST_RETIRED.NOP]") / queryAll("/PMUEventCount/PMUEventType[INST_RETIRED.NOP]", true)) * queryAll("/Nop_Instructions", true) ) ]]></valueEval>
                    <issueText>%Nop_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNop_Instructions") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Shuffles_256b" id="locatorShuffles_256b">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Shuffles_256bDescriptionAll</description>
                    <helpKeyword>configs.shuffles_256b_shuffles_256bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.SHUFFLES]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Shuffles_256b") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Shuffles_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorShuffles_256b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="locatorHeavy_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.HEAVY]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.HEAVY]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.HEAVY]", true)) * queryAll("/Heavy_Operations", true) ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorHeavy_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Instructions" id="locatorFew_Uops_Instructions">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.few_uops_instructions_few_uops_instructionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Few_Uops_Instructions") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Few_Uops_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFew_Uops_Instructions") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]", true)) * queryAll("/MicroSequencer", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="locatorAssists">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ASSISTS.ANY]") / queryAll("/PMUEventCount/PMUEventType[ASSISTS.ANY]", true)) * queryAll("/Assists", true) ) ]]></valueEval>
                    <issueText>%AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorAssists") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Page_Faults" id="locatorPage_Faults">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Page_FaultsDescriptionAll</description>
                    <helpKeyword>configs.page_faults_page_faultsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.PAGE_FAULT]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Page_Faults") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Page_FaultsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPage_Faults") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Assists" id="locatorFP_Assists">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_AssistsDescriptionAll</description>
                    <helpKeyword>configs.fp_assists_fp_assistsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.FP]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Assists") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FP_AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Assists") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%AVX_Assists" id="locatorAVX_Assists">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%AVX_AssistsDescriptionAll</description>
                    <helpKeyword>configs.avx_assists_avx_assistsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/AVX_Assists") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%AVX_AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorAVX_Assists") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CISC" id="locatorCISC">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CISCDescriptionAll</description>
                    <helpKeyword>configs.cisc_ciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]", true)) * queryAll("/CISC", true) ) ]]></valueEval>
                    <issueText>%CISCIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCISC") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]", true)) * queryAll("/FrontendBoundPipelineSlots", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]", true)) * queryAll("/FELatency", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]", true)) * queryAll("/ICacheMisses", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]", true)) * queryAll("/ITLBOverhead", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") / queryAll("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]", true)) * queryAll("/BranchResteers", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="locatorMispredicts_Resteers">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") / queryAll("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]", true)) * queryAll("/Mispredicts_Resteers", true) ) ]]></valueEval>
                    <issueText>%Mispredicts_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMispredicts_Resteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="locatorClears_Resteers">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") / queryAll("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]", true)) * queryAll("/Clears_Resteers", true) ) ]]></valueEval>
                    <issueText>%Clears_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorClears_Resteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="locatorUnknown_Branches">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]", true)) * queryAll("/Unknown_Branches", true) ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorUnknown_Branches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="locatorMSSwitches">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.MS_FLOWS]", true)) * queryAll("/MSSwitches", true) ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMSSwitches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="locatorLCP">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LCP") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLCP") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="locatorDSBtoMITESwitchCost">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]", true)) * queryAll("/DSBtoMITESwitchCost", true) ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSBtoMITESwitchCost") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]", true)) * queryAll("/FEBandwidth", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="locatorFEBandwidthMITE">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]", true)) * queryAll("/FEBandwidthMITE", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthMITE") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Decoder0_Alone" id="locatorDecoder0_Alone">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Decoder0_AloneDescriptionAll</description>
                    <helpKeyword>configs.decoder0_alone_decoder0_alonedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INST_DECODED.DECODERS:cmask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_DECODED.DECODERS:cmask=2]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Decoder0_Alone") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Decoder0_AloneIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDecoder0_Alone") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="locatorFEBandwidthDSB">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDSB") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDSB") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="locatorDSB_Coverage">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]") / queryAll("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]", true)) * queryAll("/DSB_Coverage", true) ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSB_Coverage") < 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Misses" id="locatorDSB_Misses">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSB_MissesDescriptionAll</description>
                    <helpKeyword>configs.dsb_misses_dsb_missesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/DSB_Misses") ) ]]></valueEval>
                    <issueText>%DSB_MissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSB_Misses") > 10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]", true)) * queryAll("/BranchMispredict", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Mispredicts" id="locatorOther_Mispredicts">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Other_MispredictsDescriptionAll</description>
                    <helpKeyword>configs.other_mispredicts_other_mispredictsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Other_Mispredicts") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Other_MispredictsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOther_Mispredicts") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") / queryAll("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]", true)) * queryAll("/MachineClears", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Nukes" id="locatorOther_Nukes">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Other_NukesDescriptionAll</description>
                    <helpKeyword>configs.other_nukes_other_nukesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Other_Nukes") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Other_NukesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOther_Nukes") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]", true)) * queryAll("/BackendBound", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]", true)) * queryAll("/MemBound", true) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]", true)) * queryAll("/L1Bound", true) ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="locatorDTLBOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]", true)) * queryAll("/DTLBOverhead", true) ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDTLBOverhead") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Load_STLB_Hit") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Hit") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Load_STLB_Miss") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Miss") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LoadsBlockedbyStoreForwarding") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoadsBlockedbyStoreForwarding") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1_Hit_Latency" id="locatorL1_Hit_Latency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1_Hit_LatencyDescriptionAll</description>
                    <helpKeyword>configs.l1_hit_latency_l1_hit_latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]", true)) * queryAll("/L1_Hit_Latency", true) ) ]]></valueEval>
                    <issueText>%L1_Hit_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1_Hit_Latency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="locatorLockLatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]", true)) * queryAll("/LockLatency", true) ) ]]></valueEval>
                    <issueText>%LockLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLockLatency") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="locatorSplitLoads">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]", true)) * queryAll("/SplitLoads", true) ) ]]></valueEval>
                    <issueText>%SplitLoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSplitLoads") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="locatorFBFull">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FBFull") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%FBFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFBFull") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]", true)) * queryAll("/L2Bound", true) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]", true)) * queryAll("/L3Bound", true) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="locatorContestedAccesses">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]", true)) * queryAll("/ContestedAccesses", true) ) ]]></valueEval>
                    <issueText>%ContestedAccessesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorContestedAccesses") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="locatorDataSharing">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]", true)) * queryAll("/DataSharing", true) ) ]]></valueEval>
                    <issueText>%DataSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDataSharing") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="locatorL3Latency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]", true)) * queryAll("/L3Latency", true) ) ]]></valueEval>
                    <issueText>%L3LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Latency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="locatorSQFull">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/SQFull") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%SQFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSQFull") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%HBMBound" id="locatorHBMBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%HBMBoundDescriptionAll</description>
                    <helpKeyword>configs.hbmbound_hbmbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/HBMBound") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%HBMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorHBMBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]", true)) * queryAll("/DRAMBound", true) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="locatorMEMBandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMBandwidth") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMBandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MBA_Stalls" id="locatorMBA_Stalls">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MBA_StallsDescriptionAll</description>
                    <helpKeyword>configs.mba_stalls_mba_stallsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.MBA_STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MBA_Stalls") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%MBA_StallsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMBA_Stalls") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="locatorMEMLatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMLatency") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMLatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LocalDRAM" id="locatorLocalDRAM">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LocalDRAMDescriptionAll</description>
                    <helpKeyword>configs.localdram_localdramdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]", true)) * queryAll("/LocalDRAM", true) ) ]]></valueEval>
                    <issueText>%LocalDRAMIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLocalDRAM") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteDRAM" id="locatorRemoteDRAM">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RemoteDRAMDescriptionAll</description>
                    <helpKeyword>configs.remotedram_remotedramdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]", true)) * queryAll("/RemoteDRAM", true) ) ]]></valueEval>
                    <issueText>%RemoteDRAMIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRemoteDRAM") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="locatorRemoteCache">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RemoteCacheDescriptionAll</description>
                    <helpKeyword>configs.remotecache_remotecachedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]", true)) * queryAll("/RemoteCache", true) ) ]]></valueEval>
                    <issueText>%RemoteCacheIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRemoteCache") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]", true)) * queryAll("/StoresBound", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="locatorStoreLatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/StoreLatency") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%StoreLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoreLatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="locatorFalseSharing">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FalseSharing") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%FalseSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFalseSharing") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="locatorSplitStores">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]", true)) * queryAll("/SplitStores", true) ) ]]></valueEval>
                    <issueText>%SplitStoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSplitStores") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Streaming_Stores" id="locatorStreaming_Stores">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Streaming_StoresDescriptionAll</description>
                    <helpKeyword>configs.streaming_stores_streaming_storesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") / queryAll("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]", true)) * queryAll("/Streaming_Stores", true) ) ]]></valueEval>
                    <issueText>%Streaming_StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStreaming_Stores") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="locatorDTLBStoreOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]", true)) * queryAll("/DTLBStoreOverhead", true) ) ]]></valueEval>
                    <issueText>%DTLBStoreOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDTLBStoreOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="locatorStore_STLB_Hit">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Store_STLB_Hit") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Store_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_STLB_Hit") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="locatorStore_STLB_Miss">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Store_STLB_Miss") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Store_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_STLB_Miss") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="locatorDIVActive">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]") / queryAll("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]", true)) * queryAll("/DIVActive", true) ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDIVActive") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") / queryAll("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]", true)) * queryAll("/Serializing_Operation", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="locatorSlow_Pause">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.PAUSE_INST]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.PAUSE_INST]") / queryAll("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.PAUSE_INST]", true)) * queryAll("/Slow_Pause", true) ) ]]></valueEval>
                    <issueText>%Slow_PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSlow_Pause") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%C01_WAIT" id="locatorC01_WAIT">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%C01_WAITDescriptionAll</description>
                    <helpKeyword>configs.c01_wait_c01_waitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C01]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/C01_WAIT") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%C01_WAITIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorC01_WAIT") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%C02_WAIT" id="locatorC02_WAIT">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%C02_WAITDescriptionAll</description>
                    <helpKeyword>configs.c02_wait_c02_waitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/C02_WAIT") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%C02_WAITIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorC02_WAIT") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Fence" id="locatorMemory_Fence">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_FenceDescriptionAll</description>
                    <helpKeyword>configs.memory_fence_memory_fencedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[MISC2_RETIRED.LFENCE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Memory_Fence") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Memory_FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemory_Fence") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%AMX_Busy" id="locatorAMX_Busy">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%AMX_BusyDescriptionAll</description>
                    <helpKeyword>configs.amx_busy_amx_busydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/AMX_Busy") * query("/CORE_CLKS")) / queryAll("/CORE_CLKS", true) ) ]]></valueEval>
                    <issueText>%AMX_BusyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorAMX_Busy") > 0.5 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="locatorPortUtil">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PortUtil") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPortUtil") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="locatorCycles0PortsUtilized">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Cycles0PortsUtilized") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Cycles0PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles0PortsUtilized") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mixing_Vectors" id="locatorMixing_Vectors">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mixing_VectorsDescriptionAll</description>
                    <helpKeyword>configs.mixing_vectors_mixing_vectorsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.SSE_AVX_MIX]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mixing_Vectors") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%Mixing_VectorsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMixing_Vectors") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="locatorCycles1PortUtilized">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") / queryAll("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]", true)) * queryAll("/Cycles1PortUtilized", true) ) ]]></valueEval>
                    <issueText>%Cycles1PortUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles1PortUtilized") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="locatorCycles2PortsUtilized">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") / queryAll("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]", true)) * queryAll("/Cycles2PortsUtilized", true) ) ]]></valueEval>
                    <issueText>%Cycles2PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles2PortsUtilized") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="locatorCycles3mPortsUtilized">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]", true)) * queryAll("/Cycles3mPortsUtilized", true) ) ]]></valueEval>
                    <issueText>%Cycles3mPortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles3mPortsUtilized") > 0.4 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="locatorALU_Op_Utilization">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5_11]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ALU_Op_Utilization") * query("/CORE_CLKS")) / queryAll("/CORE_CLKS", true) ) ]]></valueEval>
                    <issueText>%ALU_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorALU_Op_Utilization") > 0.4 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="locatorPort0">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port0") * query("/CORE_CLKS")) / queryAll("/CORE_CLKS", true) ) ]]></valueEval>
                    <issueText>%Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort0") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="locatorPort1">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port1") * query("/CORE_CLKS")) / queryAll("/CORE_CLKS", true) ) ]]></valueEval>
                    <issueText>%Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort1") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="locatorPort6">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port6") * query("/CORE_CLKS")) / queryAll("/CORE_CLKS", true) ) ]]></valueEval>
                    <issueText>%Port6IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort6") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="locatorLoad_Op_Utilization">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3_10]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3_10]") / queryAll("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3_10]", true)) * queryAll("/Load_Op_Utilization", true) ) ]]></valueEval>
                    <issueText>%Load_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_Op_Utilization") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="locatorStore_Op_Utilization">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]") / queryAll("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]", true)) * queryAll("/Store_Op_Utilization", true) ) ]]></valueEval>
                    <issueText>%Store_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_Op_Utilization") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredictions" id="locatorMispredictions">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MispredictionsDescriptionAll</description>
                    <helpKeyword>configs.mispredictions_mispredictionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mispredictions") ) ]]></valueEval>
                    <issueText>%MispredictionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMispredictions") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Big_Code" id="locatorBig_Code">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Big_CodeDescriptionAll</description>
                    <helpKeyword>configs.big_code_big_codedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Big_Code") ) ]]></valueEval>
                    <issueText>%Big_CodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBig_Code") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Instruction_Fetch_BW" id="locatorInstruction_Fetch_BW">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Instruction_Fetch_BWDescriptionAll</description>
                    <helpKeyword>configs.instruction_fetch_bw_instruction_fetch_bwdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Instruction_Fetch_BW") ) ]]></valueEval>
                    <issueText>%Instruction_Fetch_BWIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInstruction_Fetch_BW") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cache_Memory_Bandwidth" id="locatorCache_Memory_Bandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cache_Memory_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.cache_memory_bandwidth_cache_memory_bandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Cache_Memory_Bandwidth") ) ]]></valueEval>
                    <issueText>%Cache_Memory_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCache_Memory_Bandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cache_Memory_Latency" id="locatorCache_Memory_Latency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cache_Memory_LatencyDescriptionAll</description>
                    <helpKeyword>configs.cache_memory_latency_cache_memory_latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Cache_Memory_Latency") ) ]]></valueEval>
                    <issueText>%Cache_Memory_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCache_Memory_Latency") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Data_TLBs" id="locatorMemory_Data_TLBs">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_Data_TLBsDescriptionAll</description>
                    <helpKeyword>configs.memory_data_tlbs_memory_data_tlbsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( query("/MemBound") > ( ( ( ( ( query("/L1Bound") + query("/L2Bound") ) + query("/L3Bound") ) + query("/HBMBound") ) + query("/DRAMBound") ) + query("/StoresBound") ) ) ) else ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) if ( ( query("/L1Bound") > ( ( ( ( ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") ) + query("/L1_Hit_Latency") ) + query("/LockLatency") ) + query("/SplitLoads") ) + query("/FBFull") ) ) ) else ( ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Data_TLBs") ) ]]></valueEval>
                    <issueText>%Memory_Data_TLBsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemory_Data_TLBs") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Synchronization" id="locatorMemory_Synchronization">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_SynchronizationDescriptionAll</description>
                    <helpKeyword>configs.memory_synchronization_memory_synchronizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Synchronization") ) ]]></valueEval>
                    <issueText>%Memory_SynchronizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemory_Synchronization") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Compute_Bound_Est" id="locatorCompute_Bound_Est">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Compute_Bound_EstDescriptionAll</description>
                    <helpKeyword>configs.compute_bound_est_compute_bound_estdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Compute_Bound_Est") ) ]]></valueEval>
                    <issueText>%Compute_Bound_EstIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCompute_Bound_Est") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Irregular_Overhead" id="locatorIrregular_Overhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Irregular_OverheadDescriptionAll</description>
                    <helpKeyword>configs.irregular_overhead_irregular_overheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE.AMX_BUSY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]") >= 10 ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[RS.EMPTY:umask=1]") ) - ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]") ) ) > 0 ) ) else ( 0 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL:umask=0xc]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations") - query("/MicroSequencer") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Irregular_Overhead") ) ]]></valueEval>
                    <issueText>%Irregular_OverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIrregular_Overhead") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Bottlenecks" id="locatorOther_Bottlenecks">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Other_BottlenecksDescriptionAll</description>
                    <helpKeyword>configs.other_bottlenecks_other_bottlenecksdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.REP_ITERATION]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( (  ( ( (  ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) && ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS:cmask=1:e=yes]") >= 10 ) ) && ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) ) || ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]") >= 10 ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) )  ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[XQ.FULL_CYCLES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALLS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( query("/MemBound") > ( ( ( ( ( query("/L1Bound") + query("/L2Bound") ) + query("/L3Bound") ) + query("/HBMBound") ) + query("/DRAMBound") ) + query("/StoresBound") ) ) ) else ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) && ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) if ( ( query("/L1Bound") > ( ( ( ( ( query("/DTLBOverhead") + query("/LoadsBlockedbyStoreForwarding") ) + query("/L1_Hit_Latency") ) + query("/LockLatency") ) + query("/SplitLoads") ) + query("/FBFull") ) ) ) else ( ( ( ( ( ( ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT:cmask=1]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]") ) ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) ) )  )  ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( ( 2 * ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") ) ) - ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") ) ) ) * 111 ) / 100 ) / query("/DerivedClockticks") ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) else ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.CYCLES_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) || ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.ALL_RFO]") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_COMPLETED.L1_MISS_ANY]") >= 10 )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) && ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_STORE_RETIRED.L2_HIT]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT:cmask=1]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) && ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.LOCAL_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_DRAM]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_HITM]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_MISS_RETIRED.REMOTE_FWD]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) && ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]") ) - ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L1D_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L2_MISS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_ACTIVITY.STALLS_L3_MISS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.PMM]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[OCR.READS_TO_CORE.L3_MISS]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) || ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_NO_FWD]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_FWD]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HITM]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_DATA_RD.L3_HIT.SNOOP_HIT_WITH_FWD]") >= 10 ) ) ) ) ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) || ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/