/*******************************************************************************
 * Copyright 2005 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/* Intel(R) Integrated Performance Primitives (Intel(R) IPP) tutorial */

#ifndef IPP_BLUR_ROTATE_H__
#define IPP_BLUR_ROTATE_H__

#include <ipp.h>
#include "gui/video.h"

// The main processing class
class ipp_blur_rotate
{
    /* updated filter mask should be applied */
    bool bFilterUpdate;
    /* updated rotation coefficients (angle and shifts) should be applied */
    bool bRotateUpdate;
    /* redraw the window */
    bool bRedraw;

    /* source image size */
    IppiSize srcSize;
    /* destination image size (should include whole rotated image) */
    IppiSize dstSize;

    /* Pointer to the source image data */
    Ipp8u *pSrc;
    /* Pointer to the blurred image data */
    Ipp8u *pBlur;
    /* Pointer to the blurred and rotated image data */
    Ipp8u *pBlurRot;

    /* image steps */
    int srcStep, blurStep, blurRotStep;

    /* rotation angle */
    double angle;

    /* size of mask for image blurring */
    IppiSize maskSize;

public:
    /* Constructor */
    ipp_blur_rotate();

    /* Destructor */
    ~ipp_blur_rotate();

    /* load image data from bmp file */
    bool loadFileBMP(const char *bmpImageFile);

    /* Returns size of required rendering area */
    IppiSize windowSize() const { return dstSize; };

    /* Key processing */
    void onKey(int key);

    /* Run processing */
    void process(const drawing_memory &dm);
};

#endif /* IPP_BLUR_ROTATE_H__ */
