/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms.predicates;

import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class HasHeaderKey<R extends ConnectRecord<R>>
implements Predicate<R>,
Versioned {
    private static final String NAME_CONFIG = "name";
    public static final String OVERVIEW_DOC = "A predicate which is true for records with at least one header with the configured name.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("name", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, "The header name.");
    private String name;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public boolean test(R record) {
        Iterator headerIterator = record.headers().allWithName(this.name);
        return headerIterator != null && headerIterator.hasNext();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.name = new SimpleConfig(this.config(), configs).getString(NAME_CONFIG);
    }

    public String toString() {
        return "HasHeaderKey{name='" + this.name + "'}";
    }
}

