/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedStreamImpl;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.SessionStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.SessionStore;

public class SessionWindowedCogroupedKStreamImpl<K, V>
extends AbstractStream<K, V>
implements SessionWindowedCogroupedKStream<K, V> {
    private final SessionWindows sessionWindows;
    private final CogroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns;

    SessionWindowedCogroupedKStreamImpl(SessionWindows sessionWindows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, CogroupedStreamAggregateBuilder<K, V> aggregateBuilder, GraphNode graphNode, Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns) {
        super(name, null, null, subTopologySourceNodes, graphNode, builder);
        this.sessionWindows = sessionWindows;
        this.aggregateBuilder = aggregateBuilder;
        this.groupPatterns = groupPatterns;
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger) {
        return this.aggregate(initializer, sessionMerger, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, sessionMerger, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Named named) {
        return this.aggregate(initializer, sessionMerger, named, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Named named, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Objects.requireNonNull(named, "named can't be null");
        MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, SessionStore<Bytes, byte[]>>(materialized, this.builder, "COGROUPKSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(this.groupPatterns, initializer, new NamedInternal(named), new SessionStoreMaterializer<K, V>(materializedInternal, this.sessionWindows, EmitStrategy.onWindowUpdate()), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde(), materializedInternal.queryableStoreName(), this.sessionWindows, sessionMerger);
    }
}

