/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ResultMementoInstantiation;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderInstantiation;
import org.hibernate.type.descriptor.java.JavaType;

public class ResultMementoInstantiationStandard
implements ResultMementoInstantiation {
    private final JavaType<?> instantiatedJtd;
    private final List<ResultMementoInstantiation.ArgumentMemento> argumentMementos;

    public ResultMementoInstantiationStandard(JavaType<?> instantiatedJtd, List<ResultMementoInstantiation.ArgumentMemento> argumentMementos) {
        this.instantiatedJtd = instantiatedJtd;
        this.argumentMementos = argumentMementos;
    }

    public JavaType<?> getInstantiatedJavaType() {
        return this.instantiatedJtd;
    }

    public List<ResultMementoInstantiation.ArgumentMemento> getArgumentMementos() {
        return Collections.unmodifiableList(this.argumentMementos);
    }

    @Override
    public ResultBuilder resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        ArrayList<ResultBuilder> argumentBuilders = CollectionHelper.arrayList(this.argumentMementos.size());
        this.argumentMementos.forEach(argumentMemento -> argumentBuilders.add(argumentMemento.resolve(querySpaceConsumer, context)));
        return new CompleteResultBuilderInstantiation(this.instantiatedJtd, argumentBuilders);
    }
}

