/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class LongKeyIntValueHashMap
extends BaseHashMap {
    private Set keySet;
    private Collection values;

    public LongKeyIntValueHashMap() {
        this(16, 0.75f);
    }

    public LongKeyIntValueHashMap(boolean bl) {
        this(16, 0.75f);
        this.minimizeOnEmpty = bl;
    }

    public LongKeyIntValueHashMap(int n) throws IllegalArgumentException {
        this(n, 0.75f);
    }

    public LongKeyIntValueHashMap(int n, float f) throws IllegalArgumentException {
        super(n, f, 2, 1, false);
    }

    public int get(long l) throws NoSuchElementException {
        int n = this.getLookup(l);
        if (n != -1) {
            return this.intValueTable[n];
        }
        throw new NoSuchElementException();
    }

    public int get(long l, int n) {
        int n2 = this.getLookup(l);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        return n;
    }

    public boolean get(long l, int[] nArray) {
        int n = this.getLookup(l);
        if (n != -1) {
            nArray[0] = this.intValueTable[n];
            return true;
        }
        return false;
    }

    public boolean put(long l, int n) {
        int n2 = this.size();
        super.addOrRemove(l, n, null, null, false);
        return n2 != this.size();
    }

    public boolean remove(long l) {
        int n = this.size();
        super.addOrRemove(l, 0L, null, null, true);
        return n != this.size();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            throw new RuntimeException();
        }

        @Override
        public Object get(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyIntValueHashMap.this.clear();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object object) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyIntValueHashMap.this.clear();
        }
    }
}

