/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;

abstract class TypeBinder
extends Binder {
    public static final int BYTELEN = 24;
    protected byte[] paramVal;
    protected OracleTypeADT paramOtype;

    TypeBinder(byte[] val, OracleTypeADT otype) {
        this.paramVal = val;
        this.paramOtype = otype;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        if (clearPriorBindValues && stmt.isThinDriver()) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int len = value.length;
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                bindData.put(value, 0, len);
                bindDataLengths[bindDataIndex] = len;
                stmt.lastBoundDataLengths[bindPosition] = len;
                bindIndicators[lenoffset] = (short)len;
            }
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, this.paramVal, internalType, null, 0);
    }
}

