/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.runner.LineTransformer;
import com.amazon.randomcutforest.runner.SimpleRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class AnomalyScoreRunner
extends SimpleRunner {
    public AnomalyScoreRunner() {
        super(AnomalyScoreRunner.class.getName(), "Compute scalar anomaly scores from the input rows and append them to the output rows.", AnomalyScoreTransformer::new);
    }

    public static void main(String ... args) throws IOException {
        AnomalyScoreRunner runner = new AnomalyScoreRunner();
        runner.parse(args);
        System.out.println("Reading from stdin... (Ctrl-c to exit)");
        runner.run(new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        System.out.println("Done.");
    }

    public static class AnomalyScoreTransformer
    implements LineTransformer {
        private final RandomCutForest forest;

        public AnomalyScoreTransformer(RandomCutForest forest) {
            this.forest = forest;
        }

        @Override
        public List<String> getResultValues(double ... point) {
            double score = this.forest.getAnomalyScore(point);
            this.forest.update(point);
            return Collections.singletonList(Double.toString(score));
        }

        @Override
        public List<String> getEmptyResultValue() {
            return Collections.singletonList("NA");
        }

        @Override
        public List<String> getResultColumnNames() {
            return Collections.singletonList("anomaly_score");
        }

        @Override
        public RandomCutForest getForest() {
            return this.forest;
        }
    }
}

