"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorkerUrls = exports.getWorkerUrl = exports.WORKER_FILES = exports.WorkerLabels = void 0;
var WorkerLabels;
(function (WorkerLabels) {
    WorkerLabels["PPL"] = "ppl";
    WorkerLabels["JSON"] = "json";
    WorkerLabels["XJSON"] = "xjson";
})(WorkerLabels = exports.WorkerLabels || (exports.WorkerLabels = {}));
/**
 * Worker filenames (relative paths).
 * Monaco package only defines its worker files, not server routing.
 */
exports.WORKER_FILES = {
    ppl: 'ppl.editor.worker.js',
    json: 'json.editor.worker.js',
    xjson: 'xjson.editor.worker.js',
};
/**
 * Get the full URL for a worker by its ID.
 *
 * @param workerId - The worker identifier
 * @param buildHash - The build hash for cache-busting (e.g., buildNum.toString())
 * @returns The full URL for the worker, or undefined if not found
 */
function getWorkerUrl(workerId, buildHash) {
    const filename = exports.WORKER_FILES[workerId];
    return filename ? `/${buildHash}/editor/workers/${filename}` : undefined;
}
exports.getWorkerUrl = getWorkerUrl;
/**
 * Helper to generate all worker URLs with the given buildHash.
 *
 * @param buildHash - The build hash for cache-busting (e.g., buildNum.toString())
 * @returns Object with all worker URLs
 */
function getWorkerUrls(buildHash) {
    return {
        ppl: `/${buildHash}/editor/workers/${exports.WORKER_FILES.ppl}`,
        json: `/${buildHash}/editor/workers/${exports.WORKER_FILES.json}`,
        xjson: `/${buildHash}/editor/workers/${exports.WORKER_FILES.xjson}`,
    };
}
exports.getWorkerUrls = getWorkerUrls;
//# sourceMappingURL=worker_config.js.map