/*
 * Decompiled with CFR 0.152.
 */
package RawRSAKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawRSAKeyring_Compile.RsaGenerateAndWrapKeyMaterial;
import RawRSAKeyring_Compile.RsaUnwrapInfo;
import RawRSAKeyring_Compile.RsaUnwrapKeyMaterial;
import RawRSAKeyring_Compile.RsaWrapInfo;
import RawRSAKeyring_Compile.RsaWrapKeyMaterial;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RawRSAKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<RsaUnwrapKeyMaterial> _privateKeyMaterial = Option.Default(TypeDescriptor.reference(RsaUnwrapKeyMaterial.class));
    public Option<RsaWrapKeyMaterial> _publicKeyMaterial = Option.Default(TypeDescriptor.reference(RsaWrapKeyMaterial.class));
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()));
    public Option<DafnySequence<? extends Byte>> _privateKey = Option.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()));
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    public RSAPaddingMode _paddingScheme = RSAPaddingMode.Default();
    private static final TypeDescriptor<RawRSAKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawRSAKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out3 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out3;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out3 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out3;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, Option<DafnySequence<? extends Byte>> publicKey, Option<DafnySequence<? extends Byte>> privateKey, RSAPaddingMode paddingScheme, AtomicPrimitivesClient cryptoPrimitives) {
        DafnySequence<? extends Byte> _4_extract;
        DafnySequence<? extends Byte> _1_extract;
        this._keyNamespace = namespace;
        this._keyName = name;
        this._paddingScheme = paddingScheme;
        this._publicKey = publicKey;
        this._privateKey = privateKey;
        this._cryptoPrimitives = cryptoPrimitives;
        Option<Object> _0_localPrivateKeyMaterial = Option.create_None(TypeDescriptor.reference(RsaUnwrapKeyMaterial.class));
        if (privateKey.is_Some() && (long)(_1_extract = privateKey.Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()))).cardinalityInt() != 0L) {
            RsaUnwrapKeyMaterial _nw0 = new RsaUnwrapKeyMaterial();
            _nw0.__ctor(_1_extract, paddingScheme, cryptoPrimitives);
            RsaUnwrapKeyMaterial _2_unwrap = _nw0;
            _0_localPrivateKeyMaterial = Option.create_Some(TypeDescriptor.reference(RsaUnwrapKeyMaterial.class), _2_unwrap);
        }
        Option<Object> _3_localPublicKeyMaterial = Option.create_None(TypeDescriptor.reference(RsaWrapKeyMaterial.class));
        if (publicKey.is_Some() && (long)(_4_extract = publicKey.Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()))).cardinalityInt() != 0L) {
            RsaWrapKeyMaterial _nw1 = new RsaWrapKeyMaterial();
            _nw1.__ctor(_4_extract, paddingScheme, cryptoPrimitives);
            RsaWrapKeyMaterial _5_wrap = _nw1;
            _3_localPublicKeyMaterial = Option.create_Some(TypeDescriptor.reference(RsaWrapKeyMaterial.class), _5_wrap);
        }
        this._publicKeyMaterial = _3_localPublicKeyMaterial;
        this._privateKeyMaterial = _0_localPrivateKeyMaterial;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), this.publicKeyMaterial().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a public key cannot provide OnEncrypt")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        EncryptionMaterials _1_materials = input.dtor_materials();
        AlgorithmSuiteInfo _2_suite = _1_materials.dtor_algorithmSuite();
        RsaGenerateAndWrapKeyMaterial _nw0 = new RsaGenerateAndWrapKeyMaterial();
        _nw0.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaGenerateAndWrapKeyMaterial _3_generateAndWrap = _nw0;
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Error> _4_valueOrError1 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(RsaWrapInfo._typeDescriptor(), RsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Error> _out0 = EdkWrapping_Compile.__default.WrapEdkMaterial(RsaWrapInfo._typeDescriptor(), _1_materials, this.publicKeyMaterial().dtor_value(), _3_generateAndWrap);
        _4_valueOrError1 = _out0;
        if (_4_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _4_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<RsaWrapInfo> _5_wrapOutput = _4_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<Object> _6_symmetricSigningKeyList = _5_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_5_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        EncryptedDataKey _7_edk = EncryptedDataKey.create(this.keyNamespace(), this.keyName(), _5_wrapOutput.dtor_wrappedMaterial());
        if (_5_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _8_valueOrError2 = null;
            _8_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1_materials, _5_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_8_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _8_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _9_result = _8_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_9_result));
            return output;
        }
        if (_5_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _10_valueOrError3 = null;
            _10_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_10_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _10_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _11_result = _10_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_11_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), this.privateKeyMaterial().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a private key cannot provide OnEncrypt")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DecryptionMaterials _1_materials = input.dtor_materials();
        Outcome<Error> _2_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError1 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _3_errors = DafnySequence.empty(Error._typeDescriptor());
        long _hi0 = input.dtor_encryptedDataKeys().cardinalityInt();
        long _4_i = 0L;
        while (Long.compareUnsigned(_4_i, _hi0) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.unsignedToInt((long)_4_i)))) {
                EncryptedDataKey _5_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.unsignedToInt((long)_4_i));
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _out0 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(RsaUnwrapInfo._typeDescriptor(), _5_edk.dtor_ciphertext(), _1_materials, this.privateKeyMaterial().dtor_value());
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _6_unwrapOutput = _out0;
                if (_6_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _7_valueOrError2 = null;
                    _7_valueOrError2 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1_materials, _6_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _6_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_7_valueOrError2.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _7_valueOrError2.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _8_returnMaterials = _7_valueOrError2.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    output = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_8_returnMaterials));
                    return output;
                }
                _3_errors = DafnySequence.concatenate((DafnySequence)_3_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_6_unwrapOutput.dtor_error()}));
            } else {
                Result<DafnySequence, Error> _9_valueOrError3 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _9_valueOrError3 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.unsignedToInt((long)_4_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _10_e_boxed0 -> {
                    DafnySequence _10_e = _10_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_10_e);
                });
                if (_9_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _9_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _11_extractedKeyProviderId = _9_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _3_errors = DafnySequence.concatenate((DafnySequence)_3_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(StandardLibrary_mString_Compile.__default.Base10Int2String(Helpers.unsignedToBigInteger((long)_4_i)), (DafnySequence<? extends Character>)DafnySequence.asString((String)"RSAKeyring"), (DafnySequence<? extends Character>)_11_extractedKeyProviderId))}));
            }
            ++_4_i;
        }
        output = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_3_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw RSA Key was unable to decrypt any encrypted data key. The list of encountered Exceptions is available via `list`.")));
        return output;
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()) && edk.dtor_keyProviderInfo().equals(this.keyName()) && edk.dtor_keyProviderId().equals(this.keyNamespace()) && (long)edk.dtor_ciphertext().cardinalityInt() != 0L;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<RsaUnwrapKeyMaterial> privateKeyMaterial() {
        return this._privateKeyMaterial;
    }

    public Option<RsaWrapKeyMaterial> publicKeyMaterial() {
        return this._publicKeyMaterial;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public Option<DafnySequence<? extends Byte>> privateKey() {
        return this._privateKey;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public RSAPaddingMode paddingScheme() {
        return this._paddingScheme;
    }

    public static TypeDescriptor<RawRSAKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawRSAKeyring.RawRSAKeyring";
    }
}

