/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoteVectorIndexClientStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoteVectorIndexClientStats> {
    @Nullable
    private final Long buildRequestFailureCount;
    @Nullable
    private final Long buildRequestSuccessCount;
    @Nullable
    private final Long indexBuildFailureCount;
    @Nullable
    private final Long indexBuildSuccessCount;
    @Nullable
    private final Long statusRequestFailureCount;
    @Nullable
    private final Long statusRequestSuccessCount;
    @Nullable
    private final Long waitingTimeInMs;
    public static final JsonpDeserializer<RemoteVectorIndexClientStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteVectorIndexClientStats::setupRemoteVectorIndexClientStatsDeserializer);

    private RemoteVectorIndexClientStats(Builder builder) {
        this.buildRequestFailureCount = builder.buildRequestFailureCount;
        this.buildRequestSuccessCount = builder.buildRequestSuccessCount;
        this.indexBuildFailureCount = builder.indexBuildFailureCount;
        this.indexBuildSuccessCount = builder.indexBuildSuccessCount;
        this.statusRequestFailureCount = builder.statusRequestFailureCount;
        this.statusRequestSuccessCount = builder.statusRequestSuccessCount;
        this.waitingTimeInMs = builder.waitingTimeInMs;
    }

    public static RemoteVectorIndexClientStats of(Function<Builder, ObjectBuilder<RemoteVectorIndexClientStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long buildRequestFailureCount() {
        return this.buildRequestFailureCount;
    }

    @Nullable
    public final Long buildRequestSuccessCount() {
        return this.buildRequestSuccessCount;
    }

    @Nullable
    public final Long indexBuildFailureCount() {
        return this.indexBuildFailureCount;
    }

    @Nullable
    public final Long indexBuildSuccessCount() {
        return this.indexBuildSuccessCount;
    }

    @Nullable
    public final Long statusRequestFailureCount() {
        return this.statusRequestFailureCount;
    }

    @Nullable
    public final Long statusRequestSuccessCount() {
        return this.statusRequestSuccessCount;
    }

    @Nullable
    public final Long waitingTimeInMs() {
        return this.waitingTimeInMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.buildRequestFailureCount != null) {
            generator.writeKey("build_request_failure_count");
            generator.write(this.buildRequestFailureCount.longValue());
        }
        if (this.buildRequestSuccessCount != null) {
            generator.writeKey("build_request_success_count");
            generator.write(this.buildRequestSuccessCount.longValue());
        }
        if (this.indexBuildFailureCount != null) {
            generator.writeKey("index_build_failure_count");
            generator.write(this.indexBuildFailureCount.longValue());
        }
        if (this.indexBuildSuccessCount != null) {
            generator.writeKey("index_build_success_count");
            generator.write(this.indexBuildSuccessCount.longValue());
        }
        if (this.statusRequestFailureCount != null) {
            generator.writeKey("status_request_failure_count");
            generator.write(this.statusRequestFailureCount.longValue());
        }
        if (this.statusRequestSuccessCount != null) {
            generator.writeKey("status_request_success_count");
            generator.write(this.statusRequestSuccessCount.longValue());
        }
        if (this.waitingTimeInMs != null) {
            generator.writeKey("waiting_time_in_ms");
            generator.write(this.waitingTimeInMs.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoteVectorIndexClientStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildRequestFailureCount, JsonpDeserializer.longDeserializer(), "build_request_failure_count");
        op.add(Builder::buildRequestSuccessCount, JsonpDeserializer.longDeserializer(), "build_request_success_count");
        op.add(Builder::indexBuildFailureCount, JsonpDeserializer.longDeserializer(), "index_build_failure_count");
        op.add(Builder::indexBuildSuccessCount, JsonpDeserializer.longDeserializer(), "index_build_success_count");
        op.add(Builder::statusRequestFailureCount, JsonpDeserializer.longDeserializer(), "status_request_failure_count");
        op.add(Builder::statusRequestSuccessCount, JsonpDeserializer.longDeserializer(), "status_request_success_count");
        op.add(Builder::waitingTimeInMs, JsonpDeserializer.longDeserializer(), "waiting_time_in_ms");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.buildRequestFailureCount);
        result = 31 * result + Objects.hashCode(this.buildRequestSuccessCount);
        result = 31 * result + Objects.hashCode(this.indexBuildFailureCount);
        result = 31 * result + Objects.hashCode(this.indexBuildSuccessCount);
        result = 31 * result + Objects.hashCode(this.statusRequestFailureCount);
        result = 31 * result + Objects.hashCode(this.statusRequestSuccessCount);
        result = 31 * result + Objects.hashCode(this.waitingTimeInMs);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteVectorIndexClientStats other = (RemoteVectorIndexClientStats)o;
        return Objects.equals(this.buildRequestFailureCount, other.buildRequestFailureCount) && Objects.equals(this.buildRequestSuccessCount, other.buildRequestSuccessCount) && Objects.equals(this.indexBuildFailureCount, other.indexBuildFailureCount) && Objects.equals(this.indexBuildSuccessCount, other.indexBuildSuccessCount) && Objects.equals(this.statusRequestFailureCount, other.statusRequestFailureCount) && Objects.equals(this.statusRequestSuccessCount, other.statusRequestSuccessCount) && Objects.equals(this.waitingTimeInMs, other.waitingTimeInMs);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoteVectorIndexClientStats> {
        @Nullable
        private Long buildRequestFailureCount;
        @Nullable
        private Long buildRequestSuccessCount;
        @Nullable
        private Long indexBuildFailureCount;
        @Nullable
        private Long indexBuildSuccessCount;
        @Nullable
        private Long statusRequestFailureCount;
        @Nullable
        private Long statusRequestSuccessCount;
        @Nullable
        private Long waitingTimeInMs;

        public Builder() {
        }

        private Builder(RemoteVectorIndexClientStats o) {
            this.buildRequestFailureCount = o.buildRequestFailureCount;
            this.buildRequestSuccessCount = o.buildRequestSuccessCount;
            this.indexBuildFailureCount = o.indexBuildFailureCount;
            this.indexBuildSuccessCount = o.indexBuildSuccessCount;
            this.statusRequestFailureCount = o.statusRequestFailureCount;
            this.statusRequestSuccessCount = o.statusRequestSuccessCount;
            this.waitingTimeInMs = o.waitingTimeInMs;
        }

        private Builder(Builder o) {
            this.buildRequestFailureCount = o.buildRequestFailureCount;
            this.buildRequestSuccessCount = o.buildRequestSuccessCount;
            this.indexBuildFailureCount = o.indexBuildFailureCount;
            this.indexBuildSuccessCount = o.indexBuildSuccessCount;
            this.statusRequestFailureCount = o.statusRequestFailureCount;
            this.statusRequestSuccessCount = o.statusRequestSuccessCount;
            this.waitingTimeInMs = o.waitingTimeInMs;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder buildRequestFailureCount(@Nullable Long value) {
            this.buildRequestFailureCount = value;
            return this;
        }

        @Nonnull
        public final Builder buildRequestSuccessCount(@Nullable Long value) {
            this.buildRequestSuccessCount = value;
            return this;
        }

        @Nonnull
        public final Builder indexBuildFailureCount(@Nullable Long value) {
            this.indexBuildFailureCount = value;
            return this;
        }

        @Nonnull
        public final Builder indexBuildSuccessCount(@Nullable Long value) {
            this.indexBuildSuccessCount = value;
            return this;
        }

        @Nonnull
        public final Builder statusRequestFailureCount(@Nullable Long value) {
            this.statusRequestFailureCount = value;
            return this;
        }

        @Nonnull
        public final Builder statusRequestSuccessCount(@Nullable Long value) {
            this.statusRequestSuccessCount = value;
            return this;
        }

        @Nonnull
        public final Builder waitingTimeInMs(@Nullable Long value) {
            this.waitingTimeInMs = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoteVectorIndexClientStats build() {
            this._checkSingleUse();
            return new RemoteVectorIndexClientStats(this);
        }
    }
}

