/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JwtBearerRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionCreator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.DefaultAssertionCreator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.FileAssertionCreator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.StaticAssertionJwtTemplate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class JwtBearerJwtRetriever
implements JwtRetriever {
    private final Time time;
    private HttpJwtRetriever delegate;
    private AssertionJwtTemplate assertionJwtTemplate;
    private AssertionCreator assertionCreator;

    public JwtBearerJwtRetriever() {
        this(Time.SYSTEM);
    }

    public JwtBearerJwtRetriever(Time time) {
        this.time = time;
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        String scope = cu.validateString("sasl.oauthbearer.scope", false);
        if (cu.validateString("sasl.oauthbearer.assertion.file", false) != null) {
            File assertionFile = cu.validateFile("sasl.oauthbearer.assertion.file");
            this.assertionCreator = new FileAssertionCreator(assertionFile);
            this.assertionJwtTemplate = new StaticAssertionJwtTemplate();
        } else {
            String algorithm = cu.validateString("sasl.oauthbearer.assertion.algorithm");
            File privateKeyFile = cu.validateFile("sasl.oauthbearer.assertion.private.key.file");
            Optional<String> passphrase = cu.containsKey("sasl.oauthbearer.assertion.private.key.passphrase") ? Optional.of(cu.validatePassword("sasl.oauthbearer.assertion.private.key.passphrase")) : Optional.empty();
            this.assertionCreator = new DefaultAssertionCreator(algorithm, privateKeyFile, passphrase);
            this.assertionJwtTemplate = AssertionUtils.layeredAssertionJwtTemplate(cu, this.time);
        }
        Supplier<String> assertionSupplier = () -> {
            try {
                return this.assertionCreator.create(this.assertionJwtTemplate);
            }
            catch (Exception e) {
                throw new JwtRetrieverException(e);
            }
        };
        JwtBearerRequestFormatter requestFormatter = new JwtBearerRequestFormatter(scope, assertionSupplier);
        this.delegate = new HttpJwtRetriever(requestFormatter);
        this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public String retrieve() throws JwtRetrieverException {
        if (this.delegate == null) {
            throw new IllegalStateException("JWT retriever delegate is null; please call configure() first");
        }
        return this.delegate.retrieve();
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly(this.assertionCreator, "JWT assertion creator");
        Utils.closeQuietly(this.assertionJwtTemplate, "JWT assertion template");
        Utils.closeQuietly(this.delegate, "JWT retriever delegate");
    }
}

