﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Provides details about a CloudTrail trail.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsCloudTrailTrailDetails">AWS
 * API Reference</a></p>
 */
class AwsCloudTrailTrailDetails {
 public:
  AWS_SECURITYHUB_API AwsCloudTrailTrailDetails() = default;
  AWS_SECURITYHUB_API AwsCloudTrailTrailDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsCloudTrailTrailDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the log group that CloudTrail logs are delivered to.</p>
   */
  inline const Aws::String& GetCloudWatchLogsLogGroupArn() const { return m_cloudWatchLogsLogGroupArn; }
  inline bool CloudWatchLogsLogGroupArnHasBeenSet() const { return m_cloudWatchLogsLogGroupArnHasBeenSet; }
  template <typename CloudWatchLogsLogGroupArnT = Aws::String>
  void SetCloudWatchLogsLogGroupArn(CloudWatchLogsLogGroupArnT&& value) {
    m_cloudWatchLogsLogGroupArnHasBeenSet = true;
    m_cloudWatchLogsLogGroupArn = std::forward<CloudWatchLogsLogGroupArnT>(value);
  }
  template <typename CloudWatchLogsLogGroupArnT = Aws::String>
  AwsCloudTrailTrailDetails& WithCloudWatchLogsLogGroupArn(CloudWatchLogsLogGroupArnT&& value) {
    SetCloudWatchLogsLogGroupArn(std::forward<CloudWatchLogsLogGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the role that the CloudWatch Events endpoint assumes when it
   * writes to the log group.</p>
   */
  inline const Aws::String& GetCloudWatchLogsRoleArn() const { return m_cloudWatchLogsRoleArn; }
  inline bool CloudWatchLogsRoleArnHasBeenSet() const { return m_cloudWatchLogsRoleArnHasBeenSet; }
  template <typename CloudWatchLogsRoleArnT = Aws::String>
  void SetCloudWatchLogsRoleArn(CloudWatchLogsRoleArnT&& value) {
    m_cloudWatchLogsRoleArnHasBeenSet = true;
    m_cloudWatchLogsRoleArn = std::forward<CloudWatchLogsRoleArnT>(value);
  }
  template <typename CloudWatchLogsRoleArnT = Aws::String>
  AwsCloudTrailTrailDetails& WithCloudWatchLogsRoleArn(CloudWatchLogsRoleArnT&& value) {
    SetCloudWatchLogsRoleArn(std::forward<CloudWatchLogsRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the trail has custom event selectors.</p>
   */
  inline bool GetHasCustomEventSelectors() const { return m_hasCustomEventSelectors; }
  inline bool HasCustomEventSelectorsHasBeenSet() const { return m_hasCustomEventSelectorsHasBeenSet; }
  inline void SetHasCustomEventSelectors(bool value) {
    m_hasCustomEventSelectorsHasBeenSet = true;
    m_hasCustomEventSelectors = value;
  }
  inline AwsCloudTrailTrailDetails& WithHasCustomEventSelectors(bool value) {
    SetHasCustomEventSelectors(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Region where the trail was created.</p>
   */
  inline const Aws::String& GetHomeRegion() const { return m_homeRegion; }
  inline bool HomeRegionHasBeenSet() const { return m_homeRegionHasBeenSet; }
  template <typename HomeRegionT = Aws::String>
  void SetHomeRegion(HomeRegionT&& value) {
    m_homeRegionHasBeenSet = true;
    m_homeRegion = std::forward<HomeRegionT>(value);
  }
  template <typename HomeRegionT = Aws::String>
  AwsCloudTrailTrailDetails& WithHomeRegion(HomeRegionT&& value) {
    SetHomeRegion(std::forward<HomeRegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the trail publishes events from global services such as IAM
   * to the log files.</p>
   */
  inline bool GetIncludeGlobalServiceEvents() const { return m_includeGlobalServiceEvents; }
  inline bool IncludeGlobalServiceEventsHasBeenSet() const { return m_includeGlobalServiceEventsHasBeenSet; }
  inline void SetIncludeGlobalServiceEvents(bool value) {
    m_includeGlobalServiceEventsHasBeenSet = true;
    m_includeGlobalServiceEvents = value;
  }
  inline AwsCloudTrailTrailDetails& WithIncludeGlobalServiceEvents(bool value) {
    SetIncludeGlobalServiceEvents(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the trail applies only to the current Region or to all
   * Regions.</p>
   */
  inline bool GetIsMultiRegionTrail() const { return m_isMultiRegionTrail; }
  inline bool IsMultiRegionTrailHasBeenSet() const { return m_isMultiRegionTrailHasBeenSet; }
  inline void SetIsMultiRegionTrail(bool value) {
    m_isMultiRegionTrailHasBeenSet = true;
    m_isMultiRegionTrail = value;
  }
  inline AwsCloudTrailTrailDetails& WithIsMultiRegionTrail(bool value) {
    SetIsMultiRegionTrail(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the trail is created for all accounts in an organization in
   * Organizations, or only for the current Amazon Web Services account.</p>
   */
  inline bool GetIsOrganizationTrail() const { return m_isOrganizationTrail; }
  inline bool IsOrganizationTrailHasBeenSet() const { return m_isOrganizationTrailHasBeenSet; }
  inline void SetIsOrganizationTrail(bool value) {
    m_isOrganizationTrailHasBeenSet = true;
    m_isOrganizationTrail = value;
  }
  inline AwsCloudTrailTrailDetails& WithIsOrganizationTrail(bool value) {
    SetIsOrganizationTrail(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The KMS key ID to use to encrypt the logs.</p>
   */
  inline const Aws::String& GetKmsKeyId() const { return m_kmsKeyId; }
  inline bool KmsKeyIdHasBeenSet() const { return m_kmsKeyIdHasBeenSet; }
  template <typename KmsKeyIdT = Aws::String>
  void SetKmsKeyId(KmsKeyIdT&& value) {
    m_kmsKeyIdHasBeenSet = true;
    m_kmsKeyId = std::forward<KmsKeyIdT>(value);
  }
  template <typename KmsKeyIdT = Aws::String>
  AwsCloudTrailTrailDetails& WithKmsKeyId(KmsKeyIdT&& value) {
    SetKmsKeyId(std::forward<KmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether CloudTrail log file validation is enabled.</p>
   */
  inline bool GetLogFileValidationEnabled() const { return m_logFileValidationEnabled; }
  inline bool LogFileValidationEnabledHasBeenSet() const { return m_logFileValidationEnabledHasBeenSet; }
  inline void SetLogFileValidationEnabled(bool value) {
    m_logFileValidationEnabledHasBeenSet = true;
    m_logFileValidationEnabled = value;
  }
  inline AwsCloudTrailTrailDetails& WithLogFileValidationEnabled(bool value) {
    SetLogFileValidationEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the trail.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AwsCloudTrailTrailDetails& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the S3 bucket where the log files are published.</p>
   */
  inline const Aws::String& GetS3BucketName() const { return m_s3BucketName; }
  inline bool S3BucketNameHasBeenSet() const { return m_s3BucketNameHasBeenSet; }
  template <typename S3BucketNameT = Aws::String>
  void SetS3BucketName(S3BucketNameT&& value) {
    m_s3BucketNameHasBeenSet = true;
    m_s3BucketName = std::forward<S3BucketNameT>(value);
  }
  template <typename S3BucketNameT = Aws::String>
  AwsCloudTrailTrailDetails& WithS3BucketName(S3BucketNameT&& value) {
    SetS3BucketName(std::forward<S3BucketNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The S3 key prefix. The key prefix is added after the name of the S3 bucket
   * where the log files are published.</p>
   */
  inline const Aws::String& GetS3KeyPrefix() const { return m_s3KeyPrefix; }
  inline bool S3KeyPrefixHasBeenSet() const { return m_s3KeyPrefixHasBeenSet; }
  template <typename S3KeyPrefixT = Aws::String>
  void SetS3KeyPrefix(S3KeyPrefixT&& value) {
    m_s3KeyPrefixHasBeenSet = true;
    m_s3KeyPrefix = std::forward<S3KeyPrefixT>(value);
  }
  template <typename S3KeyPrefixT = Aws::String>
  AwsCloudTrailTrailDetails& WithS3KeyPrefix(S3KeyPrefixT&& value) {
    SetS3KeyPrefix(std::forward<S3KeyPrefixT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the SNS topic that is used for notifications of log file
   * delivery.</p>
   */
  inline const Aws::String& GetSnsTopicArn() const { return m_snsTopicArn; }
  inline bool SnsTopicArnHasBeenSet() const { return m_snsTopicArnHasBeenSet; }
  template <typename SnsTopicArnT = Aws::String>
  void SetSnsTopicArn(SnsTopicArnT&& value) {
    m_snsTopicArnHasBeenSet = true;
    m_snsTopicArn = std::forward<SnsTopicArnT>(value);
  }
  template <typename SnsTopicArnT = Aws::String>
  AwsCloudTrailTrailDetails& WithSnsTopicArn(SnsTopicArnT&& value) {
    SetSnsTopicArn(std::forward<SnsTopicArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the SNS topic that is used for notifications of log file
   * delivery.</p>
   */
  inline const Aws::String& GetSnsTopicName() const { return m_snsTopicName; }
  inline bool SnsTopicNameHasBeenSet() const { return m_snsTopicNameHasBeenSet; }
  template <typename SnsTopicNameT = Aws::String>
  void SetSnsTopicName(SnsTopicNameT&& value) {
    m_snsTopicNameHasBeenSet = true;
    m_snsTopicName = std::forward<SnsTopicNameT>(value);
  }
  template <typename SnsTopicNameT = Aws::String>
  AwsCloudTrailTrailDetails& WithSnsTopicName(SnsTopicNameT&& value) {
    SetSnsTopicName(std::forward<SnsTopicNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the trail.</p>
   */
  inline const Aws::String& GetTrailArn() const { return m_trailArn; }
  inline bool TrailArnHasBeenSet() const { return m_trailArnHasBeenSet; }
  template <typename TrailArnT = Aws::String>
  void SetTrailArn(TrailArnT&& value) {
    m_trailArnHasBeenSet = true;
    m_trailArn = std::forward<TrailArnT>(value);
  }
  template <typename TrailArnT = Aws::String>
  AwsCloudTrailTrailDetails& WithTrailArn(TrailArnT&& value) {
    SetTrailArn(std::forward<TrailArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_cloudWatchLogsLogGroupArn;
  bool m_cloudWatchLogsLogGroupArnHasBeenSet = false;

  Aws::String m_cloudWatchLogsRoleArn;
  bool m_cloudWatchLogsRoleArnHasBeenSet = false;

  bool m_hasCustomEventSelectors{false};
  bool m_hasCustomEventSelectorsHasBeenSet = false;

  Aws::String m_homeRegion;
  bool m_homeRegionHasBeenSet = false;

  bool m_includeGlobalServiceEvents{false};
  bool m_includeGlobalServiceEventsHasBeenSet = false;

  bool m_isMultiRegionTrail{false};
  bool m_isMultiRegionTrailHasBeenSet = false;

  bool m_isOrganizationTrail{false};
  bool m_isOrganizationTrailHasBeenSet = false;

  Aws::String m_kmsKeyId;
  bool m_kmsKeyIdHasBeenSet = false;

  bool m_logFileValidationEnabled{false};
  bool m_logFileValidationEnabledHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_s3BucketName;
  bool m_s3BucketNameHasBeenSet = false;

  Aws::String m_s3KeyPrefix;
  bool m_s3KeyPrefixHasBeenSet = false;

  Aws::String m_snsTopicArn;
  bool m_snsTopicArnHasBeenSet = false;

  Aws::String m_snsTopicName;
  bool m_snsTopicNameHasBeenSet = false;

  Aws::String m_trailArn;
  bool m_trailArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
