/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.internal.ui.rulers.RulerDragTracker;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class RulerEditPart
extends AbstractGraphicalEditPart {
    protected GraphicalViewer diagramViewer;
    private AccessibleEditPart accPart;
    private RulerProvider rulerProvider;
    private boolean horizontal;
    private final RulerChangeListener listener = new RulerChangeListener.Stub(){

        @Override
        public void notifyGuideReparented(Object guide) {
            RulerEditPart.this.handleGuideReparented(guide);
        }

        @Override
        public void notifyUnitsChanged(int newUnit) {
            RulerEditPart.this.handleUnitsChanged(newUnit);
        }
    };

    public RulerEditPart(Object model) {
        this.setModel(model);
    }

    @Override
    public void activate() {
        this.getRulerProvider().addRulerChangeListener(this.listener);
        this.getRulerFigure().setZoomManager(this.getZoomManager());
        super.activate();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", new RulerSelectionPolicy());
    }

    @Override
    protected IFigure createFigure() {
        RulerFigure ruler = new RulerFigure(this.isHorizontal(), this.getRulerProvider());
        if (ruler.getUnit() == 2) {
            ruler.setInterval(100, 2);
        }
        return ruler;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        this.rulerProvider = null;
        this.getRulerFigure().setZoomManager(null);
    }

    @Override
    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                @Override
                public void getName(AccessibleEvent e) {
                    e.result = RulerEditPart.this.isHorizontal() ? GEFMessages.Ruler_Horizontal_Label : GEFMessages.Ruler_Vertical_Label;
                }

                @Override
                public void getDescription(AccessibleEvent e) {
                    e.result = GEFMessages.Ruler_Desc;
                }
            };
        }
        return this.accPart;
    }

    public List<? extends GuideEditPart> getChildren() {
        return super.getChildren();
    }

    protected GraphicalViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        if (request.getType().equals("selection") && ((SelectionRequest)request).getLastButtonPressed() != 1) {
            return null;
        }
        return new RulerDragTracker(this);
    }

    public IFigure getGuideLayer() {
        LayerManager lm = LayerManager.Helper.find(this.diagramViewer);
        if (lm != null) {
            return lm.getLayer("Guide Layer");
        }
        return null;
    }

    @Override
    protected List<? extends Object> getModelChildren() {
        return this.getRulerProvider().getGuides();
    }

    protected RulerFigure getRulerFigure() {
        return (RulerFigure)this.getFigure();
    }

    public RulerProvider getRulerProvider() {
        return this.rulerProvider;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("move")) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)((Object)this.diagramViewer.getProperty(ZoomManager.class.toString()));
    }

    public void handleGuideReparented(Object guide) {
        this.refreshChildren();
        EditPart guidePart = this.getViewer().getEditPartForModel(guide);
        if (guidePart != null) {
            this.getViewer().select(guidePart);
        }
    }

    public void handleUnitsChanged(int newUnit) {
        this.getRulerFigure().setUnit(newUnit);
        if (newUnit == 2) {
            this.getRulerFigure().setInterval(100, 2);
        } else {
            this.getRulerFigure().setInterval(0, 0);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    @Override
    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (this.getParent() != null && this.diagramViewer == null) {
            this.diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
            RulerProvider hProvider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
            if (hProvider != null && hProvider.getRuler() == this.getModel()) {
                this.rulerProvider = hProvider;
                this.horizontal = true;
            } else {
                this.rulerProvider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
            }
        }
    }

    public static class RulerSelectionPolicy
    extends SelectionEditPolicy {
        @Override
        protected void hideFocus() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        @Override
        protected void hideSelection() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        @Override
        protected void showFocus() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(true);
        }

        @Override
        protected void showSelection() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

