/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.EnumContainer;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.MessageContainer;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.SchemaWriter;
import org.infinispan.protostream.schema.Syntax;

public class Schema {
    private final Syntax syntax;
    private final String name;
    private final String packageName;
    private final List<Enum> enums;
    private final List<Message> messages;
    private final Map<String, Object> options;
    private final List<String> comments;
    private final List<String> dependencies;
    private final List<String> publicDependencies;

    private Schema(Builder builder) {
        this.syntax = builder.syntax;
        this.dependencies = List.copyOf(builder.dependencies);
        this.publicDependencies = List.copyOf(builder.publicDependencies);
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.options = Map.copyOf(builder.options);
        this.enums = builder.enums.values().stream().map(Enum.Builder::create).toList();
        this.messages = builder.messages.values().stream().map(Message.Builder::create).toList();
        this.comments = List.copyOf(builder.comments);
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<Enum> getEnums() {
        return this.enums;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getPublicDependencies() {
        return this.publicDependencies;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String toString() {
        try {
            StringWriter w = new StringWriter();
            new SchemaWriter().write(w, this);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements CommentContainer<Builder>,
    MessageContainer,
    OptionContainer<Builder>,
    EnumContainer {
        private Syntax syntax = Syntax.PROTO3;
        private final String name;
        private String packageName;
        private final Map<String, Enum.Builder> enums = new HashMap<String, Enum.Builder>();
        private final Map<String, Message.Builder> messages = new HashMap<String, Message.Builder>();
        private final Map<String, Object> options = new HashMap<String, Object>();
        private final List<String> comments = new ArrayList<String>();
        private final List<String> dependencies = new ArrayList<String>();
        private final List<String> publicDependencies = new ArrayList<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public Builder addImport(String i) {
            this.dependencies.add(i);
            return this;
        }

        public Builder addPublicImport(String i) {
            this.publicDependencies.add(i);
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        @Override
        public Builder addOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        @Override
        public Enum.Builder addEnum(String name) {
            this.checkDuplicate(name);
            Enum.Builder e = new Enum.Builder(this, name);
            this.enums.put(name, e);
            return e;
        }

        @Override
        public Message.Builder addMessage(String name) {
            this.checkDuplicate(name);
            Message.Builder message = new Message.Builder(this, name);
            this.messages.put(name, message);
            return message;
        }

        @Override
        public Builder addComment(String comment) {
            this.comments.add(comment.trim());
            return this;
        }

        @Override
        public Schema build() {
            return new Schema(this);
        }

        @Override
        public String getFullName() {
            return Objects.requireNonNullElse(this.packageName, "");
        }

        private void checkDuplicate(String name) {
            if (this.messages.containsKey(name) || this.enums.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate name " + name);
            }
        }
    }
}

