/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import java.io.Serializable;
import java.util.Comparator;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public class CaseInsensitiveMap<V>
extends MultivaluedTreeMap<String, V> {
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public CaseInsensitiveMap() {
        super(CASE_INSENSITIVE_ORDER);
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            int n1 = 0;
            if (s1 != null) {
                n1 = s1.length();
            }
            int n2 = 0;
            if (s2 != null) {
                n2 = s2.length();
            }
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

