/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseReadingFormFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class KuromojiReadingFormFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean useRomaji;

    public KuromojiReadingFormFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.useRomaji = settings.getAsBoolean("use_romaji", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseReadingFormFilter(tokenStream, this.useRomaji);
    }
}

