/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.text.Text;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;

public class HighlightResultApplier {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightResultApplier.class);
    private final String preTag;
    private final String postTag;

    public void applyBatchResults(List<SearchHit> validHits, List<List<Map<String, Object>>> batchResults, String fieldName, String preTag, String postTag) {
        if (batchResults.size() != validHits.size()) {
            log.error("Batch results size ({}) doesn't match valid hits size ({})", (Object)batchResults.size(), (Object)validHits.size());
            throw new IllegalStateException("Batch results size mismatch");
        }
        for (int i = 0; i < validHits.size(); ++i) {
            List<Map<String, Object>> highlights = batchResults.get(i);
            if (highlights == null) {
                highlights = new ArrayList<Map<String, Object>>();
            }
            this.applyHighlightsToHit(validHits.get(i), highlights, fieldName, preTag, postTag);
        }
    }

    public void applyBatchResults(List<SearchHit> validHits, List<List<Map<String, Object>>> batchResults, String fieldName) {
        this.applyBatchResults(validHits, batchResults, fieldName, this.preTag, this.postTag);
    }

    public void applyBatchResultsWithIndices(List<SearchHit> allValidHits, List<List<Map<String, Object>>> batchResults, int startIndex, int endIndex, String fieldName, String preTag, String postTag) {
        int expectedBatchSize = endIndex - startIndex;
        if (batchResults.size() != expectedBatchSize) {
            log.error("Batch results size ({}) doesn't match expected batch size ({}) for indices [{}, {})", (Object)batchResults.size(), (Object)expectedBatchSize, (Object)startIndex, (Object)endIndex);
            throw new IllegalStateException("Batch results size mismatch");
        }
        int batchIndex = 0;
        for (int i = startIndex; i < endIndex && batchIndex < batchResults.size(); ++i, ++batchIndex) {
            List<Map<String, Object>> highlights = batchResults.get(batchIndex);
            if (highlights == null) {
                highlights = new ArrayList<Map<String, Object>>();
            }
            this.applyHighlightsToHit(allValidHits.get(i), highlights, fieldName, preTag, postTag);
        }
    }

    public void applySingleResult(SearchHit hit, List<Map<String, Object>> highlightResults, String fieldName) {
        this.applySingleResult(hit, highlightResults, fieldName, this.preTag, this.postTag);
    }

    public void applySingleResult(SearchHit hit, List<Map<String, Object>> highlightResults, String fieldName, String preTag, String postTag) {
        if (highlightResults == null || highlightResults.isEmpty()) {
            this.applyHighlightsToHit(hit, new ArrayList<Map<String, Object>>(), fieldName, preTag, postTag);
            return;
        }
        Map<String, Object> mlResponse = highlightResults.get(0);
        if (mlResponse == null || !mlResponse.containsKey("highlights")) {
            this.applyHighlightsToHit(hit, new ArrayList<Map<String, Object>>(), fieldName, preTag, postTag);
            return;
        }
        Object highlightsObj = mlResponse.get("highlights");
        if (!(highlightsObj instanceof List)) {
            log.error("Invalid highlights type for hit: {}", (Object)hit.getId());
            throw new IllegalStateException("Expected highlights to be a List");
        }
        List highlights = (List)highlightsObj;
        this.applyHighlightsToHit(hit, highlights, fieldName, preTag, postTag);
    }

    private void applyHighlightsToHit(SearchHit hit, List<Map<String, Object>> highlights, String fieldName, String preTag, String postTag) {
        Map source = hit.getSourceAsMap();
        if (source == null) {
            return;
        }
        String text = (String)source.get(fieldName);
        if (text == null || text.isEmpty()) {
            return;
        }
        String highlightedText = this.applyPositionHighlights(text, highlights, preTag, postTag);
        HashMap<String, HighlightField> highlightFields = hit.getHighlightFields();
        if (highlightFields == null) {
            highlightFields = new HashMap<String, HighlightField>();
        } else if (!(highlightFields instanceof HashMap)) {
            highlightFields = new HashMap(highlightFields);
        }
        HighlightField highlightField = new HighlightField(fieldName, new Text[]{new Text(highlightedText)});
        highlightFields.put(fieldName, highlightField);
        hit.highlightFields(highlightFields);
    }

    private String applyPositionHighlights(String text, List<Map<String, Object>> highlights, String preTag, String postTag) {
        ArrayList<Map<String, Object>> validHighlights = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> highlight : highlights) {
            Object object = highlight.get("start");
            Object endObj = highlight.get("end");
            if (!ProcessorUtils.isNumeric(object) || !ProcessorUtils.isNumeric(endObj)) continue;
            validHighlights.add(highlight);
        }
        if (validHighlights.isEmpty()) {
            return text;
        }
        validHighlights.sort((a, b) -> {
            int startA = ((Number)a.get("start")).intValue();
            int startB = ((Number)b.get("start")).intValue();
            return Integer.compare(startB, startA);
        });
        StringBuilder result = new StringBuilder(text);
        for (Map map : validHighlights) {
            int start = ((Number)map.get("start")).intValue();
            int end = ((Number)map.get("end")).intValue();
            if (start < 0 || end > text.length() || start >= end) continue;
            result.insert(end, postTag);
            result.insert(start, preTag);
        }
        return result.toString();
    }

    @Generated
    public HighlightResultApplier(String preTag, String postTag) {
        this.preTag = preTag;
        this.postTag = postTag;
    }
}

