/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.Channel;
import org.opensearch.client.opensearch.ism.ErrorNotificationDestination;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ErrorNotification
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ErrorNotification> {
    @Nullable
    private final Channel channel;
    @Nullable
    private final ErrorNotificationDestination destination;
    @Nonnull
    private final Map<String, JsonData> messageTemplate;
    public static final JsonpDeserializer<ErrorNotification> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorNotification::setupErrorNotificationDeserializer);

    private ErrorNotification(Builder builder) {
        this.channel = builder.channel;
        this.destination = builder.destination;
        this.messageTemplate = ApiTypeHelper.unmodifiable(builder.messageTemplate);
    }

    public static ErrorNotification of(Function<Builder, ObjectBuilder<ErrorNotification>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Channel channel() {
        return this.channel;
    }

    @Nullable
    public final ErrorNotificationDestination destination() {
        return this.destination;
    }

    @Nonnull
    public final Map<String, JsonData> messageTemplate() {
        return this.messageTemplate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.channel != null) {
            generator.writeKey("channel");
            this.channel.serialize(generator, mapper);
        }
        if (this.destination != null) {
            generator.writeKey("destination");
            this.destination.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.messageTemplate)) {
            generator.writeKey("message_template");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.messageTemplate.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupErrorNotificationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::channel, Channel._DESERIALIZER, "channel");
        op.add(Builder::destination, ErrorNotificationDestination._DESERIALIZER, "destination");
        op.add(Builder::messageTemplate, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "message_template");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.channel);
        result = 31 * result + Objects.hashCode(this.destination);
        result = 31 * result + Objects.hashCode(this.messageTemplate);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorNotification other = (ErrorNotification)o;
        return Objects.equals(this.channel, other.channel) && Objects.equals(this.destination, other.destination) && Objects.equals(this.messageTemplate, other.messageTemplate);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ErrorNotification> {
        @Nullable
        private Channel channel;
        @Nullable
        private ErrorNotificationDestination destination;
        @Nullable
        private Map<String, JsonData> messageTemplate;

        public Builder() {
        }

        private Builder(ErrorNotification o) {
            this.channel = o.channel;
            this.destination = o.destination;
            this.messageTemplate = Builder._mapCopy(o.messageTemplate);
        }

        private Builder(Builder o) {
            this.channel = o.channel;
            this.destination = o.destination;
            this.messageTemplate = Builder._mapCopy(o.messageTemplate);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder channel(@Nullable Channel value) {
            this.channel = value;
            return this;
        }

        @Nonnull
        public final Builder channel(Function<Channel.Builder, ObjectBuilder<Channel>> fn) {
            return this.channel(fn.apply(new Channel.Builder()).build());
        }

        @Nonnull
        public final Builder destination(@Nullable ErrorNotificationDestination value) {
            this.destination = value;
            return this;
        }

        @Nonnull
        public final Builder destination(Function<ErrorNotificationDestination.Builder, ObjectBuilder<ErrorNotificationDestination>> fn) {
            return this.destination(fn.apply(new ErrorNotificationDestination.Builder()).build());
        }

        @Nonnull
        public final Builder messageTemplate(Map<String, JsonData> map) {
            this.messageTemplate = Builder._mapPutAll(this.messageTemplate, map);
            return this;
        }

        @Nonnull
        public final Builder messageTemplate(String key, JsonData value) {
            this.messageTemplate = Builder._mapPut(this.messageTemplate, key, value);
            return this;
        }

        @Override
        @Nonnull
        public ErrorNotification build() {
            this._checkSingleUse();
            return new ErrorNotification(this);
        }
    }
}

