﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/managedblockchain-query/ManagedBlockchainQuery_EXPORTS.h>

namespace Aws {
namespace ManagedBlockchainQuery {
namespace Model {
enum class ListTransactionsSortBy { NOT_SET, TRANSACTION_TIMESTAMP };

namespace ListTransactionsSortByMapper {
AWS_MANAGEDBLOCKCHAINQUERY_API ListTransactionsSortBy GetListTransactionsSortByForName(const Aws::String& name);

AWS_MANAGEDBLOCKCHAINQUERY_API Aws::String GetNameForListTransactionsSortBy(ListTransactionsSortBy value);
}  // namespace ListTransactionsSortByMapper
}  // namespace Model
}  // namespace ManagedBlockchainQuery
}  // namespace Aws
