﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/Personalize_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Personalize {
namespace Model {
class CreateFilterResult {
 public:
  AWS_PERSONALIZE_API CreateFilterResult() = default;
  AWS_PERSONALIZE_API CreateFilterResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PERSONALIZE_API CreateFilterResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the new filter.</p>
   */
  inline const Aws::String& GetFilterArn() const { return m_filterArn; }
  template <typename FilterArnT = Aws::String>
  void SetFilterArn(FilterArnT&& value) {
    m_filterArnHasBeenSet = true;
    m_filterArn = std::forward<FilterArnT>(value);
  }
  template <typename FilterArnT = Aws::String>
  CreateFilterResult& WithFilterArn(FilterArnT&& value) {
    SetFilterArn(std::forward<FilterArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateFilterResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_filterArn;

  Aws::String m_requestId;
  bool m_filterArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
