/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCharset;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCollation;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPartition;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableColumn;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableIndex;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTrigger;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridTable
extends GenericTable {
    private final PartitionCache partitionCache = new PartitionCache();
    private CubridUser owner;
    private CubridCharset charset;
    private CubridCollation collation;
    private Integer autoIncrement;
    private boolean reuseOID = true;
    private boolean partitioned = false;

    public CubridTable(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName != null ? tableName.toLowerCase() : null, tableType, dbResult);
        String collationName;
        if (tableType.equals("TABLE") && dbResult != null) {
            String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_system_class");
            this.reuseOID = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_reuse_oid_class").equals("YES");
            collationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collation");
            this.autoIncrement = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"current_val");
            this.partitioned = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partitioned").equals("YES");
            if (type != null) {
                this.setSystem(type.equals("YES"));
            }
        } else {
            collationName = "utf8_bin";
        }
        String charsetName = collationName.split("_")[0];
        this.owner = (CubridUser)container;
        this.charset = this.getDataSource().getCharset(charsetName);
        this.collation = this.getDataSource().getCollation(collationName);
    }

    public void setName(@NotNull String name) {
        super.setName(name != null ? name.toLowerCase() : null);
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return (CubridDataSource)super.getDataSource();
    }

    @NotNull
    public CubridUser getParent() {
        return (CubridUser)super.getContainer();
    }

    public boolean supportsTrigger() {
        return this.getParent().supportsTrigger();
    }

    @Nullable
    public List<CubridTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getParent().getCubridIndexCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    @Nullable
    public List<CubridTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    @NotNull
    public List<CubridPartition> getPartitions(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.partitionCache.getAllObjects(monitor, (DBSObject)this);
    }

    public List<CubridTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getTriggers(monitor);
    }

    public boolean isEnableSchema() {
        return this.getDataSource().getSupportMultiSchema() || this.getDataSource().isDBAGroup();
    }

    @Property(viewable=true, editableExpr="object.enableSchema", updatableExpr="object.enableSchema", listProvider=OwnerListProvider.class, labelProvider=GenericSchema.SchemaNameTermProvider.class, order=2)
    @Nullable
    public GenericSchema getSchema() {
        return this.owner;
    }

    public void setSchema(@NotNull CubridUser owner) {
        this.owner = owner;
    }

    @NotNull
    public String getUniqueName() {
        if (this.getDataSource().getSupportMultiSchema()) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return this.getName();
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=CollationListProvider.class, order=9)
    @NotNull
    public CubridCollation getCollation() {
        return this.collation;
    }

    public void setCollation(@NotNull CubridCollation collation) {
        this.collation = collation;
    }

    @Property(viewable=false, editable=true, updatable=true, listProvider=CharsetListProvider.class, order=8)
    @NotNull
    public CubridCharset getCharset() {
        return this.charset;
    }

    public void setCharset(@NotNull CubridCharset charset) {
        this.charset = charset;
        this.collation = charset == null ? null : charset.getDefaultCollation();
    }

    @Property(viewable=true, editable=true, order=52)
    public boolean isReuseOID() {
        return this.reuseOID;
    }

    public void setReuseOID(boolean reuseOID) {
        this.reuseOID = reuseOID;
    }

    @Property(viewable=true, order=53)
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Property(viewable=true, editable=true, updatable=true, order=10)
    @Nullable
    public Integer getAutoIncrement() {
        return this.autoIncrement == null ? 0 : this.autoIncrement;
    }

    public void setAutoIncrement(@NotNull Integer autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if (this.isSystem() || !this.getDataSource().getSupportMultiSchema()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
        }
        return DBUtils.getQuotedIdentifier((DBSObject)this.getSchema()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }

    @NotNull
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getParent().getCubridIndexCache().clearObjectCache((DBSObject)this);
        return super.refreshObject(monitor);
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<CubridTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(@NotNull CubridTable object) {
            return object.getDataSource().getCharsets().toArray();
        }
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<CubridTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(@NotNull CubridTable object) {
            return object.charset.getCollations().toArray();
        }
    }

    public static class OwnerListProvider
    implements IPropertyValueListProvider<CubridTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(@NotNull CubridTable object) {
            return object.getDataSource().getSchemas().toArray();
        }
    }

    static class PartitionCache
    extends JDBCObjectCache<CubridTable, CubridPartition> {
        PartitionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull CubridTable table) throws SQLException {
            StringBuilder sql = new StringBuilder("select * from db_partition where class_name = ?");
            if (table.getDataSource().getSupportMultiSchema()) {
                sql.append(" and owner_name = ?");
            }
            sql = table.getDataSource().wrapShardQuery(sql);
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, table.getName());
            if (table.getDataSource().getSupportMultiSchema()) {
                dbStat.setString(2, table.getSchema().getName());
            }
            return dbStat;
        }

        protected CubridPartition fetchObject(@NotNull JDBCSession session, @NotNull CubridTable table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String partition_class_name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_class_name");
            String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_type");
            return new CubridPartition(table, partition_class_name, type, dbResult);
        }
    }
}

