/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.resizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.JResizer;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

class OneTouchCollapseResizer
extends JResizer {
    private static final long serialVersionUID = 1L;
    private boolean expanded = false;
    private final int INSET = 2;
    private final String sizePropertyName;
    private final ComponentAdapter sizeChangeListener;

    OneTouchCollapseResizer(JResizer.Direction d, Component resizedComponent, String propertyNameBase) {
        super(d, resizedComponent);
        this.sizePropertyName = propertyNameBase + ".size";
        this.setDividerSize((int)((double)(UITools.FONT_SCALE_FACTOR * 5.0f) + 0.5));
        this.sizeChangeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OneTouchCollapseResizer.this.setHotspotBounds();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int preferredSize;
                Component resizedComponent = OneTouchCollapseResizer.this.getResizedComponent();
                if (resizedComponent.isPreferredSizeSet() && (preferredSize = OneTouchCollapseResizer.this.direction.getPreferredSize(resizedComponent)) >= OneTouchCollapseResizer.this.minimumCollapseSize()) {
                    ResourceController.getResourceController().setProperty(OneTouchCollapseResizer.this.sizePropertyName, preferredSize);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OneTouchCollapseResizer.this.expanded) {
                    OneTouchCollapseResizer.this.setExpanded(false);
                } else {
                    OneTouchCollapseResizer.this.setExpanded(true);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (OneTouchCollapseResizer.this.sliderLock || !OneTouchCollapseResizer.this.expanded) {
                    OneTouchCollapseResizer.this.setExpanded(true);
                }
            }
        });
        UIComponentVisibilityDispatcher dispatcher = UIComponentVisibilityDispatcher.install(this.parentBox, propertyNameBase);
        dispatcher.setResizer(this);
        this.expanded = !dispatcher.isVisible();
        this.setExpanded(!this.expanded);
        this.parentBox.addComponentListener(this.sizeChangeListener);
    }

    Box getParentBox() {
        return this.parentBox;
    }

    private void setDividerSize(int size) {
        int h;
        int w;
        if (this.direction == JResizer.Direction.RIGHT) {
            w = size;
            h = size * 2;
        } else if (this.direction == JResizer.Direction.LEFT) {
            h = size * 2;
            w = size;
        } else if (this.direction == JResizer.Direction.UP) {
            h = size;
            w = size * 2;
        } else {
            h = size;
            w = size * 2;
        }
        this.setPreferredSize(new Dimension(w, h));
    }

    private int getDividerSize() {
        if (this.direction == JResizer.Direction.RIGHT || this.direction == JResizer.Direction.LEFT) {
            return this.getPreferredSize().width;
        }
        return this.getPreferredSize().height;
    }

    void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            try {
                Component resizedComponent = this.getResizedComponent();
                if (expanded) {
                    if (!this.sliderLock) {
                        int size = ResourceController.getResourceController().getIntProperty(this.sizePropertyName, 0);
                        if (size >= this.minimumCollapseSize()) {
                            this.direction.setPreferredSize(resizedComponent, size);
                        } else {
                            resizedComponent.setPreferredSize(null);
                        }
                    }
                } else {
                    resizedComponent.setPreferredSize(new Dimension(0, 0));
                    IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
                    mapViewManager.moveFocusFromDescendantToSelection(resizedComponent);
                }
                resizedComponent.setVisible(expanded);
                UIComponentVisibilityDispatcher.of(this.parentBox).setProperty(expanded);
                this.parentBox.revalidate();
                this.parentBox.repaint();
            }
            catch (Exception e) {
                LogUtils.warn("Exception in org.freeplane.core.ui.components.OneTouchCollapseResizer.setExpanded(enabled): " + e);
            }
        }
    }

    private int minimumCollapseSize() {
        return 3 * this.getDividerSize();
    }

    private Component getResizedComponent() {
        return this.resizedComponent;
    }

    @Override
    public void paintComponent(Graphics g) {
        int hotspotHeight;
        int hotspotWidth;
        int hotspotY;
        int hotspotX;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int dividerSize = this.getDividerSize();
        if (this.direction == JResizer.Direction.RIGHT || this.direction == JResizer.Direction.LEFT) {
            int centerY = this.getHeight() / 2;
            hotspotX = 0;
            hotspotY = centerY - dividerSize;
            hotspotWidth = dividerSize;
            hotspotHeight = 4 * dividerSize;
        } else {
            int centerX = this.getWidth() / 2;
            hotspotX = centerX - dividerSize;
            hotspotY = 0;
            hotspotWidth = 4 * dividerSize;
            hotspotHeight = dividerSize;
        }
        Graphics arrowGraphics = g.create(hotspotX, hotspotY, hotspotWidth, hotspotHeight);
        arrowGraphics.setColor(this.getForeground());
        this.drawControlArrow(arrowGraphics);
        arrowGraphics.dispose();
    }

    private void drawControlArrow(Graphics g) {
        Dimension size = g.getClipBounds().getSize();
        int half_length = (size.height - 12) / 2;
        int center_y = size.height / 2;
        int half_width = (size.width - 12) / 2;
        int center_x = size.width / 2;
        if (this.expanded && this.direction == JResizer.Direction.RIGHT || !this.expanded && this.direction == JResizer.Direction.LEFT) {
            this.arrowRight(g, half_length, center_y);
        } else if (this.expanded && this.direction == JResizer.Direction.LEFT || !this.expanded && this.direction == JResizer.Direction.RIGHT) {
            this.arrowLeft(g, half_length, center_y);
        } else if (this.expanded && this.direction == JResizer.Direction.DOWN || !this.expanded && this.direction == JResizer.Direction.UP) {
            this.arrowDown(g, half_width, center_x);
        } else if (this.expanded && this.direction == JResizer.Direction.UP || !this.expanded && this.direction == JResizer.Direction.DOWN) {
            this.arrowUp(g, half_width, center_x);
        }
    }

    private void arrowLeft(Graphics g, int half_length, int center_y) {
        int[] x = new int[]{2, this.getSize().width - 2, this.getSize().width - 2};
        int[] y = new int[]{center_y, center_y - half_length, center_y + half_length};
        g.fillPolygon(x, y, 3);
        g.drawLine(2, center_y, this.getSize().width - 2, center_y - half_length);
        g.drawLine(this.getSize().width - 2, center_y + half_length, 2, center_y);
        g.drawLine(this.getSize().width - 2, center_y - half_length, this.getSize().width - 2, center_y + half_length);
    }

    private void arrowRight(Graphics g, int half_length, int center_y) {
        int[] x = new int[]{2, 2, this.getSize().width - 2};
        int[] y = new int[]{center_y + half_length, center_y - half_length, center_y};
        g.fillPolygon(x, y, 3);
        g.drawLine(2, center_y + half_length, 2, center_y - half_length);
        g.drawLine(2, center_y - half_length, this.getSize().width - 2, center_y);
        g.drawLine(this.getSize().width - 2, center_y, 2, center_y + half_length);
    }

    private void arrowUp(Graphics g, int half_length, int center_x) {
        int[] y = new int[]{2, this.getSize().height - 2, this.getSize().height - 2};
        int[] x = new int[]{center_x, center_x - half_length, center_x + half_length};
        g.fillPolygon(x, y, 3);
        g.drawLine(center_x + half_length, this.getSize().height - 2, center_x, 2);
        g.drawLine(center_x, 2, center_x - half_length, this.getSize().height - 2);
        g.drawLine(center_x - half_length, this.getSize().height - 2, center_x + half_length, this.getSize().height - 2);
    }

    private void arrowDown(Graphics g, int half_length, int center_x) {
        int[] y = new int[]{2, 2, this.getSize().height - 2};
        int[] x = new int[]{center_x + half_length, center_x - half_length, center_x};
        g.fillPolygon(x, y, 3);
        g.drawLine(center_x - half_length, 2, center_x, this.getSize().height - 2);
        g.drawLine(center_x + half_length, 2, center_x - half_length, 2);
        g.drawLine(center_x, this.getSize().height - 2, center_x + half_length, 2);
    }

    private void setHotspotBounds() {
        if (this.direction.getPreferredSize(this.getResizedComponent()) < this.minimumCollapseSize()) {
            this.setExpanded(false);
        }
    }
}

