/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.ScriptRuntime;

public class Conversions {
    public static int toInt8(Object object) {
        return (byte)ScriptRuntime.toInt32(object);
    }

    public static int toUint8(Object object) {
        return ScriptRuntime.toInt32(object) & 0xFF;
    }

    public static int toUint8Clamp(Object object) {
        double d = ScriptRuntime.toNumber(object);
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 255.0) {
            return 255;
        }
        double d2 = Math.floor(d);
        if (d2 + 0.5 < d) {
            return (int)(d2 + 1.0);
        }
        if (d < d2 + 0.5) {
            return (int)d2;
        }
        if ((int)d2 % 2 != 0) {
            return (int)d2 + 1;
        }
        return (int)d2;
    }

    public static int toInt16(Object object) {
        return (short)ScriptRuntime.toInt32(object);
    }

    public static int toUint16(Object object) {
        return ScriptRuntime.toInt32(object) & 0xFFFF;
    }

    public static int toInt32(Object object) {
        return ScriptRuntime.toInt32(object);
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(object);
    }
}

