/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.fixedfunc.GLPointerFuncUtil;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;

public class GLArrayDataWrapper
implements GLArrayData {
    public static final boolean DEBUG = Debug.debug("GLArrayData");
    protected final int compType;
    protected final Class<?> compClazz;
    protected final int bytesPerComp;
    protected final int compsPerElement;
    protected final int strideB;
    protected final int strideL;
    protected final boolean normalized;
    protected final int mappedElemCount;
    protected final boolean isVertexAttr;
    protected boolean alive;
    protected int index;
    protected int location;
    protected String name;
    protected Buffer buffer;
    protected int vboName;
    protected long vboOffset;
    protected boolean vboEnabled;
    protected int vboUsage;
    protected int vboTarget;
    protected boolean sealed;

    public static GLArrayDataWrapper createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, long l, int n6, int n7) throws GLException {
        return new GLArrayDataWrapper(null, n, n2, n3, bl, n4, buffer, 0, false, n5, l, n6, n7);
    }

    public static GLArrayDataWrapper createFixed(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, long l, int n7, int n8) throws GLException {
        return new GLArrayDataWrapper(null, n, n2, n3, bl, n4, null, n5, false, n6, l, n7, n8);
    }

    public static GLArrayDataWrapper createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer, int n4, long l, int n5, int n6) throws GLException {
        return new GLArrayDataWrapper(string, -1, n, n2, bl, n3, buffer, 0, true, n4, l, n5, n6);
    }

    public static GLArrayDataWrapper createGLSL(String string, int n, int n2, boolean bl, int n3, int n4, int n5, long l, int n6, int n7) throws GLException {
        return new GLArrayDataWrapper(string, -1, n, n2, bl, n3, null, n4, true, n5, l, n6, n7);
    }

    public final boolean validate(GLProfile gLProfile, boolean bl) {
        if (!this.alive) {
            if (bl) {
                throw new GLException("Instance !alive " + this);
            }
            return false;
        }
        if (this.isVertexAttribute() && !gLProfile.hasGLSL()) {
            if (bl) {
                throw new GLException("GLSL not supported on " + gLProfile + ", " + this);
            }
            return false;
        }
        return true;
    }

    @Override
    public void associate(Object object, boolean bl) {
    }

    @Override
    public final boolean isVertexAttribute() {
        return this.isVertexAttr;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getLocation() {
        return this.location;
    }

    @Override
    public final int setLocation(int n) {
        this.location = n;
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n) {
        this.location = gL2ES2.glGetAttribLocation(n, this.name);
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n, int n2) {
        this.location = n2;
        gL2ES2.glBindAttribLocation(n, n2, this.name);
        return n2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getVBOOffset() {
        return this.vboEnabled ? this.vboOffset : 0L;
    }

    @Override
    public final int getVBOName() {
        return this.vboEnabled ? this.vboName : 0;
    }

    @Override
    public final boolean isVBO() {
        return this.vboEnabled;
    }

    @Override
    public final int getVBOUsage() {
        return this.vboEnabled ? this.vboUsage : 0;
    }

    @Override
    public final int getVBOTarget() {
        return this.vboEnabled ? this.vboTarget : 0;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final int getCompsPerElem() {
        return this.compsPerElement;
    }

    @Override
    public final int getCompType() {
        return this.compType;
    }

    @Override
    public final int getBytesPerComp() {
        return this.bytesPerComp;
    }

    @Override
    public final boolean sealed() {
        return this.sealed;
    }

    @Override
    public final int getElemCount() {
        if (0 != this.mappedElemCount) {
            return this.mappedElemCount;
        }
        if (null != this.buffer) {
            if (this.sealed) {
                return this.buffer.limit() * this.bytesPerComp / this.strideB;
            }
            return this.buffer.position() * this.bytesPerComp / this.strideB;
        }
        return 0;
    }

    @Override
    public final int elemPosition() {
        if (0 != this.mappedElemCount) {
            return this.mappedElemCount;
        }
        if (null != this.buffer) {
            return this.buffer.position() * this.bytesPerComp / this.strideB;
        }
        return 0;
    }

    @Override
    public int remainingElems() {
        if (null != this.buffer) {
            return this.buffer.remaining() * this.bytesPerComp / this.strideB;
        }
        return 0;
    }

    @Override
    public int getElemCapacity() {
        if (null != this.buffer) {
            return this.buffer.capacity() * this.bytesPerComp / this.strideB;
        }
        return 0;
    }

    @Override
    public final int getByteCount() {
        if (0 != this.mappedElemCount) {
            return this.mappedElemCount * this.compsPerElement * this.bytesPerComp;
        }
        if (null != this.buffer) {
            if (this.sealed) {
                return this.buffer.limit() * this.bytesPerComp;
            }
            return this.buffer.position() * this.bytesPerComp;
        }
        return 0;
    }

    @Override
    public final int bytePosition() {
        if (0 != this.mappedElemCount) {
            return this.mappedElemCount * this.compsPerElement * this.bytesPerComp;
        }
        if (null != this.buffer) {
            return this.buffer.position() * this.bytesPerComp;
        }
        return 0;
    }

    @Override
    public int remainingBytes() {
        if (null != this.buffer) {
            return this.buffer.remaining() * this.bytesPerComp;
        }
        return 0;
    }

    @Override
    public int getByteCapacity() {
        if (null != this.buffer) {
            return this.buffer.capacity() * this.bytesPerComp;
        }
        return 0;
    }

    @Override
    public String fillStatsToString() {
        int n = this.getByteCount();
        int n2 = this.getByteCapacity();
        float f = (float)n / (float)n2;
        return String.format("elements %,d cnt / %,d cap, bytes %,d cnt / %,d cap, filled %.1f%%, left %.1f%%", this.getElemCount(), this.getElemCapacity(), n, n2, Float.valueOf(f * 100.0f), Float.valueOf((1.0f - f) * 100.0f));
    }

    @Override
    public String elemStatsToString() {
        int n = null != this.buffer ? this.buffer.limit() * this.bytesPerComp / this.strideB : 0;
        return String.format("sealed %b, elements %,d cnt, [%,d pos .. %,d rem .. %,d lim .. %,d cap]", this.sealed(), this.getElemCount(), this.elemPosition(), this.remainingElems(), n, this.getElemCapacity());
    }

    @Override
    public final boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public final int getStride() {
        return this.strideB;
    }

    public final Class<?> getBufferClass() {
        return this.compClazz;
    }

    @Override
    public void destroy(GL gL) {
        this.buffer = null;
        this.vboName = 0;
        this.vboEnabled = false;
        this.vboOffset = 0L;
        this.alive = false;
    }

    @Override
    public String toString() {
        return "GLArrayDataWrapper[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttr + ", dataType 0x" + Integer.toHexString(this.compType) + ", bufferClazz " + this.compClazz + ", compsPerElem " + this.compsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c, mappedElemCount " + this.mappedElemCount + ", " + this.elemStatsToString() + ", buffer " + this.buffer + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", alive " + this.alive + "]";
    }

    public static final Class<?> getBufferClass(int n) {
        switch (n) {
            case 5120: 
            case 5121: {
                return ByteBuffer.class;
            }
            case 5122: 
            case 5123: {
                return ShortBuffer.class;
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return IntBuffer.class;
            }
            case 5126: {
                return FloatBuffer.class;
            }
        }
        throw new GLException("Given OpenGL data type not supported: " + n);
    }

    @Override
    public void setName(String string) {
        this.location = -1;
        this.name = string;
    }

    public void setVBOEnabled(boolean bl) {
        this.vboEnabled = bl;
    }

    public void setVBOName(int n) {
        this.vboName = n;
        this.setVBOEnabled(0 != n);
    }

    public void setVBOUsage(int n) {
        this.vboUsage = n;
    }

    public void setVBOTarget(int n) {
        this.vboTarget = n;
    }

    protected GLArrayDataWrapper(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, boolean bl2, int n6, long l, int n7, int n8) throws GLException {
        if (0 < n5 && null != buffer) {
            throw new IllegalArgumentException("mappedElementCount:=" + n5 + " specified, but passing non null buffer");
        }
        if (34963 != n8) {
            if (0 == n7 && 0 == n8 || 34962 == n8) {
                String string2 = this.name = null == string ? GLPointerFuncUtil.getPredefinedArrayIndexName(n) : string;
                if (null == this.name) {
                    throw new GLException("Not a valid array buffer index: " + n);
                }
            } else if (0 < n8) {
                throw new GLException("Invalid GPUBuffer target: 0x" + Integer.toHexString(n8));
            }
        }
        this.compType = n3;
        this.compClazz = GLArrayDataWrapper.getBufferClass(n3);
        this.bytesPerComp = GLBuffers.sizeOfGLType(n3);
        if (0 > this.bytesPerComp) {
            throw new GLException("Given componentType not supported: " + n3 + ":\n\t" + this);
        }
        if (0 >= n2) {
            throw new GLException("Invalid number of components: " + n2);
        }
        this.compsPerElement = n2;
        if (0 < n4 && n4 < n2 * this.bytesPerComp) {
            throw new GLException("stride (" + n4 + ") lower than component bytes, " + n2 + " * " + this.bytesPerComp);
        }
        if (0 < n4 && n4 % this.bytesPerComp != 0) {
            throw new GLException("stride (" + n4 + ") not a multiple of bpc " + this.bytesPerComp);
        }
        this.strideB = 0 == n4 ? n2 * this.bytesPerComp : n4;
        this.strideL = this.strideB / this.bytesPerComp;
        this.normalized = GLBuffers.isGLTypeFixedPoint(n3) ? bl : false;
        this.mappedElemCount = n5;
        this.isVertexAttr = bl2;
        this.index = n;
        this.location = -1;
        this.buffer = buffer;
        this.vboName = n6;
        this.vboOffset = l;
        this.vboEnabled = 0 != n6;
        switch (n7) {
            case 0: 
            case 35040: 
            case 35044: 
            case 35048: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferUsage: " + n7 + ":\n\t" + this);
            }
        }
        switch (n8) {
            case 0: 
            case 34962: 
            case 34963: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferTarget: " + n8 + ":\n\t" + this);
            }
        }
        this.vboUsage = n7;
        this.vboTarget = n8;
        this.alive = true;
        this.sealed = true;
    }

    public GLArrayDataWrapper(GLArrayDataWrapper gLArrayDataWrapper) {
        this.compType = gLArrayDataWrapper.compType;
        this.compClazz = gLArrayDataWrapper.compClazz;
        this.bytesPerComp = gLArrayDataWrapper.bytesPerComp;
        this.compsPerElement = gLArrayDataWrapper.compsPerElement;
        this.strideB = gLArrayDataWrapper.strideB;
        this.strideL = gLArrayDataWrapper.strideL;
        this.normalized = gLArrayDataWrapper.normalized;
        this.mappedElemCount = gLArrayDataWrapper.mappedElemCount;
        this.isVertexAttr = gLArrayDataWrapper.isVertexAttr;
        this.alive = gLArrayDataWrapper.alive;
        this.index = gLArrayDataWrapper.index;
        this.location = gLArrayDataWrapper.location;
        this.name = gLArrayDataWrapper.name;
        this.buffer = null != gLArrayDataWrapper.buffer ? (gLArrayDataWrapper.buffer.position() == 0 ? Buffers.slice((Buffer)gLArrayDataWrapper.buffer) : Buffers.slice((Buffer)gLArrayDataWrapper.buffer, (int)0, (int)gLArrayDataWrapper.buffer.limit())) : null;
        this.vboName = gLArrayDataWrapper.vboName;
        this.vboOffset = gLArrayDataWrapper.vboOffset;
        this.vboEnabled = gLArrayDataWrapper.vboEnabled;
        this.vboUsage = gLArrayDataWrapper.vboUsage;
        this.vboTarget = gLArrayDataWrapper.vboTarget;
        this.sealed = gLArrayDataWrapper.sealed;
    }
}

