/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u0017\u001a&\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\u0002\b\u001cH\u0082\b\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"dump", "", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "RESERVED_MEMBER_NAME_SUFFIX", "toJsIdentifier", "", "joinTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "findOriginallyContainingModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "calculateJsFunctionSignature", "declaration", "jsFunctionSignature", "sanitizeName", "name", "withHash", "", "nameIfPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "mangleIfNot", "", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "SYNTHETIC_LOOP_LABEL", "SYNTHETIC_BLOCK_LABEL", "backend.js"})
@SourceDebugExtension(value={"SMAP\nNameTables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n+ 2 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n319#1:333\n319#1:334\n28#2:324\n29#2:326\n28#2:327\n29#2:329\n28#2:335\n29#2:337\n1#3:325\n1#3:328\n1#3:336\n195#4:330\n1869#5,2:331\n*S KotlinDebug\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n*L\n276#1:333\n280#1:334\n108#1:324\n108#1:326\n112#1:327\n112#1:329\n299#1:335\n299#1:337\n108#1:325\n112#1:328\n299#1:336\n134#1:330\n136#1:331,2\n*E\n"})
public final class NameTablesKt {
    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return "Names: \n" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, NameTablesKt::dump$lambda$0, (int)30, null);
    }

    @NotNull
    public static final String toJsIdentifier(int $this$toJsIdentifier) {
        String string;
        String first = String.valueOf((char)(97 + $this$toJsIdentifier % 26));
        int other = $this$toJsIdentifier / 26;
        if (other == 0) {
            string = first;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(first);
            String string2 = Integer.toString(other, CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = stringBuilder.append(string2).toString();
        }
        return string;
    }

    private static final String joinTypes(List<? extends IrType> $this$joinTypes, JsIrBackendContext context2) {
        if ($this$joinTypes.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)$this$joinTypes, (CharSequence)"$", (CharSequence)"$", null, (int)0, null, arg_0 -> NameTablesKt.joinTypes$lambda$0(context2, arg_0), (int)28, null);
    }

    private static final IrModuleFragment findOriginallyContainingModule(IrFunction $this$findOriginallyContainingModule) {
        if (JsLoweredDeclarationOrigin.INSTANCE.isBridgeDeclarationOrigin($this$findOriginallyContainingModule.getOrigin())) {
            IrSimpleFunction irSimpleFunction = $this$findOriginallyContainingModule instanceof IrSimpleFunction ? (IrSimpleFunction)$this$findOriginallyContainingModule : null;
            if (irSimpleFunction == null) {
                IrExceptionBuilder irExceptionBuilder;
                String message$iv = "Bridge must be IrSimpleFunction";
                boolean $i$f$irError = false;
                IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                boolean bl = false;
                IrExceptionBuilder $this$findOriginallyContainingModule_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                boolean bl2 = false;
                $this$findOriginallyContainingModule_u24lambda_u240.withIrEntry("this", $this$findOriginallyContainingModule);
                IrExceptionBuilder builder$iv = irExceptionBuilder;
                throw new IllegalStateException(builder$iv.buildString().toString());
            }
            IrSimpleFunction thisSimpleFunction = irSimpleFunction;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)CollectionsKt.firstOrNull(thisSimpleFunction.getOverriddenSymbols());
            if (irSimpleFunctionSymbol == null) {
                IrExceptionBuilder irExceptionBuilder;
                String message$iv = "Couldn't find the overridden function for the bridge";
                boolean $i$f$irError = false;
                IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                boolean bl = false;
                IrExceptionBuilder $this$findOriginallyContainingModule_u24lambda_u241 = $this$irError_u24lambda_u240$iv;
                boolean bl3 = false;
                $this$findOriginallyContainingModule_u24lambda_u241.withIrEntry("thisSimpleFunction", thisSimpleFunction);
                IrExceptionBuilder builder$iv = irExceptionBuilder;
                throw new IllegalStateException(builder$iv.buildString().toString());
            }
            IrSimpleFunctionSymbol bridgeFrom = irSimpleFunctionSymbol;
            return NameTablesKt.findOriginallyContainingModule(bridgeFrom.getOwner());
        }
        IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment($this$findOriginallyContainingModule);
        IrFile irFile = irPackageFragment instanceof IrFile ? (IrFile)irPackageFragment : null;
        return irFile != null ? irFile.getModule() : null;
    }

    @NotNull
    public static final String calculateJsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context2) {
        IrModuleFragment containingModule;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string = NameTablesKt.nameIfPropertyAccessor(declaration);
        if (string == null) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        String declarationName = string;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        if (declaration.getVisibility() == DescriptorVisibilities.INTERNAL && IrUtilsKt.getParentClassOrNull(declaration) != null && (containingModule = NameTablesKt.findOriginallyContainingModule(declaration)) != null) {
            nameBuilder.append("_$m_").append(containingModule.getName().toString());
        }
        Collection $this$ifNotEmpty$iv = declaration.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$calculateJsFunctionSignature_u24lambda_u240 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            Iterable $this$forEach$iv = $this$calculateJsFunctionSignature_u24lambda_u240;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeParameter typeParam = (IrTypeParameter)element$iv;
                boolean bl2 = false;
                nameBuilder.append("_").append(typeParam.getName().asString()).append(NameTablesKt.joinTypes(typeParam.getSuperTypes(), context2));
            }
        }
        block7: for (IrValueParameter parameter : declaration.getParameters()) {
            switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    StringBuilder stringBuilder = nameBuilder.append("_r$");
                    break;
                }
                case 3: {
                    StringBuilder stringBuilder = nameBuilder.append("_c$");
                    break;
                }
                case 4: {
                    StringBuilder stringBuilder = nameBuilder.append("_");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            nameBuilder.append(IrTypeUtilsKt.asString(parameter.getType(), context2));
            nameBuilder.append(NameTablesKt.joinTypes(org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.superTypes(parameter.getType()), context2));
            if (!Intrinsics.areEqual((Object)parameter.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_DEFAULT_PARAMETER())) continue;
            nameBuilder.append("?");
        }
        IrType it = declaration.getReturnType();
        boolean bl = false;
        if (context2.getInlineClassesUtils().isTypeInlined(it) || IrTypePredicatesKt.isUnit(it)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it, context2));
        }
        String string3 = Integer.toString(Math.abs(nameBuilder.toString().hashCode()), CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String signature = string3;
        String sanitizedName = NameTablesKt.sanitizeName(declarationName, false);
        return context2.getGlobalIrInterner().string(sanitizedName + '_' + signature + "_k$");
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(!IrDeclarationsKt.isStaticMethodOfClass(declaration))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(declaration.getDispatchReceiverParameter() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (MiscKt.hasStableJsName(declaration, context2)) {
            String string = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String declarationName = string;
            if (!(!StringsKt.endsWith$default((String)declarationName, (String)"_k$", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string2 = "Function " + IrUtilsKt.getFqNameWhenAvailable(declaration) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException(string2.toString());
            }
            return declarationName;
        }
        IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
        IrFunction declarationSignature = irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : declaration;
        return NameTablesKt.calculateJsFunctionSignature(declarationSignature, context2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name2, boolean withHash) {
        String string;
        void p0;
        char first;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (IdentifierPolicyKt.isValidES5Identifier(name2)) {
            return name2;
        }
        if (((CharSequence)name2).length() == 0) {
            return "_";
        }
        StringBuilder builder = new StringBuilder(name2.length() + (withHash ? 7 : 0));
        char $this$mangleIfNot$iv = first = StringsKt.first((CharSequence)name2);
        boolean $i$f$mangleIfNot = false;
        char c2 = $this$mangleIfNot$iv;
        StringBuilder stringBuilder = builder;
        boolean bl = false;
        boolean bl2 = IdentifierPolicyKt.isES5IdentifierStart((char)p0);
        stringBuilder.append(bl2 ? $this$mangleIfNot$iv : (char)'_');
        int idx = 1;
        int n2 = StringsKt.getLastIndex((CharSequence)name2);
        if (idx <= n2) {
            while (true) {
                void p02;
                char c3;
                char $this$mangleIfNot$iv2 = c3 = name2.charAt(idx);
                boolean $i$f$mangleIfNot2 = false;
                char c4 = $this$mangleIfNot$iv2;
                stringBuilder = builder;
                boolean bl3 = false;
                bl2 = IdentifierPolicyKt.isES5IdentifierPart((char)p02);
                stringBuilder.append(bl2 ? $this$mangleIfNot$iv2 : (char)'_');
                if (idx == n2) break;
                ++idx;
            }
        }
        if (withHash) {
            StringBuilder stringBuilder2 = new StringBuilder().append((Object)builder).append('_');
            String string2 = Integer.toString(Math.abs(name2.hashCode()), CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = stringBuilder2.append(string2).toString();
        } else {
            String string3 = builder.toString();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    public static /* synthetic */ String sanitizeName$default(String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return NameTablesKt.sanitizeName(string, bl);
    }

    @Nullable
    public static final String nameIfPropertyAccessor(@NotNull IrDeclarationWithName $this$nameIfPropertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$nameIfPropertyAccessor, (String)"<this>");
        if ($this$nameIfPropertyAccessor instanceof IrSimpleFunction) {
            String string;
            if (((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol() != null) {
                String string2;
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull((Object)irPropertySymbol);
                IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
                String string3 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                String name2 = string3;
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)$this$nameIfPropertyAccessor;
                if (Intrinsics.areEqual((Object)irSimpleFunction, (Object)property2.getGetter())) {
                    string2 = "get_";
                } else if (Intrinsics.areEqual((Object)irSimpleFunction, (Object)property2.getSetter())) {
                    string2 = "set_";
                } else {
                    IrExceptionBuilder irExceptionBuilder;
                    String message$iv = "";
                    boolean $i$f$irError = false;
                    IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                    boolean bl = false;
                    IrExceptionBuilder $this$nameIfPropertyAccessor_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                    boolean bl2 = false;
                    $this$nameIfPropertyAccessor_u24lambda_u240.withIrEntry("this", $this$nameIfPropertyAccessor);
                    IrExceptionBuilder builder$iv = irExceptionBuilder;
                    throw new IllegalStateException(builder$iv.buildString().toString());
                }
                String prefix = string2;
                string = prefix + name2;
            } else if (Intrinsics.areEqual((Object)$this$nameIfPropertyAccessor.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR())) {
                String string4 = AnnotationUtilsKt.getJsNameOrKotlinName($this$nameIfPropertyAccessor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                string = StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string4, (CharSequence)"<"), (CharSequence)">"), (String)"get-", (String)"get_", (boolean)false, (int)4, null), (String)"set-", (String)"set_", (boolean)false, (int)4, null);
            } else {
                string = null;
            }
            return string;
        }
        return null;
    }

    private static final CharSequence dump$lambda$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        IrDeclaration declaration = (IrDeclaration)pair.component1();
        String name2 = (String)pair.component2();
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        FqName decl = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration);
        Object object = decl;
        if (object == null) {
            object = declaration;
        }
        FqName declRef = object;
        return "---  " + declRef + " => " + name2;
    }

    private static final CharSequence joinTypes$lambda$0(JsIrBackendContext $context, IrType superType) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return IrTypeUtilsKt.asString(superType, $context);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

