/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

An abstract base class to connect this object with the lifetime of
another.


This class maintains a list of Objects and callbacks to call when this
object is deleted.

Optionally, "OwnedByObjects" property can be enabled so that when
the last referenced object is removed this object will be deleted.

C++ includes: sitkObjectOwnedBase.h
*/
public class ObjectOwnedBase {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected ObjectOwnedBase(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ObjectOwnedBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ObjectOwnedBase obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ObjectOwnedBase::~ObjectOwnedBase()=0
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ObjectOwnedBase(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
virtual std::string itk::simple::ObjectOwnedBase::GetName() const

Set object name.

*/
public  String getName() {
    return SimpleITKJNI.ObjectOwnedBase_getName(swigCPtr, this);
  }

  /**
virtual void itk::simple::ObjectOwnedBase::SetName(const std::string &amp;name)

Get object name.

*/
public  void setName(String name) {
    SimpleITKJNI.ObjectOwnedBase_setName(swigCPtr, this, name);
  }

}
