/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ProcessObject;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorString;

public class ImageSeriesWriter
extends ProcessObject {
    private transient long swigCPtr;

    protected ImageSeriesWriter(long l, boolean bl) {
        super(SimpleITKJNI.ImageSeriesWriter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ImageSeriesWriter imageSeriesWriter) {
        return imageSeriesWriter == null ? 0L : imageSeriesWriter.swigCPtr;
    }

    protected static long swigRelease(ImageSeriesWriter imageSeriesWriter) {
        long l = 0L;
        if (imageSeriesWriter != null) {
            if (!imageSeriesWriter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = imageSeriesWriter.swigCPtr;
            imageSeriesWriter.swigCMemOwn = false;
            imageSeriesWriter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_ImageSeriesWriter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ImageSeriesWriter() {
        this(SimpleITKJNI.new_ImageSeriesWriter(), true);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.ImageSeriesWriter_toString(this.swigCPtr, this);
    }

    public VectorString getRegisteredImageIOs() {
        return new VectorString(SimpleITKJNI.ImageSeriesWriter_getRegisteredImageIOs(this.swigCPtr, this), true);
    }

    public void setImageIO(String string) {
        SimpleITKJNI.ImageSeriesWriter_setImageIO(this.swigCPtr, this, string);
    }

    public String getImageIO() {
        return SimpleITKJNI.ImageSeriesWriter_getImageIO(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.ImageSeriesWriter_getName(this.swigCPtr, this);
    }

    public void setUseCompression(boolean bl) {
        SimpleITKJNI.ImageSeriesWriter_setUseCompression(this.swigCPtr, this, bl);
    }

    public boolean getUseCompression() {
        return SimpleITKJNI.ImageSeriesWriter_getUseCompression(this.swigCPtr, this);
    }

    public void useCompressionOn() {
        SimpleITKJNI.ImageSeriesWriter_useCompressionOn(this.swigCPtr, this);
    }

    public void useCompressionOff() {
        SimpleITKJNI.ImageSeriesWriter_useCompressionOff(this.swigCPtr, this);
    }

    public void setCompressionLevel(int n) {
        SimpleITKJNI.ImageSeriesWriter_setCompressionLevel(this.swigCPtr, this, n);
    }

    public int getCompressionLevel() {
        return SimpleITKJNI.ImageSeriesWriter_getCompressionLevel(this.swigCPtr, this);
    }

    public void setCompressor(String string) {
        SimpleITKJNI.ImageSeriesWriter_setCompressor(this.swigCPtr, this, string);
    }

    public String getCompressor() {
        return SimpleITKJNI.ImageSeriesWriter_getCompressor(this.swigCPtr, this);
    }

    public void setFileNames(VectorString vectorString) {
        SimpleITKJNI.ImageSeriesWriter_setFileNames(this.swigCPtr, this, VectorString.getCPtr(vectorString), vectorString);
    }

    public VectorString getFileNames() {
        return new VectorString(SimpleITKJNI.ImageSeriesWriter_getFileNames(this.swigCPtr, this), false);
    }

    public void execute(Image image) {
        SimpleITKJNI.ImageSeriesWriter_execute__SWIG_0(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    public void execute(Image image, VectorString vectorString, boolean bl, int n) {
        SimpleITKJNI.ImageSeriesWriter_execute__SWIG_1(this.swigCPtr, this, Image.getCPtr(image), image, VectorString.getCPtr(vectorString), vectorString, bl, n);
    }
}

