/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Pixel-wise addition of N images.


This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the input images must have a valid definition of the
operator+ with each other. This condition is required because
internally this filter will perform the operation


Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.

The total operation over one pixel will be


For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.


WARNING:
No numeric overflow checking is performed in this filter.

See:
 itk::simple::NaryAdd for the procedural interface


C++ includes: sitkNaryAddImageFilter.h
*/
public class NaryAddImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NaryAddImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NaryAddImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NaryAddImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NaryAddImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NaryAddImageFilter::~NaryAddImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NaryAddImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NaryAddImageFilter::NaryAddImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NaryAddImageFilter() {
    this(SimpleITKJNI.new_NaryAddImageFilter(), true);
  }

  /**
std::string itk::simple::NaryAddImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NaryAddImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NaryAddImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NaryAddImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.NaryAddImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
