/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

White top hat extracts local maxima that are larger than the
structuring element.


Top-hats are described in Chapter 4.5 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 itk::simple::WhiteTopHat for the procedural interface

 itk::WhiteTopHatImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkWhiteTopHatImageFilter.h
*/
public class WhiteTopHatImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected WhiteTopHatImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.WhiteTopHatImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(WhiteTopHatImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(WhiteTopHatImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::WhiteTopHatImageFilter::~WhiteTopHatImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_WhiteTopHatImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::WhiteTopHatImageFilter::WhiteTopHatImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  WhiteTopHatImageFilter() {
    this(SimpleITKJNI.new_WhiteTopHatImageFilter(), true);
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.WhiteTopHatImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.WhiteTopHatImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::WhiteTopHatImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.WhiteTopHatImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.WhiteTopHatImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::WhiteTopHatImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.WhiteTopHatImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public  void setSafeBorder(boolean SafeBorder) {
    SimpleITKJNI.WhiteTopHatImageFilter_setSafeBorder(swigCPtr, this, SafeBorder);
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public  void safeBorderOn() {
    SimpleITKJNI.WhiteTopHatImageFilter_safeBorderOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::WhiteTopHatImageFilter::SafeBorderOff()
*/
public  void safeBorderOff() {
    SimpleITKJNI.WhiteTopHatImageFilter_safeBorderOff(swigCPtr, this);
  }

  /**
bool itk::simple::WhiteTopHatImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public  boolean getSafeBorder() {
    return SimpleITKJNI.WhiteTopHatImageFilter_getSafeBorder(swigCPtr, this);
  }

  /**
std::string itk::simple::WhiteTopHatImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.WhiteTopHatImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::WhiteTopHatImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.WhiteTopHatImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::WhiteTopHatImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.WhiteTopHatImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
