/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.util.MessagePackReader;
import org.jmol.adapter.readers.cif.BCIFDataParser;
import org.jmol.adapter.readers.cif.BCIFDecoder;
import org.jmol.adapter.readers.cif.MMCifReader;

public class BCIFReader
extends MMCifReader {
    BCIFDataParser bcifParser;
    protected static int[] temp;
    private String version;
    String catName;
    private int colCount;

    @Override
    protected GenericCifDataParser getCifDataParser() {
        this.bcifParser = new BCIFDataParser(this, this.debugging);
        this.cifParser = this.bcifParser;
        return this.bcifParser;
    }

    @Override
    protected void setup(String fullPath, Map<String, Object> htParams, Object reader) {
        this.isBinary = true;
        this.setupASCR(fullPath, htParams, reader);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        long t = System.currentTimeMillis();
        this.binaryDoc.setBigEndian(true);
        Map<String, Object> msgMap = new MessagePackReader(this.binaryDoc, false).readMap();
        this.binaryDoc.close();
        String encoder = (String)msgMap.get("encoder");
        System.out.println("BCIFReader: BCIF encoder " + encoder);
        this.version = (String)msgMap.get("version");
        System.out.println("BCIFReader: BCIF version " + this.version);
        Map dataBlock = (Map)((Object[])msgMap.get("dataBlocks"))[0];
        System.out.println("BCIFReader processed MessagePack in " + (System.currentTimeMillis() - t) + " ms");
        this.getCifDataParser();
        Object[] categories = (Object[])dataBlock.get("categories");
        this.bcifParser.header = (String)dataBlock.get("header");
        for (int j = 0; j < categories.length; ++j) {
            Map cat = (Map)categories[j];
            if (cat.isEmpty()) continue;
            this.processCategory(cat);
        }
        System.out.println("BCIFReader processed binary file in " + (System.currentTimeMillis() - t) + " ms");
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        super.finalizeSubclassReader();
        BCIFDecoder.clearTemp();
    }

    private boolean processCategory(Map<String, Object> cat) throws Exception {
        String catName = ((String)cat.get("name")).toLowerCase();
        if (!this.isCategoryOfInterest(catName)) {
            return false;
        }
        this.bcifParser.initializeCategory(catName, BCIFDecoder.geMapInt(cat.get("rowCount"), null), (Object[])cat.get("columns"));
        this.processCategoryName(catName);
        return false;
    }

    private boolean isCategoryOfInterest(String catName) {
        switch (catName) {
            case "_entry": 
            case "_atom_site": 
            case "_atom_type": 
            case "_atom_sites": 
            case "_cell": 
            case "_struct_ncs_oper": 
            case "_pdbx_struct_oper_list": 
            case "_pdbx_struct_assembly_gen": 
            case "_struct_ref_seq_dif": 
            case "_struct_site_gen": 
            case "_chem_comp": 
            case "_struct_conf": 
            case "_struct_sheet_range": 
            case "_chem_comp_bond": 
            case "_struct_conn": {
                return true;
            }
        }
        return false;
    }

    private boolean processCategoryName(String catName) throws Exception {
        this.catName = catName;
        switch (catName) {
            case "_entry": {
                return this.processEntry();
            }
            case "_atom_site": {
                return this.processAtomSiteLoopBlock(false);
            }
            case "_atom_type": {
                return this.processAtomTypeLoopBlock();
            }
            case "_atom_sites": {
                return this.processAtomSites();
            }
            case "_cell": {
                return this.processCellBlock();
            }
        }
        switch (catName) {
            case "_struct_ncs_oper": 
            case "_pdbx_struct_oper_list": 
            case "_pdbx_struct_assembly_gen": 
            case "_struct_ref_seq_dif": 
            case "_struct_site_gen": 
            case "_chem_comp": 
            case "_struct_conf": 
            case "_struct_sheet_range": 
            case "_chem_comp_bond": 
            case "_struct_conn": {
                this.key0 = catName + ".";
                return this.processSubclassLoopBlock();
            }
        }
        return false;
    }

    private boolean processEntry() {
        this.bcifParser.decodeAndGetData(0);
        this.pdbID = this.bcifParser.fieldStr;
        return true;
    }

    private boolean processAtomSites() throws Exception {
        for (int i = 0; i < this.colCount; ++i) {
            this.bcifParser.decodeAndGetData(i);
            this.processUnitCellTransformMatrix();
        }
        return true;
    }

    private boolean processCellBlock() throws Exception {
        for (int i = 0; i < this.colCount; ++i) {
            this.bcifParser.decodeAndGetData(i);
            this.processCellParameter();
        }
        return true;
    }

    @Override
    protected void parseLoopParameters(String[] fields) throws Exception {
        this.bcifParser.parseDataBlockParameters(fields, null, null, this.key2col, this.col2key);
    }

    @Override
    protected boolean isFieldValid() {
        if (this.bcifParser.fieldStr != null) {
            this.firstChar = this.bcifParser.fieldStr.charAt(0);
        }
        return this.bcifParser.isFieldValid();
    }

    @Override
    protected int parseIntField() {
        return this.bcifParser.ifield == Integer.MIN_VALUE ? super.parseIntField() : this.bcifParser.ifield;
    }

    @Override
    protected float parseFloatField() {
        return this.bcifParser.dfield;
    }

    @Override
    protected float parseCartesianField() {
        return (float)Math.round(this.bcifParser.dfield * 1000.0f) / 1000.0f;
    }

    @Override
    protected int parseIntFieldTok(byte tok) {
        this.getFieldString(tok);
        return this.bcifParser.ifield;
    }

    @Override
    protected float getFloatColumnData(int i) {
        this.bcifParser.getColumnData(i);
        return this.bcifParser.dfield;
    }
}

