/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.InstrumentsDbTableModel;
import org.jsampler.view.InstrumentsDbTableView;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.event.InstrumentsDbAdapter;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;

public abstract class AbstractInstrumentsDbTable
extends JTable {
    private final DefaultCellEditor nameEditor;
    private final JTextField tfEditor = new JTextField();
    private DbDirectoryTreeNode directoryNode;
    private final InstrumentsDbTableRowSorter rowSorter;
    private String createdDirectoryName = null;
    private InstrumentsDbTableView view = null;
    private final String tablePrefix;
    private final EventHandler eventHandler = new EventHandler();

    public AbstractInstrumentsDbTable() {
        this("");
    }

    public AbstractInstrumentsDbTable(String string) {
        this(new InstrumentsDbTableModel(), string);
    }

    public AbstractInstrumentsDbTable(InstrumentsDbTableModel instrumentsDbTableModel, String string) {
        super(instrumentsDbTableModel);
        this.setView(CC.getViewConfig().getInstrumentsDbTableView());
        this.tablePrefix = string;
        this.loadColumnsVisibleState();
        this.loadColumnWidths();
        this.setAutoResizeMode(0);
        this.rowSorter = new InstrumentsDbTableRowSorter(this.getModel());
        this.setRowSorter(this.rowSorter);
        this.loadSortOrder();
        RowSorterListener rowSorterListener = new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent rowSorterEvent) {
                if (rowSorterEvent.getType() != RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                    return;
                }
                AbstractInstrumentsDbTable.this.rowSorterChanged();
            }
        };
        this.getRowSorter().addRowSorterListener(rowSorterListener);
        this.putClientProperty("JTable.autoStartsEdit", false);
        this.nameEditor = new DefaultCellEditor(this.tfEditor);
        this.nameEditor.setClickCountToStart(5);
        if (this.getModel().getShowDummyColumn()) {
            TableColumn tableColumn = this.getColumnModel().getColumn(this.getModel().getDummyColumnIndex());
            tableColumn.setPreferredWidth(10);
        }
    }

    @Override
    public InstrumentsDbTableModel getModel() {
        return (InstrumentsDbTableModel)super.getModel();
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 0) {
            return this.nameEditor;
        }
        return super.getCellEditor(n, n2);
    }

    public DbDirectoryTreeNode getSelectedDirectoryNode() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        n = this.convertRowIndexToModel(n);
        return this.getModel().getDirectoryNode(n);
    }

    public void setSelectedDirectory(String string) {
        int n = this.getModel().getDirectoryRowIndex(string);
        if (n == -1) {
            return;
        }
        if ((n = this.convertRowIndexToView(n)) == -1) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectedInstrument(String string) {
        int n = this.getModel().getInstrumentRowIndex(string);
        if (n == -1) {
            return;
        }
        if ((n = this.convertRowIndexToView(n)) == -1) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public DbDirectoryInfo[] getSelectedDirectories() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return new DbDirectoryInfo[0];
        }
        Vector<DbDirectoryInfo> vector = new Vector<DbDirectoryInfo>();
        for (int n : nArray) {
            DbDirectoryTreeNode dbDirectoryTreeNode = this.getModel().getDirectoryNode(this.convertRowIndexToModel(n));
            if (dbDirectoryTreeNode == null) continue;
            vector.add(dbDirectoryTreeNode.getInfo());
        }
        return vector.toArray(new DbDirectoryInfo[vector.size()]);
    }

    public DbInstrumentInfo[] getSelectedInstruments() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return new DbInstrumentInfo[0];
        }
        Vector<DbInstrumentInfo> vector = new Vector<DbInstrumentInfo>();
        for (int n : nArray) {
            DbInstrumentInfo dbInstrumentInfo = this.getModel().getInstrument(this.convertRowIndexToModel(n));
            if (dbInstrumentInfo == null) continue;
            vector.add(dbInstrumentInfo);
        }
        return vector.toArray(new DbInstrumentInfo[vector.size()]);
    }

    @Override
    public boolean editCellAt(int n, int n2) {
        if (!super.editCellAt(n, n2)) {
            return false;
        }
        Component component = this.getEditorComponent();
        if (component != null) {
            component.requestFocusInWindow();
        }
        return true;
    }

    public DbDirectoryTreeNode getParentDirectoryNode() {
        return this.directoryNode;
    }

    public void setParentDirectoryNode(DbDirectoryTreeNode dbDirectoryTreeNode) {
        this.getModel().setParentDirectoryNode(dbDirectoryTreeNode);
        if (this.directoryNode != null) {
            this.directoryNode.removeInstrumentsDbListener(this.getHandler());
        }
        this.directoryNode = dbDirectoryTreeNode;
        if (this.directoryNode != null) {
            this.directoryNode.addInstrumentsDbListener(this.getHandler());
        }
    }

    public String getCreatedDirectoryName() {
        return this.createdDirectoryName;
    }

    public void setCreatedDirectoryName(String string) {
        this.createdDirectoryName = string;
    }

    public Object getLeadObject() {
        if (this.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        int n = this.getSelectionModel().getLeadSelectionIndex();
        if (n < 0) {
            return null;
        }
        n = this.convertRowIndexToModel(n);
        return this.getModel().getValueAt(n, 0);
    }

    public void setView(InstrumentsDbTableView instrumentsDbTableView) {
        this.view = instrumentsDbTableView;
    }

    public InstrumentsDbTableView getView() {
        return this.view;
    }

    private JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public void loadColumnWidths() {
        this.loadColumnWidths(this.tablePrefix);
    }

    public void loadColumnWidths(String string) {
        InstrumentsDbTableModel instrumentsDbTableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        block15: for (int i = 0; i < instrumentsDbTableModel.getColumnCount(); ++i) {
            switch (instrumentsDbTableModel.getColumnType(i)) {
                case NAME: {
                    String string2 = string + "DbInstrumentsTable.nameColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case SIZE: {
                    String string2 = string + "DbInstrumentsTable.sizeColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case FORMAT_FAMILY: {
                    String string2 = string + "DbInstrumentsTable.formatFamilyColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case FORMAT_VERSION: {
                    String string2 = string + "DbInstrumentsTable.formatVersionColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case IS_DRUM: {
                    String string2 = string + "DbInstrumentsTable.isDrumColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case CREATED: {
                    String string2 = string + "DbInstrumentsTable.createdColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case MODIFIED: {
                    String string2 = string + "DbInstrumentsTable.modifiedColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case PRODUCT: {
                    String string2 = string + "DbInstrumentsTable.productColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case ARTISTS: {
                    String string2 = string + "DbInstrumentsTable.artistsColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case INSTRUMENT_FILE: {
                    String string2 = string + "DbInstrumentsTable.instrumentFileColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case INSTRUMENT_NR: {
                    String string2 = string + "DbInstrumentsTable.instrumentNrColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case KEYWORDS: {
                    String string2 = string + "DbInstrumentsTable.keywordsColumnWidth";
                    int n = this.preferences().getIntProperty(string2);
                    if (n <= 0) continue block15;
                    tableColumnModel.getColumn(i).setPreferredWidth(n);
                    continue block15;
                }
                case DUMMY: {
                    tableColumnModel.getColumn(i).setPreferredWidth(10);
                }
            }
        }
    }

    public void saveColumnWidths() {
        this.saveColumnWidths(this.tablePrefix);
    }

    public void saveColumnWidths(String string) {
        InstrumentsDbTableModel instrumentsDbTableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        block14: for (int i = 0; i < instrumentsDbTableModel.getColumnCount(); ++i) {
            switch (instrumentsDbTableModel.getColumnType(i)) {
                case NAME: {
                    String string2 = string + "DbInstrumentsTable.nameColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case SIZE: {
                    String string2 = string + "DbInstrumentsTable.sizeColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case FORMAT_FAMILY: {
                    String string2 = string + "DbInstrumentsTable.formatFamilyColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case FORMAT_VERSION: {
                    String string2 = string + "DbInstrumentsTable.formatVersionColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case IS_DRUM: {
                    String string2 = string + "DbInstrumentsTable.isDrumColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case CREATED: {
                    String string2 = string + "DbInstrumentsTable.createdColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case MODIFIED: {
                    String string2 = string + "DbInstrumentsTable.modifiedColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case PRODUCT: {
                    String string2 = string + "DbInstrumentsTable.productColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case ARTISTS: {
                    String string2 = string + "DbInstrumentsTable.artistsColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case INSTRUMENT_FILE: {
                    String string2 = string + "DbInstrumentsTable.instrumentFileColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case INSTRUMENT_NR: {
                    String string2 = string + "DbInstrumentsTable.instrumentNrColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                    continue block14;
                }
                case KEYWORDS: {
                    String string2 = string + "DbInstrumentsTable.keywordsColumnWidth";
                    this.preferences().setIntProperty(string2, tableColumnModel.getColumn(i).getWidth());
                }
            }
        }
    }

    public void loadColumnsVisibleState() {
        this.loadColumnsVisibleState(this.tablePrefix);
    }

    public void loadColumnsVisibleState(String string) {
        InstrumentsDbTableModel instrumentsDbTableModel = this.getModel();
        String string2 = string + "DbInstrumentsTable.ShowSizeColumn";
        instrumentsDbTableModel.setShowSizeColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowFormatFamilyColumn";
        instrumentsDbTableModel.setShowFormatFamilyColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowFormatVersionColumn";
        instrumentsDbTableModel.setShowFormatVersionColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowIsDrumColumn";
        instrumentsDbTableModel.setShowIsDrumColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowCreatedColumn";
        instrumentsDbTableModel.setShowCreatedColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowModifiedColumn";
        instrumentsDbTableModel.setShowModifiedColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowProductColumn";
        instrumentsDbTableModel.setShowProductColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowArtistsColumn";
        instrumentsDbTableModel.setShowArtistsColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowInstrumentFileColumn";
        instrumentsDbTableModel.setShowInstrumentFileColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowInstrumentNrColumn";
        instrumentsDbTableModel.setShowInstrumentNrColumn(this.preferences().getBoolProperty(string2));
        string2 = string + "DbInstrumentsTable.ShowKeywordsColumn";
        instrumentsDbTableModel.setShowKeywordsColumn(this.preferences().getBoolProperty(string2));
    }

    public void saveColumnsVisibleState() {
        this.saveColumnsVisibleState(this.tablePrefix);
    }

    public void saveColumnsVisibleState(String string) {
        InstrumentsDbTableModel instrumentsDbTableModel = this.getModel();
        String string2 = string + "DbInstrumentsTable.ShowSizeColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowSizeColumn());
        string2 = string + "DbInstrumentsTable.ShowFormatFamilyColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowFormatFamilyColumn());
        string2 = string + "DbInstrumentsTable.ShowFormatVersionColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowFormatVersionColumn());
        string2 = string + "DbInstrumentsTable.ShowIsDrumColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowIsDrumColumn());
        string2 = string + "DbInstrumentsTable.ShowCreatedColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowCreatedColumn());
        string2 = string + "DbInstrumentsTable.ShowModifiedColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowModifiedColumn());
        string2 = string + "DbInstrumentsTable.ShowProductColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowProductColumn());
        string2 = string + "DbInstrumentsTable.ShowArtistsColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowArtistsColumn());
        string2 = string + "DbInstrumentsTable.ShowInstrumentFileColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowInstrumentFileColumn());
        string2 = string + "DbInstrumentsTable.ShowInstrumentNrColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowInstrumentNrColumn());
        string2 = string + "DbInstrumentsTable.ShowKeywordsColumn";
        this.preferences().setBoolProperty(string2, instrumentsDbTableModel.getShowKeywordsColumn());
    }

    public void loadSortOrder() {
        this.loadSortOrder(this.tablePrefix);
    }

    public void loadSortOrder(String string) {
        boolean bl;
        int n = this.preferences().getIntProperty(this.tablePrefix + "sortOrder");
        boolean bl2 = bl = n < 0;
        if (n < 0) {
            n *= -1;
        }
        if (--n < 0 || n >= this.getModel().getColumnCount()) {
            this.getRowSorter().toggleSortOrder(0);
            CC.getLogger().warning("Unknown table column: " + n);
        } else {
            this.getRowSorter().toggleSortOrder(n);
            if (bl) {
                this.getRowSorter().toggleSortOrder(n);
            }
        }
    }

    private void rowSorterChanged() {
        List<RowSorter.SortKey> list = this.getRowSorter().getSortKeys();
        if (list.isEmpty()) {
            return;
        }
        RowSorter.SortKey sortKey = list.get(0);
        int n = sortKey.getColumn() + 1;
        if (sortKey.getSortOrder() == SortOrder.UNSORTED) {
            return;
        }
        if (sortKey.getSortOrder() == SortOrder.DESCENDING) {
            n *= -1;
        }
        this.preferences().setIntProperty(this.tablePrefix + "sortOrder", n);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    extends InstrumentsDbAdapter {
        private EventHandler() {
        }

        @Override
        public void directoryCountChanged(InstrumentsDbEvent instrumentsDbEvent) {
            String string = AbstractInstrumentsDbTable.this.getModel().getRenamedDirectory();
            int n = AbstractInstrumentsDbTable.this.getModel().getDirectoryRowIndex(string);
            if (n != -1) {
                AbstractInstrumentsDbTable.this.setSelectedDirectory(string);
                AbstractInstrumentsDbTable.this.getModel().setRenamedDirectory(null);
            }
            if ((n = AbstractInstrumentsDbTable.this.getModel().getDirectoryRowIndex(AbstractInstrumentsDbTable.this.getCreatedDirectoryName())) != -1 && (n = AbstractInstrumentsDbTable.this.convertRowIndexToView(n)) != -1) {
                AbstractInstrumentsDbTable.this.getSelectionModel().setSelectionInterval(n, n);
                AbstractInstrumentsDbTable.this.editCellAt(n, 0);
                Component component = AbstractInstrumentsDbTable.this.nameEditor.getComponent();
                if (component instanceof JTextField) {
                    ((JTextField)component).selectAll();
                }
                AbstractInstrumentsDbTable.this.setCreatedDirectoryName(null);
            }
        }

        @Override
        public void instrumentCountChanged(InstrumentsDbEvent instrumentsDbEvent) {
            String string = AbstractInstrumentsDbTable.this.getModel().getRenamedInstrument();
            int n = AbstractInstrumentsDbTable.this.getModel().getInstrumentRowIndex(string);
            if (n != -1) {
                AbstractInstrumentsDbTable.this.setSelectedInstrument(string);
                AbstractInstrumentsDbTable.this.getModel().setRenamedInstrument(null);
            }
        }
    }

    private class InstrumentsDbTableRowSorter
    extends TableRowSorter<InstrumentsDbTableModel> {
        InstrumentsDbTableRowSorter(InstrumentsDbTableModel instrumentsDbTableModel) {
            super(instrumentsDbTableModel);
        }

        @Override
        public Comparator<?> getComparator(int n) {
            Comparator comparator = ((InstrumentsDbTableModel)this.getModel()).getComparator(n);
            if (comparator != null) {
                return comparator;
            }
            return super.getComparator(n);
        }

        @Override
        protected boolean useToString(int n) {
            return ((InstrumentsDbTableModel)this.getModel()).getComparator(n) == null;
        }

        @Override
        public boolean isSortable(int n) {
            return ((InstrumentsDbTableModel)this.getModel()).isSortable(n);
        }
    }
}

