/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18n {
    private Locale currentLocale = null;
    private ResourceBundle buttonLabels;
    private ResourceBundle errors;
    private ResourceBundle labels;
    private ResourceBundle logMessages;
    private ResourceBundle menuLabels;
    private ResourceBundle messages;
    private String buttonsBundle;
    private String errorsBundle;
    private String labelsBundle;
    private String logsBundle;
    private String menusBundle;
    private String messagesBundle;

    public void setCurrentLocale(String language, String country) {
        this.currentLocale = new Locale(language, country);
        this.buttonLabels = this.buttonsBundle == null ? null : ResourceBundle.getBundle(this.buttonsBundle, this.getCurrentLocale());
        this.labels = this.labelsBundle == null ? null : ResourceBundle.getBundle(this.labelsBundle, this.getCurrentLocale());
        this.menuLabels = this.menusBundle == null ? null : ResourceBundle.getBundle(this.menusBundle, this.getCurrentLocale());
        this.errors = this.errorsBundle == null ? null : ResourceBundle.getBundle(this.errorsBundle, this.getCurrentLocale());
        this.messages = this.messagesBundle == null ? null : ResourceBundle.getBundle(this.messagesBundle, this.getCurrentLocale());
        this.logMessages = this.logsBundle == null ? null : ResourceBundle.getBundle(this.logsBundle, this.getCurrentLocale());
    }

    public Locale getCurrentLocale() {
        if (this.currentLocale == null) {
            this.setCurrentLocale("en", "US");
        }
        return this.currentLocale;
    }

    public void setButtonsBundle(String baseName) {
        this.buttonsBundle = baseName;
        this.buttonLabels = this.buttonsBundle == null ? null : ResourceBundle.getBundle(this.buttonsBundle, this.getCurrentLocale());
    }

    public void setLabelsBundle(String baseName) {
        this.labelsBundle = baseName;
        this.labels = this.labelsBundle == null ? null : ResourceBundle.getBundle(this.labelsBundle, this.getCurrentLocale());
    }

    public void setMenusBundle(String baseName) {
        this.menusBundle = baseName;
        this.menuLabels = this.menusBundle == null ? null : ResourceBundle.getBundle(this.menusBundle, this.getCurrentLocale());
    }

    public void setErrorsBundle(String baseName) {
        this.errorsBundle = baseName;
        this.errors = this.errorsBundle == null ? null : ResourceBundle.getBundle(this.errorsBundle, this.getCurrentLocale());
    }

    public void setMessagesBundle(String baseName) {
        this.messagesBundle = baseName;
        this.messages = this.messagesBundle == null ? null : ResourceBundle.getBundle(this.messagesBundle, this.getCurrentLocale());
    }

    public void setLogsBundle(String baseName) {
        this.logsBundle = baseName;
        this.logMessages = this.logsBundle == null ? null : ResourceBundle.getBundle(this.logsBundle, this.getCurrentLocale());
    }

    private String getString(String key, ResourceBundle rb) {
        return rb.getString(key);
    }

    private String getString(String pattern, ResourceBundle rb, Object[] arguments) {
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(this.getCurrentLocale());
        mf.applyPattern(this.getString(pattern, rb));
        return mf.format(arguments);
    }

    public String getButtonLabel(String key) {
        return this.getString(key, this.buttonLabels);
    }

    public String getButtonLabel(String pattern, Object ... arguments) {
        return this.getString(pattern, this.buttonLabels, arguments);
    }

    public String getError(String key) {
        return this.getString(key, this.errors);
    }

    public String getError(String pattern, Object ... arguments) {
        return this.getString(pattern, this.errors, arguments);
    }

    public String getLabel(String key) {
        return this.getString(key, this.labels);
    }

    public String getLabel(String pattern, Object ... arguments) {
        return this.getString(pattern, this.labels, arguments);
    }

    public String getLogMessage(String key) {
        return this.getString(key, this.logMessages);
    }

    public String getLogMessage(String pattern, Object ... arguments) {
        return this.getString(pattern, this.logMessages, arguments);
    }

    public String getMenuLabel(String key) {
        return this.getString(key, this.menuLabels);
    }

    public String getMenuLabel(String pattern, Object ... arguments) {
        return this.getString(pattern, this.menuLabels, arguments);
    }

    public String getMessage(String key) {
        return this.getString(key, this.messages);
    }

    public String getMessage(String pattern, Object ... arguments) {
        return this.getString(pattern, this.messages, arguments);
    }
}

