/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;
import java.util.prefs.Preferences;

public class JSPrefs
extends PropertyChangeSupport {
    public static final String GLOBAL_VOICE_LIMIT = "globalVoiceLimit";
    public static final String GLOBAL_STREAM_LIMIT = "globalStreamLimit";
    public static final String USE_CHANNEL_DEFAULTS = "samplerChannel.useDefaultActions";
    public static final String DEFAULT_ENGINE = "defaultEngine";
    public static final String DEFAULT_MIDI_INPUT = "defaultMidiInput";
    public static final String DEFAULT_AUDIO_OUTPUT = "defaultAudioOutput";
    public static final String DEFAULT_MIDI_INSTRUMENT_MAP = "defaultMidiInstrumentMap";
    public static final String DEFAULT_CHANNEL_VOLUME = "defaultChannelVolume";
    public static final String DEFAULT_MIDI_DRIVER = "defaultMidiDriver";
    public static final String DEFAULT_AUDIO_DRIVER = "defaultAudioDriver";
    public static final String VOL_MEASUREMENT_UNIT_DECIBEL = "volMeasurementUnitDecibel";
    public static final String EXPORT_MIDI_MAPS_TO_SESSION_SCRIPT = "exportMidiMapsToSessionScript";
    public static final String LOAD_MIDI_INSTRUMENTS_IN_BACKGROUND = "loadMidiInstrumentsInBackground";
    public static final String MANUAL_SERVER_SELECT_ON_STARTUP = "manualServerSelectOnStartup";
    public static final String LAUNCH_BACKEND_LOCALLY = "launchBackednLocally";
    public static final String BACKEND_LAUNCH_COMMAND = "backendLaunchCommand";
    public static final String BACKEND_LAUNCH_DELAY = "backendLaunchDelay";
    public static final String SERVER_INDEX = "serverIndex";
    public static final String FIRST_MIDI_BANK_NUMBER = "firstMidiBankNumber";
    public static final String FIRST_MIDI_PROGRAM_NUMBER = "firstMidiProgramNumber";
    public static final String SOCKET_READ_TIMEOUT = "socketReadTimeout";
    private final String pathName;
    private final Preferences userPrefs;

    public JSPrefs(String string) {
        super(new Object());
        this.pathName = string;
        this.userPrefs = Preferences.userRoot().node(string);
    }

    private Preferences user() {
        return this.userPrefs;
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, this.getDefaultStringValue(string));
    }

    public String getStringProperty(String string, String string2) {
        return this.user().get(string, string2);
    }

    public void setStringProperty(String string, String string2) {
        String string3 = this.getStringProperty(string);
        if (string2 == null) {
            this.user().remove(string);
        } else {
            this.user().put(string, string2);
        }
        this.firePropertyChange(string, string3, string2);
    }

    public String getDefaultStringValue(String string) {
        if (BACKEND_LAUNCH_COMMAND.equals(string)) {
            return "linuxsampler";
        }
        return null;
    }

    public String[] getStringListProperty(String string) {
        return this.getStringListProperty(string, this.getDefaultStringListValue(string));
    }

    public String[] getStringListProperty(String string, String[] stringArray) {
        String string2 = this.user().get(string, null);
        if (string2 == null) {
            return stringArray;
        }
        if (string2.length() == 0) {
            return new String[0];
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        Vector<String> vector = new Vector<String>();
        try {
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                vector.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setStringListProperty(String string, String[] stringArray) {
        String[] stringArray2 = this.getStringListProperty(string);
        if (stringArray == null) {
            this.user().remove(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : stringArray) {
                stringBuffer.append(string2).append("\n");
            }
            this.user().put(string, stringBuffer.toString());
        }
        this.firePropertyChange(string, stringArray2, stringArray);
    }

    public String[] getDefaultStringListValue(String string) {
        return new String[0];
    }

    public int getIntProperty(String string) {
        return this.getIntProperty(string, this.getDefaultIntValue(string));
    }

    public int getIntProperty(String string, int n) {
        return this.user().getInt(string, n);
    }

    public int getDefaultIntValue(String string) {
        if (GLOBAL_VOICE_LIMIT.equals(string)) {
            return 64;
        }
        if (GLOBAL_STREAM_LIMIT.equals(string)) {
            return 90;
        }
        if (SOCKET_READ_TIMEOUT.equals(string)) {
            return 90;
        }
        if (FIRST_MIDI_BANK_NUMBER.equals(string)) {
            return 1;
        }
        if (FIRST_MIDI_PROGRAM_NUMBER.equals(string)) {
            return 1;
        }
        if (BACKEND_LAUNCH_DELAY.equals(string)) {
            return 3;
        }
        return 0;
    }

    public void setIntProperty(String string, int n) {
        int n2 = this.getIntProperty(string);
        this.user().putInt(string, n);
        this.firePropertyChange(string, n2, n);
    }

    public boolean getBoolProperty(String string) {
        return this.getBoolProperty(string, this.getDefaultBoolValue(string));
    }

    public boolean getBoolProperty(String string, boolean bl) {
        return this.user().getBoolean(string, bl);
    }

    public void setBoolProperty(String string, boolean bl) {
        boolean bl2 = this.getBoolProperty(string);
        this.user().putBoolean(string, bl);
        this.firePropertyChange(string, bl2, bl);
    }

    public boolean getDefaultBoolValue(String string) {
        if (VOL_MEASUREMENT_UNIT_DECIBEL.equals(string)) {
            return true;
        }
        if (EXPORT_MIDI_MAPS_TO_SESSION_SCRIPT.equals(string)) {
            return true;
        }
        if (LOAD_MIDI_INSTRUMENTS_IN_BACKGROUND.equals(string)) {
            return true;
        }
        return LAUNCH_BACKEND_LOCALLY.equals(string);
    }
}

