/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.view.BasicIconSet;
import org.jsampler.view.InstrumentsDbTableView;
import org.jsampler.view.InstrumentsDbTreeView;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.JSViewConfig;
import org.jsampler.view.fantasia.AudioDevicesPane;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.MidiDevicesPane;
import org.jsampler.view.fantasia.Res;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel;

public class ViewConfig
extends JSViewConfig {
    private InstrumentsDbTreeView instrumentsDbTreeView = new TreeView();
    private InstrumentsDbTableView instrumentsDbTableView = new TableView();
    private BasicIconSet basicIconSet = new IconSet();
    private Map nativeMenuPropsMap = null;
    private Map menuPropsMap = null;

    public ViewConfig() {
        try {
            if (this.isUsingScreenMenuBar()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                this.nativeMenuPropsMap = this.getMenuProperties();
            }
            UIManager.setLookAndFeel(new SubstanceRavenGraphiteLookAndFeel());
            UIManager.put("substancelaf.watermark.visible", Boolean.FALSE);
            UIManager.put("substancelaf.tabbedPaneContentBorderKind", (Object)SubstanceConstants.TabContentPaneBorderKind.SINGLE_FULL);
            if (this.isUsingScreenMenuBar()) {
                this.menuPropsMap = this.getMenuProperties();
                this.setNativeMenuProperties();
            }
            if (!this.preferences().getBoolProperty("TurnOffCustomWindowDecoration")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            Res.loadTheme(this.preferences().getStringProperty("Theme"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNativeMenuProperties() {
        this.setMenuProperties(this.nativeMenuPropsMap);
    }

    public void restoreMenuProperties() {
        this.setMenuProperties(this.menuPropsMap);
    }

    private void setMenuProperties(Map map) {
        if (map == null) {
            return;
        }
        for (Object k : map.keySet()) {
            UIManager.put(k, map.get(k));
        }
    }

    public Map getMenuProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MenuBarUI", UIManager.get("MenuBarUI"));
        hashMap.put("MenuUI", UIManager.get("MenuUI"));
        hashMap.put("MenuItemUI", UIManager.get("MenuItemUI"));
        hashMap.put("CheckBoxMenuItemUI", UIManager.get("CheckBoxMenuItemUI"));
        hashMap.put("RadioButtonMenuItemUI", UIManager.get("RadioButtonMenuItemUI"));
        hashMap.put("PopupMenuUI", UIManager.get("PopupMenuUI"));
        return hashMap;
    }

    @Override
    public JSPrefs preferences() {
        return FantasiaPrefs.preferences();
    }

    @Override
    public String exportSessionViewConfig() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        MainFrame mainFrame = (MainFrame)CC.getMainFrame();
        for (int i = 0; i < mainFrame.getChannelsPaneCount(); ++i) {
            this.exportSamplerChannels(stringBuffer, i);
        }
        MidiDevicesPane midiDevicesPane = mainFrame.getRightSidePane().getDevicesPane().getMidiDevicesPane();
        for (int i = 0; i < midiDevicesPane.getDevicePaneCount(); ++i) {
            stringBuffer.append("#jsampler.fantasia: [MIDI device]\r\n");
            n = midiDevicesPane.getDevicePaneAt(i).isOptionsPaneExpanded();
            stringBuffer.append("#jsampler.fantasia: expanded = ").append(n != 0).append("\r\n");
            stringBuffer.append("#\r\n");
        }
        AudioDevicesPane audioDevicesPane = mainFrame.getRightSidePane().getDevicesPane().getAudioDevicesPane();
        for (n = 0; n < audioDevicesPane.getDevicePaneCount(); ++n) {
            stringBuffer.append("#jsampler.fantasia: [audio device]\r\n");
            boolean bl = audioDevicesPane.getDevicePaneAt(n).isOptionsPaneExpanded();
            stringBuffer.append("#jsampler.fantasia: expanded = ").append(bl).append("\r\n");
            stringBuffer.append("#\r\n");
        }
        return stringBuffer.toString();
    }

    private void exportSamplerChannels(StringBuffer stringBuffer, int n) {
        JSMainFrame jSMainFrame = CC.getMainFrame();
        for (int i = 0; i < jSMainFrame.getChannelsPane(n).getChannelCount(); ++i) {
            Channel channel = (Channel)jSMainFrame.getChannelsPane(n).getChannel(i);
            stringBuffer.append("#jsampler.fantasia: [channel]\r\n");
            stringBuffer.append("#jsampler.fantasia: channelLane = ");
            stringBuffer.append(n + 1).append("\r\n");
            switch (channel.getViewTracker().getOriginalView().getType()) {
                case SMALL: {
                    stringBuffer.append("#jsampler.fantasia: viewType = SMALL\r\n");
                    break;
                }
                case NORMAL: {
                    stringBuffer.append("#jsampler.fantasia: viewType = NORMAL\r\n");
                }
            }
            boolean bl = channel.getViewTracker().getOriginalView().isOptionsButtonSelected();
            stringBuffer.append("#jsampler.fantasia: expanded = ").append(bl).append("\r\n");
            stringBuffer.append("#\r\n");
        }
    }

    @Override
    public InstrumentsDbTreeView getInstrumentsDbTreeView() {
        return this.instrumentsDbTreeView;
    }

    @Override
    public InstrumentsDbTableView getInstrumentsDbTableView() {
        return this.instrumentsDbTableView;
    }

    @Override
    public BasicIconSet getBasicIconSet() {
        return this.basicIconSet;
    }

    @Override
    public boolean getInstrumentsDbSupport() {
        return true;
    }

    private class IconSet
    implements BasicIconSet {
        private IconSet() {
        }

        @Override
        public ImageIcon getApplicationIcon() {
            return Res.iconAppIcon;
        }

        @Override
        public Icon getBack16Icon() {
            return Res.iconBack16;
        }

        @Override
        public Icon getUp16Icon() {
            return Res.iconUp16;
        }

        @Override
        public Icon getForward16Icon() {
            return Res.iconNext16;
        }

        @Override
        public Icon getReload16Icon() {
            return Res.iconReload16;
        }

        @Override
        public Icon getPreferences16Icon() {
            return Res.iconPreferences16;
        }

        @Override
        public Icon getWarning32Icon() {
            return Res.iconWarning32;
        }

        @Override
        public Icon getQuestion32Icon() {
            return Res.iconQuestion32;
        }
    }

    private static class TableView
    implements InstrumentsDbTableView {
        private TableView() {
        }

        @Override
        public Icon getFolderIcon() {
            return Res.iconFolder16;
        }

        @Override
        public Icon getInstrumentIcon() {
            return Res.iconInstrument16;
        }

        @Override
        public Icon getGigInstrumentIcon() {
            return Res.iconInstrument16;
        }
    }

    private class TreeView
    implements InstrumentsDbTreeView {
        private TreeView() {
        }

        @Override
        public Icon getRootIcon() {
            return Res.iconDb16;
        }

        @Override
        public Icon getClosedIcon() {
            return Res.iconFolder16;
        }

        @Override
        public Icon getOpenIcon() {
            return Res.iconFolderOpen16;
        }

        @Override
        public Icon getInstrumentIcon() {
            return Res.iconInstrument16;
        }

        @Override
        public Icon getGigInstrumentIcon() {
            return Res.iconInstrument16;
        }
    }
}

