/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;

public class SharePartitionKey {
    protected final String groupId;
    protected final TopicIdPartition topicIdPartition;

    public SharePartitionKey(String groupId, TopicIdPartition topicIdPartition) {
        this.groupId = Objects.requireNonNull(groupId);
        this.topicIdPartition = Objects.requireNonNull(topicIdPartition);
    }

    private SharePartitionKey(String groupId, Uuid topicId, int partition) {
        this(groupId, topicId, null, partition);
    }

    private SharePartitionKey(String groupId, Uuid topicId, String topic, int partition) {
        this(groupId, new TopicIdPartition(Objects.requireNonNull(topicId), new TopicPartition(topic, partition)));
    }

    public String groupId() {
        return this.groupId;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public Uuid topicId() {
        return this.topicIdPartition.topicId();
    }

    public int partition() {
        return this.topicIdPartition.partition();
    }

    public static SharePartitionKey getInstance(String groupId, TopicIdPartition topicIdPartition) {
        return SharePartitionKey.getInstance(groupId, topicIdPartition.topicId(), topicIdPartition.partition());
    }

    public static SharePartitionKey getInstance(String key) {
        SharePartitionKey.validate(key);
        String[] tokens = key.split(":");
        return new SharePartitionKey(tokens[0].trim(), Uuid.fromString((String)tokens[1]), Integer.parseInt(tokens[2]));
    }

    public static void validate(String key) {
        Objects.requireNonNull(key, "Share partition key cannot be null");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Share partition key cannot be empty");
        }
        String[] tokens = key.split(":");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Invalid key format: expected - groupId:topicId:partition, found -  " + key);
        }
        if (tokens[0].trim().isEmpty()) {
            throw new IllegalArgumentException("GroupId must be alphanumeric string");
        }
        try {
            Uuid.fromString((String)tokens[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid topic ID: " + tokens[1], e);
        }
        try {
            Integer.parseInt(tokens[2]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid partition: " + tokens[2], e);
        }
    }

    public static SharePartitionKey getInstance(String groupId, Uuid topicId, int partition) {
        return new SharePartitionKey(groupId, topicId, partition);
    }

    public String asCoordinatorKey() {
        return SharePartitionKey.asCoordinatorKey(this.groupId(), this.topicId(), this.partition());
    }

    public static String asCoordinatorKey(String groupId, Uuid topicId, int partition) {
        return String.format("%s:%s:%d", groupId, topicId, partition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SharePartitionKey that = (SharePartitionKey)obj;
        return this.groupId.equals(that.groupId) && Objects.equals(this.topicIdPartition, that.topicIdPartition);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.topicIdPartition);
    }

    public String toString() {
        return "SharePartitionKey{groupId=" + this.groupId + ", topicIdPartition=" + String.valueOf(this.topicIdPartition) + "}";
    }
}

