/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.FetchBuilderBasicValued;
import org.hibernate.query.results.MissingSqlSelectionException;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteFetchBuilder;
import org.hibernate.query.results.internal.complete.ModelPartReferenceBasic;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderBasicPart
implements CompleteFetchBuilder,
FetchBuilderBasicValued,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart referencedModelPart;
    private final String selectionAlias;

    public CompleteFetchBuilderBasicPart(NavigablePath navigablePath, BasicValuedModelPart referencedModelPart, String selectionAlias) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
        this.selectionAlias = selectionAlias;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.referencedModelPart;
    }

    @Override
    public List<String> getColumnAliases() {
        return Collections.singletonList(this.selectionAlias);
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        JdbcMapping jdbcMapping;
        String selectedAlias;
        int jdbcPosition;
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        String mappedTable = this.referencedModelPart.getContainingTableExpression();
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, this.referencedModelPart, mappedTable);
        if (this.selectionAlias != null) {
            try {
                jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.selectionAlias);
            }
            catch (Exception e) {
                throw new MissingSqlSelectionException("ResultSet mapping specified selected-alias `" + this.selectionAlias + "` which was not part of the ResultSet", e);
            }
            selectedAlias = this.selectionAlias;
        } else {
            if (!creationStateImpl.arePositionalSelectionsAllowed()) {
                throw new AssertionFailure("Positional SQL selection resolution not allowed");
            }
            jdbcPosition = creationStateImpl.getNumberOfProcessedSelections() + 1;
            selectedAlias = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        }
        BasicValuedModelPart basicValuedModelPart = this.referencedModelPart;
        if (basicValuedModelPart instanceof DiscriminatorMapping) {
            DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)basicValuedModelPart;
            jdbcMapping = discriminatorMapping.getUnderlyingJdbcMapping();
        } else {
            jdbcMapping = this.referencedModelPart.getJdbcMapping();
        }
        JdbcMapping jdbcMapping2 = jdbcMapping;
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.referencedModelPart.getSelectablePath(), jdbcMapping2), processingState -> new ResultSetMappingSqlSelection(valuesArrayPosition, this.referencedModelPart));
        return (BasicFetch)parent.generateFetchableFetch(this.referencedModelPart, fetchPath, FetchTiming.IMMEDIATE, true, selectedAlias, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteFetchBuilderBasicPart that = (CompleteFetchBuilderBasicPart)o;
        return this.navigablePath.equals(that.navigablePath) && this.referencedModelPart.equals(that.referencedModelPart) && Objects.equals(this.selectionAlias, that.selectionAlias);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.referencedModelPart.hashCode();
        result = 31 * result + (this.selectionAlias != null ? this.selectionAlias.hashCode() : 0);
        return result;
    }
}

